/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.message.stream;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.security.message.stream.LogStringsMessages;
import com.sun.xml.ws.spi.db.XMLBridge;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class LazyStreamBasedMessage
extends Message {
    protected static final Logger logger = Logger.getLogger("com.sun.xml.wss.jaxws.impl", "com.sun.xml.wss.jaxws.impl.logging.LogStrings");
    private StreamSOAPCodec codec = null;
    private boolean readMessage = false;
    private XMLStreamReader reader = null;
    private Message message = null;
    AttachmentSet as = null;
    private MutableXMLStreamBuffer buffer = null;
    private static final boolean MTOM_LARGEDATA = Boolean.getBoolean("MTOM_LARGEDATA");

    public LazyStreamBasedMessage(XMLStreamReader message, StreamSOAPCodec codec) {
        this.reader = message;
        this.codec = codec;
    }

    public LazyStreamBasedMessage(XMLStreamReader message, StreamSOAPCodec codec, AttachmentSet as) {
        this.reader = message;
        this.codec = codec;
        this.as = as;
    }

    public StreamSOAPCodec getCodec() {
        return this.codec;
    }

    private synchronized void cacheMessage() {
        if (!this.readMessage) {
            this.message = this.as == null ? this.codec.decode(this.reader) : this.codec.decode(this.reader, this.as);
            this.readMessage = true;
        }
    }

    public boolean hasHeaders() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.hasHeaders();
    }

    public HeaderList getHeaders() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return (HeaderList)this.message.getHeaders();
    }

    @NotNull
    public AttachmentSet getAttachments() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.getAttachments();
    }

    public boolean isOneWay(@NotNull WSDLPort port) {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.isOneWay(port);
    }

    @Nullable
    public String getPayloadLocalPart() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.getPayloadLocalPart();
    }

    public String getPayloadNamespaceURI() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.getPayloadNamespaceURI();
    }

    public boolean hasPayload() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.hasPayload();
    }

    public Source readEnvelopeAsSource() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.readEnvelopeAsSource();
    }

    public Source readPayloadAsSource() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.readPayloadAsSource();
    }

    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.readAsSOAPMessage();
    }

    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        throw new UnsupportedOperationException();
    }

    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return (T)this.message.readPayloadAsJAXB(bridge);
    }

    public XMLStreamReader readPayload() throws XMLStreamException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.readPayload();
    }

    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        this.message.writePayloadTo(sw);
    }

    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        this.message.writeTo(sw);
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        this.message.writeTo(contentHandler, errorHandler);
    }

    public Message copy() {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return this.message.copy();
    }

    public XMLStreamReader readMessage() {
        if (!this.readMessage) {
            return this.reader;
        }
        if (this.buffer == null) {
            try {
                this.buffer = new MutableXMLStreamBuffer();
                XMLStreamWriter writer = this.buffer.createFromXMLStreamWriter();
                this.message.writeTo(writer);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSSMSG_0001_PROBLEM_CACHING(), ex);
            }
        }
        try {
            this.reader = this.buffer.readAsXMLStreamReader();
            return this.reader;
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSSMSG_0002_ERROR_READING_BUFFER(), ex);
            return null;
        }
    }

    public void print() throws XMLStreamException {
        if (this.readMessage) {
            try {
                this.message.readAsSOAPMessage().writeTo((OutputStream)System.out);
                return;
            }
            catch (SOAPException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSSMSG_0003_ERROR_PRINT(), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSSMSG_0003_ERROR_PRINT(), ex);
            }
        }
        if (this.buffer == null) {
            this.buffer = new MutableXMLStreamBuffer();
            this.buffer.createFromXMLStreamReader(this.reader);
            this.reader = this.buffer.readAsXMLStreamReader();
        }
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        this.buffer.writeToXMLStreamWriter(xof.createXMLStreamWriter(System.out));
    }

    public <T> T readPayloadAsJAXB(XMLBridge<T> bridge) throws JAXBException {
        if (!this.readMessage) {
            this.cacheMessage();
        }
        return (T)this.message.readPayloadAsJAXB(bridge);
    }

    public String getBodyEpilogue() {
        return this.message instanceof StreamMessage ? ((StreamMessage)this.message).getBodyEpilogue() : null;
    }

    public String getBodyPrologue() {
        return this.message instanceof StreamMessage ? ((StreamMessage)this.message).getBodyPrologue() : null;
    }

    public static boolean mtomLargeData() {
        return MTOM_LARGEDATA;
    }
}

