/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.addressing.policy;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

public class WsawAddressingPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsawAddressingPolicyMapConfigurator.class);

    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LOGGER.entering(new Object[]{policyMap, model, wsBinding});
        ArrayList<PolicySubject> subjects = new ArrayList<PolicySubject>();
        if (policyMap != null) {
            AddressingFeature addressingFeature = (AddressingFeature)wsBinding.getFeature(AddressingFeature.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("addressingFeature = " + addressingFeature);
            }
            if (addressingFeature != null && addressingFeature.isEnabled()) {
                this.addWsawUsingAddressingForCompatibility(subjects, policyMap, model, addressingFeature);
            }
        }
        LOGGER.exiting(subjects);
        return subjects;
    }

    private void addWsawUsingAddressingForCompatibility(Collection<PolicySubject> subjects, PolicyMap policyMap, SEIModel model, AddressingFeature addressingFeature) throws PolicyException {
        AddressingVersion addressingVersion = AddressingVersion.fromFeature((WebServiceFeature)addressingFeature);
        QName usingAddressing = new QName(addressingVersion.policyNsUri, "UsingAddressing");
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)model.getServiceQName(), (QName)model.getPortName());
        Policy existingPolicy = policyMap.getEndpointEffectivePolicy(endpointKey);
        if (existingPolicy == null || !existingPolicy.contains(usingAddressing)) {
            QName bindingName = model.getBoundPortTypeName();
            WsdlBindingSubject wsdlSubject = WsdlBindingSubject.createBindingSubject((QName)bindingName);
            Policy addressingPolicy = this.createWsawAddressingPolicy(bindingName, usingAddressing, addressingFeature.isRequired());
            PolicySubject addressingPolicySubject = new PolicySubject((Object)wsdlSubject, addressingPolicy);
            subjects.add(addressingPolicySubject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added addressing policy with ID \"" + addressingPolicy.getIdOrName() + "\" to binding element \"" + bindingName + "\"");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Addressing policy exists already, doing nothing");
        }
    }

    private Policy createWsawAddressingPolicy(QName bindingName, QName assertionName, boolean isRequired) {
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        ArrayList<AddressingAssertion> assertions = new ArrayList<AddressingAssertion>(1);
        AssertionData addressingData = AssertionData.createAssertionData((QName)assertionName);
        if (!isRequired) {
            addressingData.setOptionalAttribute(true);
        }
        assertions.add(new AddressingAssertion(addressingData));
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy(null, (String)(bindingName.getLocalPart() + "_Wsaw_Addressing_Policy"), assertionSets);
    }

    private static final class AddressingAssertion
    extends PolicyAssertion {
        AddressingAssertion(AssertionData assertionData) {
            super(assertionData, null);
        }
    }
}

