/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class KeyValueToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.KeyValueToken,
Cloneable,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private String tokenType = null;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
    private final QName itQname;
    private String includeToken;
    private String id = PolicyUtil.randomUUID();
    private boolean isServer = false;

    public KeyValueToken() {
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public KeyValueToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        this.includeToken = type;
    }

    public String getTokenId() {
        return this.id;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isKeyValueTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart();
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "KeyValueToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

