/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.impl.kerberos.KerberosLogin;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.wss.AliasSelector;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.RuntimeProperties;
import com.sun.xml.wss.impl.callback.SAMLAssertionValidator;
import com.sun.xml.wss.impl.callback.SAMLCallback;
import com.sun.xml.wss.impl.callback.SAMLValidator;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import com.sun.xml.wss.impl.callback.ValidatorExtension;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.DigestCertSelector;
import com.sun.xml.wss.impl.misc.IssuerNameAndSerialCertSelector;
import com.sun.xml.wss.impl.misc.KeyIdentifierCertSelector;
import com.sun.xml.wss.impl.misc.NonceCache;
import com.sun.xml.wss.impl.misc.PublicKeyCertSelector;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.logging.impl.misc.LogStringsMessages;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.util.XWSSUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.stream.XMLStreamReader;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSITProviderSecurityEnvironment
implements SecurityEnvironment {
    private Map _securityOptions;
    private CallbackHandler _handler;
    protected final long MAX_CLOCK_SKEW = 300000L;
    protected final long TIMESTAMP_FRESHNESS_LIMIT = 300000L;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    public static final String USERNAME_CBH = "username.callback.handler";
    public static final String PASSWORD_CBH = "password.callback.handler";
    private static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    NonceCache nonceCache = null;
    static final boolean USE_DAEMON_THREAD = true;
    static final Timer nonceCleanupTimer = new Timer(true);
    private String myAlias;
    private String keyPwd;
    private String peerEntityAlias;
    private String myUsername;
    private String myPassword;
    private String samlCBH;
    private String sV;
    private Class samlCbHandler;
    private CallbackHandler samlHandler = null;
    private Class samlValidator;
    private SAMLAssertionValidator sValidator;
    private String krbLoginModule = null;
    private String krbServicePrincipal = null;
    private boolean krbCredentialDelegation = false;
    private Class usernameCbHandler;
    private Class passwordCbHandler;
    private String mcs;
    private String tfl;
    private String mna;
    protected long maxClockSkewG;
    protected long timestampFreshnessLimitG;
    protected long maxNonceAge = 900000L;
    private boolean isAppClient = true;
    private X509Certificate selfCertificate = null;
    private String certSelectorClassName;
    private String crlSelectorClassName;
    private Class certSelectorClass;
    private Class crlSelectorClass;
    protected String revocationEnabledAttr;
    protected boolean revocationEnabled = false;
    private String keystoreCertSelectorClassName;
    private String truststoreCertSelectorClassName;
    private Class keystoreCertSelectorClass;
    private Class truststoreCertSelectorClass;
    private Container container = null;
    private String useXWSSCallbacksStr;
    private boolean useXWSSCallbacks = false;
    private CertificateValidationCallback.CertificateValidator certValidator;
    private Class certificateValidator;
    private Class usernameValidator;
    private Class timestampValidator;
    private PasswordValidationCallback.PasswordValidator pwValidator;
    private TimestampValidationCallback.TimestampValidator tsValidator;
    private String jaasLoginModuleForKeystore;
    private Subject loginContextSubjectForKeystore;
    private String keyStoreCBH;
    private CallbackHandler keystoreCbHandlerClass;
    private CallbackHandler usernameHandler;
    private CallbackHandler passwordHandler;

    public WSITProviderSecurityEnvironment(CallbackHandler handler, Map options, Properties configAssertions) throws XWSSecurityException {
        this._handler = new PriviledgedHandler(handler);
        this._securityOptions = options;
        if (this._securityOptions != null) {
            String mo_aliases = (String)this._securityOptions.get("ALIASES");
            String mo_keypwds = (String)this._securityOptions.get("PASSWORDS");
            if (mo_aliases != null && mo_keypwds != null) {
                StringTokenizer aliases = new StringTokenizer(mo_aliases, " ");
                StringTokenizer keypwds = new StringTokenizer(mo_keypwds, " ");
                if (aliases.countTokens() != keypwds.countTokens()) {
                    // empty if block
                }
            }
            this.container = (Container)this._securityOptions.get("CONTAINER");
        }
        this.myAlias = configAssertions.getProperty("my.alias");
        this.keyPwd = configAssertions.getProperty("key.password");
        this.peerEntityAlias = configAssertions.getProperty("peerentity.alias");
        this.krbLoginModule = configAssertions.getProperty("krb5.login.module");
        this.krbServicePrincipal = configAssertions.getProperty("krb5.service.principal");
        this.krbCredentialDelegation = Boolean.valueOf(configAssertions.getProperty("krb5.credential.delegation"));
        String uCBH = configAssertions.getProperty(USERNAME_CBH);
        String pCBH = configAssertions.getProperty(PASSWORD_CBH);
        this.myUsername = configAssertions.getProperty("my.username");
        this.myPassword = configAssertions.getProperty("my.password");
        this.samlCBH = configAssertions.getProperty("saml.callback.handler");
        if (this.samlCBH != null) {
            this.samlCbHandler = this.loadClass(this.samlCBH);
        }
        if (this.samlCbHandler != null) {
            try {
                this.samlHandler = (CallbackHandler)this.samlCbHandler.newInstance();
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0715_EXCEPTION_CREATING_NEWINSTANCE(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0715_EXCEPTION_CREATING_NEWINSTANCE(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        this.sV = configAssertions.getProperty("saml.validator");
        if (this.sV != null) {
            this.samlValidator = this.loadClass(this.sV);
        }
        if (this.samlValidator != null) {
            try {
                this.sValidator = (SAMLAssertionValidator)this.samlValidator.newInstance();
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0715_EXCEPTION_CREATING_NEWINSTANCE(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0715_EXCEPTION_CREATING_NEWINSTANCE(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        this.mcs = configAssertions.getProperty("max.clock.skew");
        this.tfl = configAssertions.getProperty("timestamp.freshness.limit");
        this.mna = configAssertions.getProperty("max.nonce.age");
        this.revocationEnabledAttr = configAssertions.getProperty("revocation.enabled");
        if (this.revocationEnabledAttr != null) {
            this.revocationEnabled = Boolean.parseBoolean(this.revocationEnabledAttr);
        }
        this.maxClockSkewG = SecurityUtil.toLong(this.mcs);
        this.timestampFreshnessLimitG = SecurityUtil.toLong(this.tfl);
        if (this.mna != null) {
            this.maxNonceAge = SecurityUtil.toLong(this.mna);
        }
        this.useXWSSCallbacksStr = configAssertions.getProperty("user.xwss.callbacks");
        if (this.useXWSSCallbacksStr != null) {
            this.useXWSSCallbacks = Boolean.parseBoolean(this.useXWSSCallbacksStr);
        }
        String cV = configAssertions.getProperty("certificate.validator");
        this.certificateValidator = this.loadClass(cV);
        String uV = configAssertions.getProperty("username.validator");
        String tV = configAssertions.getProperty("timestamp.validator");
        this.usernameValidator = this.loadClass(uV);
        this.timestampValidator = this.loadClass(tV);
        this.usernameCbHandler = this.loadClass(uCBH);
        this.passwordCbHandler = this.loadClass(pCBH);
        try {
            if (this.certificateValidator != null) {
                this.certValidator = (CertificateValidationCallback.CertificateValidator)this.certificateValidator.newInstance();
            }
            if (this.usernameValidator != null) {
                this.pwValidator = (PasswordValidationCallback.PasswordValidator)this.usernameValidator.newInstance();
            }
            if (this.timestampValidator != null) {
                this.tsValidator = (TimestampValidationCallback.TimestampValidator)this.timestampValidator.newInstance();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1523_ERROR_GETTING_NEW_INSTANCE_CALLBACK_HANDLER(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        NameCallback nameCallback = new NameCallback("Username: ");
        try {
            Callback[] cbs = new Callback[]{nameCallback};
            this._handler.handle(cbs);
        }
        catch (UnsupportedCallbackException e) {
            this.isAppClient = false;
        }
        catch (Exception e) {
            this.isAppClient = false;
        }
        this.certSelectorClassName = configAssertions.getProperty("certstore.certselector");
        this.crlSelectorClassName = configAssertions.getProperty("certstore.crlselector");
        this.certSelectorClass = this.loadClass(this.certSelectorClassName);
        this.crlSelectorClass = this.loadClass(this.crlSelectorClassName);
        this.keystoreCertSelectorClassName = configAssertions.getProperty("keystore.certselector");
        this.truststoreCertSelectorClassName = configAssertions.getProperty("truststore.certselector");
        this.keystoreCertSelectorClass = this.loadClass(this.keystoreCertSelectorClassName);
        this.truststoreCertSelectorClass = this.loadClass(this.truststoreCertSelectorClassName);
        this.jaasLoginModuleForKeystore = configAssertions.getProperty("jaas.loginmodule.for.keystore");
        this.keyStoreCBH = configAssertions.getProperty("keystore.callback.handler");
        this.loginContextSubjectForKeystore = this.initJAASKeyStoreLoginModule();
    }

    @Override
    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityException {
        if (alias == null && context != null) {
            Object obj = context.get("privatekey");
            PrivateKey key = null;
            if (obj instanceof PrivateKey) {
                key = (PrivateKey)obj;
                return key;
            }
        }
        PrivateKey privateKey = null;
        try {
            PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(alias);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, pkCallback};
            } else {
                callbacks = new Callback[]{pkCallback};
            }
            this._handler.handle(callbacks);
            privateKey = pkCallback.getKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.AliasRequest"), new Object[]{"PrivateKeyCallback.AliasRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        if (privateKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY(alias), new Object[]{alias});
            throw new XWSSecurityException("Unable to locate private key for the alias: " + alias);
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        if (context != null) {
            Object obj = context.get("privatekey");
            PrivateKey key = null;
            if (obj instanceof PrivateKey) {
                key = (PrivateKey)obj;
                Object cert = context.get("certificate");
                if (XWSSUtil.matchesProgrammaticInfo(cert, keyIdentifier, "Identifier") != null) {
                    return key;
                }
            }
        }
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    if (!this.matchesKeyIdentifier(Base64.decode(keyIdentifier), cred.getCertificate())) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdentifier);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, pkCallback};
            } else {
                callbacks = new Callback[]{pkCallback};
            }
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.SubjectKeyIDRequest"), new Object[]{"PrivateKeyCallback.SubjectKeyIDRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(Map context, X509Certificate cert) throws XWSSecurityException {
        try {
            Set<X500PrivateCredential> set;
            Subject subject;
            if (context != null) {
                Object key;
                Object obj = context.get("certificate");
                if (cert != null && cert.equals(obj) && (key = context.get("privatekey")) != null && key instanceof PrivateKey) {
                    return (PrivateKey)key;
                }
            }
            if ((subject = this.getSubject(context)) != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                String issuerName = RFC2253Parser.normalize(cert.getIssuerDN().getName());
                for (X500PrivateCredential cred : set) {
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
                    X500Principal issuerPrincipal = new X500Principal(issuerName);
                    if (!serialNo.equals(cert.getSerialNumber()) || !currentIssuerPrincipal.equals(issuerPrincipal)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(cert.getIssuerX500Principal(), cert.getSerialNumber());
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, pkCallback};
            } else {
                callbacks = new Callback[]{pkCallback};
            }
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.IssuerSerialNumRequest"), new Object[]{"PrivateKeyCallback.IssuerSerialNumRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        try {
            Set<X500PrivateCredential> set;
            PrivateKey key;
            Object obj;
            if (context != null && XWSSUtil.matchesProgrammaticInfo(obj = context.get("certificate"), serialNumber, issuerName) != null && (key = XWSSUtil.getProgrammaticPrivateKey(context)) != null) {
                return key;
            }
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
                    X500Principal issuerPrincipal = new X500Principal(issuerName);
                    if (!serialNo.equals(serialNumber) || !currentIssuerPrincipal.equals(issuerPrincipal)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, pkCallback};
            } else {
                callbacks = new Callback[]{pkCallback};
            }
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.IssuerSerialNumRequest"), new Object[]{"PrivateKeyCallback.IssuerSerialNumRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityException {
        Set<X509Certificate> set;
        Object obj;
        if (context != null && (obj = context.get("certificate")) != null && obj instanceof X509Certificate) {
            return (X509Certificate)obj;
        }
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPublicCredentials(X509Certificate.class)) != null && set.size() == 1) {
            return (X509Certificate)set.toArray()[0];
        }
        if (this.myAlias != null || this.keystoreCertSelectorClass != null) {
            return this.getCertificate(context, this.myAlias, true);
        }
        PrivateKeyCallback pkCallback = new PrivateKeyCallback(null);
        Callback[] _callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties props = new RuntimeProperties(context);
            _callbacks = new Callback[]{props, pkCallback};
        } else {
            _callbacks = new Callback[]{pkCallback};
        }
        try {
            this._handler.handle(_callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback with null argument"), new Object[]{"PrivateKeyCallback with null argument"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0296_NULL_CHAIN_CERT());
            throw new XWSSecurityException("Empty certificate chain returned by PrivateKeyCallback");
        }
        return (X509Certificate)chain[0];
    }

    @Override
    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityException {
        if (this.pwValidator != null) {
            PasswordValidationCallback.PlainTextPasswordRequest request = new PasswordValidationCallback.PlainTextPasswordRequest(username, password);
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
            ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
            passwordValidationCallback.setValidator(this.pwValidator);
            return passwordValidationCallback.getResult();
        }
        char[] pwd = password == null ? null : password.toCharArray();
        javax.security.auth.message.callback.PasswordValidationCallback pvCallback = new javax.security.auth.message.callback.PasswordValidationCallback(this.getRequesterSubject(context), username, pwd);
        Callback[] callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties xwsscb = new RuntimeProperties(context);
            callbacks = new Callback[]{xwsscb, pvCallback};
        } else {
            callbacks = new Callback[]{pvCallback};
        }
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("Authenticating User against list of Known username-password pairs"), new Object[]{"Authenticating User against list of Known username-password pairs"});
            throw new XWSSecurityException((Throwable)e);
        }
        if (pwd != null) {
            pvCallback.clearPassword();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Username Authentication done for " + username);
        }
        return pvCallback.getResult();
    }

    @Override
    public String authenticateUser(Map context, String username) throws XWSSecurityException {
        String password = null;
        if (this.pwValidator != null) {
            PasswordValidationCallback.DerivedKeyPasswordRequest request = new PasswordValidationCallback.DerivedKeyPasswordRequest(username);
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
            ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
            if (this.pwValidator != null && this.pwValidator instanceof PasswordValidationCallback.DerivedKeyPasswordValidator) {
                ((PasswordValidationCallback.DerivedKeyPasswordValidator)this.pwValidator).setPassword(request);
                passwordValidationCallback.setValidator(this.pwValidator);
            }
            passwordValidationCallback.getResult();
            password = request.getPassword();
        }
        return password;
    }

    @Override
    public boolean authenticateUser(Map context, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        boolean result;
        block14: {
            result = false;
            if (this.pwValidator != null) {
                PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
                PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
                ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
                if (this.pwValidator != null && this.pwValidator instanceof PasswordValidationCallback.WsitDigestPasswordValidator) {
                    ((PasswordValidationCallback.WsitDigestPasswordValidator)this.pwValidator).setPassword(request);
                    passwordValidationCallback.setValidator(this.pwValidator);
                }
                return passwordValidationCallback.getResult();
            }
            if (this.useXWSSCallbacks) {
                PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
                PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
                ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
                Callback[] callbacks = new Callback[]{passwordValidationCallback};
                try {
                    this._handler.handle(callbacks);
                    if (passwordValidationCallback.getValidator() == null) break block14;
                    result = passwordValidationCallback.getResult();
                    if (result) {
                        CallerPrincipalCallback pvCallback = new CallerPrincipalCallback(this.getSubject(context), username);
                        callbacks = new Callback[]{pvCallback};
                        try {
                            this._handler.handle(callbacks);
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("CallerPrincipalCallback"), new Object[]{"CallerPrincipalCallback"});
                            throw new XWSSecurityRuntimeException(e);
                        }
                    }
                    return result;
                }
                catch (UnsupportedCallbackException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "The Supplied JMAC CallbackHandler does not support com.sun.xml.wss.impl.callback.PasswordValidationCallback.DigestPasswordRequest");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
                    throw new XWSSecurityException((Throwable)e);
                }
            }
        }
        try {
            RealmAuthenticationAdapter adapter = RealmAuthenticationAdapter.newInstance(null);
            if (adapter == null) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0295_PASSWORD_VAL_NOT_CONFIG_USERNAME_VAL());
                throw new XWSSecurityException("Error: No PasswordValidator Configured for UsernameToken Validation");
            }
            result = adapter.authenticate(this.getSubject(context), username, passwordDigest, nonce, created, context);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Username Authentication done for " + username);
        }
        return result;
    }

    @Override
    public boolean validateCertificate(X509Certificate cert, Map context) throws XWSSecurityException {
        PKIXBuilderParameters parameters;
        if (this.certValidator != null) {
            CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert, context);
            certValCallback.setValidator(this.certValidator);
            certValCallback.setRevocationEnabled(this.revocationEnabled);
            return certValCallback.getResult();
        }
        if (this.useXWSSCallbacks) {
            CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert, context);
            certValCallback.setRevocationEnabled(this.revocationEnabled);
            Callback[] callbacks = new Callback[]{certValCallback};
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0223_FAILED_CERTIFICATE_VALIDATION());
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", e, true);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Certificate Validation called on certificate " + cert.getSubjectDN());
            }
            return certValCallback.getResult();
        }
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0298_X_509_EXPIRED(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "X509Certificate Expired", e, true);
        }
        catch (CertificateNotYetValidException e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0299_X_509_NOT_VALID(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "X509Certificate not yet valid", e, true);
        }
        if (cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
            if (this.isTrustedSelfSigned(cert)) {
                return true;
            }
            log.log(Level.SEVERE, LogStringsMessages.WSS_1533_X_509_SELF_SIGNED_CERTIFICATE_NOT_VALID());
            throw new XWSSecurityException("Validation of self signed certificate failed");
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(cert);
        CertPathValidator certPathValidator = null;
        CertPath certPath = null;
        List<Object> certChainList = new ArrayList<X509Certificate>();
        boolean caFound = false;
        Principal certChainIssuer = null;
        int noOfEntriesInTrustStore = 0;
        boolean isIssuerCertMatched = false;
        try {
            Callback[] callbacks = null;
            CertStoreCallback csCallback = null;
            TrustStoreCallback tsCallback = null;
            if (tsCallback == null && csCallback == null) {
                csCallback = new CertStoreCallback();
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{csCallback, tsCallback};
            } else if (csCallback == null) {
                csCallback = new CertStoreCallback();
                callbacks = new Callback[]{csCallback};
            } else if (tsCallback == null) {
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{tsCallback};
            }
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("Validate an X509Certificate"), new Object[]{"Validate an X509Certificate"});
                throw new XWSSecurityException((Throwable)e);
            }
            Certificate[] certChain = null;
            String certAlias = tsCallback.getTrustStore().getCertificateAlias(cert);
            if (certAlias != null) {
                certChain = tsCallback.getTrustStore().getCertificateChain(certAlias);
            }
            if (certChain == null) {
                certChainList.add(cert);
                certChainIssuer = cert.getIssuerX500Principal();
                noOfEntriesInTrustStore = tsCallback.getTrustStore().size();
            } else {
                certChainList = Arrays.asList(certChain);
            }
            while (!caFound && noOfEntriesInTrustStore-- != 0 && certChain == null) {
                Enumeration<String> aliases = tsCallback.getTrustStore().aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    String alias = aliases.nextElement();
                    Certificate certificate = tsCallback.getTrustStore().getCertificate(alias);
                    if (certificate == null || !"X.509".equals(certificate.getType()) || certChainList.contains(certificate) || !((Object)certChainIssuer).equals((x509Cert = (X509Certificate)certificate).getSubjectX500Principal())) continue;
                    certChainList.add(certificate);
                    if (x509Cert.getSubjectX500Principal().equals(x509Cert.getIssuerX500Principal())) {
                        caFound = true;
                        break;
                    }
                    certChainIssuer = x509Cert.getIssuerDN();
                    if (isIssuerCertMatched) continue;
                    isIssuerCertMatched = true;
                }
                if (caFound) continue;
                if (!isIssuerCertMatched) break;
                isIssuerCertMatched = false;
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certPath = cf.generateCertPath(certChainList);
                certPathValidator = CertPathValidator.getInstance("PKIX");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1518_FAILEDTO_VALIDATE_CERTIFICATE(), e);
                throw new CertificateValidationCallback.CertificateValidationException(e.getMessage(), e);
            }
            parameters = new PKIXBuilderParameters(tsCallback.getTrustStore(), (CertSelector)certSelector);
            parameters.setRevocationEnabled(this.revocationEnabled);
            parameters.addCertStore(csCallback.getCertStore());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0223_FAILED_CERTIFICATE_VALIDATION(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
        try {
            certPathValidator.validate(certPath, parameters);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0223_FAILED_CERTIFICATE_VALIDATION(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Certificate Validation called on certificate " + cert.getSubjectDN());
        }
        return true;
    }

    private Subject initJAASKeyStoreLoginModule() {
        if (this.jaasLoginModuleForKeystore == null) {
            return null;
        }
        LoginContext lc = null;
        try {
            if (this.keyStoreCBH != null) {
                this.keystoreCbHandlerClass = (CallbackHandler)this.loadClass(this.keyStoreCBH).newInstance();
                lc = new LoginContext(this.jaasLoginModuleForKeystore, this.keystoreCbHandlerClass);
            } else {
                lc = new LoginContext(this.jaasLoginModuleForKeystore);
            }
            lc.login();
            return lc.getSubject();
        }
        catch (InstantiationException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0817_KEYSTORE_LOGIN_MODULE_LOGIN_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0817_KEYSTORE_LOGIN_MODULE_LOGIN_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0817_KEYSTORE_LOGIN_MODULE_LOGIN_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
        catch (LoginException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0817_KEYSTORE_LOGIN_MODULE_LOGIN_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
    }

    private boolean isTrustedSelfSigned(X509Certificate cert) throws XWSSecurityException {
        try {
            Callback[] callbacks = null;
            CertStoreCallback csCallback = null;
            TrustStoreCallback tsCallback = null;
            if (tsCallback == null && csCallback == null) {
                csCallback = new CertStoreCallback();
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{csCallback, tsCallback};
            } else if (csCallback == null) {
                csCallback = new CertStoreCallback();
                callbacks = new Callback[]{csCallback};
            } else if (tsCallback == null) {
                tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{tsCallback};
            }
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("Validate an X509Certificate"), new Object[]{"Validate an X509Certificate"});
                throw new XWSSecurityException((Throwable)e);
            }
            if (tsCallback.getTrustStore() == null) {
                return false;
            }
            Enumeration<String> aliases = tsCallback.getTrustStore().aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                String alias = aliases.nextElement();
                Certificate certificate = tsCallback.getTrustStore().getCertificate(alias);
                if (certificate == null || !"X.509".equals(certificate.getType()) || (x509Cert = (X509Certificate)certificate) == null || !x509Cert.equals(cert)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0223_FAILED_CERTIFICATE_VALIDATION(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
    }

    public X509Certificate getMatchingCertificate(Map context, byte[] keyIdMatch) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        CertStore certStore;
        Set<X500PrivateCredential> set;
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate cert = cred.getCertificate();
                if (!this.matchesKeyIdentifier(keyIdMatch, cert)) continue;
                return cert;
            }
        }
        PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdMatch);
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        CertStoreCallback csCallback = new CertStoreCallback();
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        Callback[] callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties props = new RuntimeProperties(context);
            callbacks = new Callback[]{props, pkCallback, tsCallback, csCallback};
        } else {
            callbacks = new Callback[]{pkCallback, tsCallback, csCallback};
        }
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.SubjectKeyIDRequest"), new Object[]{"PrivateKeyCallback.SubjectKeyIDRequest"});
            throw new XWSSecurityException((Throwable)e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            if (chain.length == 1) {
                return (X509Certificate)chain[0];
            }
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesKeyIdentifier(keyIdMatch, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((certStore = csCallback.getCertStore()) != null) {
            KeyIdentifierCertSelector selector = null;
            if (selector == null) {
                selector = new KeyIdentifierCertSelector(keyIdMatch);
            }
            try {
                Collection<? extends Certificate> certs = certStore.getCertificates(selector);
                if (!certs.isEmpty()) {
                    Iterator<? extends Certificate> it = certs.iterator();
                    return (X509Certificate)it.next();
                }
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0713_ERROR_IN_CERTSTORE_LOOKUP(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(keyIdMatch, trustStore)) != null) {
            return otherPartyCert;
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdMatch), new Object[]{keyIdMatch});
        throw new XWSSecurityException("No Matching Certificate for :" + new String(keyIdMatch) + " found in KeyStore or TrustStore");
    }

    public X509Certificate getMatchingCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        KeyStore trustStore;
        CertStore certStore;
        Set<X500PrivateCredential> set;
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate x509Cert = cred.getCertificate();
                BigInteger serialNo = x509Cert.getSerialNumber();
                X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
                X500Principal issuerPrincipal = new X500Principal(issuerName);
                if (!serialNo.equals(serialNumber) || !currentIssuerPrincipal.equals(issuerPrincipal)) continue;
                return x509Cert;
            }
        }
        PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        CertStoreCallback csCallback = new CertStoreCallback();
        Callback[] callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties props = new RuntimeProperties(context);
            callbacks = new Callback[]{props, pkCallback, tsCallback, csCallback};
        } else {
            callbacks = new Callback[]{pkCallback, tsCallback, csCallback};
        }
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.IssuerSerialNumRequest"), new Object[]{"PrivateKeyCallback.IssuerSerialNumRequest"});
            throw new XWSSecurityException((Throwable)e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            if (chain.length == 1) {
                return (X509Certificate)chain[0];
            }
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesIssuerSerialAndName(serialNumber, issuerName, x509Cert)) continue;
                return x509Cert;
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0296_NULL_CHAIN_CERT());
        }
        if ((certStore = csCallback.getCertStore()) != null) {
            IssuerNameAndSerialCertSelector selector = null;
            if (selector == null) {
                selector = new IssuerNameAndSerialCertSelector(serialNumber, issuerName);
            }
            try {
                Collection<? extends Certificate> certs = certStore.getCertificates(selector);
                if (!certs.isEmpty()) {
                    Iterator<? extends Certificate> it = certs.iterator();
                    return (X509Certificate)it.next();
                }
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0713_ERROR_IN_CERTSTORE_LOOKUP(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null) {
            X509Certificate otherPartyCert = this.getMatchingCertificate(serialNumber, issuerName, trustStore);
            if (otherPartyCert != null) {
                return otherPartyCert;
            }
        } else {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0707_NULL_TRUSTSTORE());
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(issuerName + " : " + serialNumber), new Object[]{issuerName + " : " + serialNumber});
        throw new XWSSecurityException("No Matching Certificate for :" + issuerName + " : " + serialNumber + " found in KeyStore or TrustStore");
    }

    public X509Certificate getMatchingCertificate(Map context, byte[] keyIdMatch, String valueType) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        CertStore certStore;
        Set<X500PrivateCredential> set;
        X509Certificate certificate = XWSSUtil.matchesProgrammaticInfo((Object)context, keyIdMatch, valueType);
        if (certificate != null) {
            return certificate;
        }
        if ("Identifier".equals(valueType)) {
            return this.getMatchingCertificate(context, keyIdMatch);
        }
        if (!"Thumbprint".equals(valueType)) {
            throw new XWSSecurityException("Internal Error : Unsupported Valuetype :" + valueType + " passed to getMatchingCertificate()");
        }
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate cert = cred.getCertificate();
                if (!this.matchesThumbPrint(keyIdMatch, cert)) continue;
                return cert;
            }
        }
        PrivateKeyCallback.DigestRequest request = new PrivateKeyCallback.DigestRequest(keyIdMatch, "SHA-1");
        PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
        TrustStoreCallback tsCallback = new TrustStoreCallback();
        CertStoreCallback csCallback = new CertStoreCallback();
        Callback[] callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties props = new RuntimeProperties(context);
            callbacks = new Callback[]{props, pkCallback, tsCallback, csCallback};
        } else {
            callbacks = new Callback[]{pkCallback, tsCallback, csCallback};
        }
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.SubjectKeyIDRequest"), new Object[]{"PrivateKeyCallback.SubjectKeyIDRequest"});
            throw new XWSSecurityException((Throwable)e);
        }
        Certificate[] chain = pkCallback.getChain();
        if (chain != null) {
            if (chain.length == 1) {
                return (X509Certificate)chain[0];
            }
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesThumbPrint(keyIdMatch, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((certStore = csCallback.getCertStore()) != null) {
            DigestCertSelector selector = null;
            if (selector == null) {
                selector = new DigestCertSelector(keyIdMatch, "SHA-1");
            }
            try {
                Collection<? extends Certificate> certs = certStore.getCertificates(selector);
                if (!certs.isEmpty()) {
                    Iterator<? extends Certificate> it = certs.iterator();
                    return (X509Certificate)it.next();
                }
            }
            catch (CertStoreException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0713_ERROR_IN_CERTSTORE_LOOKUP(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(keyIdMatch, trustStore, valueType)) != null) {
            return otherPartyCert;
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdMatch), new Object[]{keyIdMatch});
        throw new XWSSecurityException("No Matching Certificate for :" + new String(keyIdMatch) + " found in KeyStore or TrustStore");
    }

    @Override
    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKeyCallback.AliasRequest request = new SecretKeyCallback.AliasRequest(alias);
        SecretKeyCallback skCallback = new SecretKeyCallback((SecretKeyCallback.Request)request);
        Callback[] callbacks = null;
        if (this.useXWSSCallbacks) {
            RuntimeProperties props = new RuntimeProperties(context);
            callbacks = new Callback[]{props, skCallback};
        } else {
            callbacks = new Callback[]{skCallback};
        }
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SecretKeyCallback.AliasRequest"), new Object[]{"SecretKeyCallback.AliasRequest"});
            throw new XWSSecurityException((Throwable)e);
        }
        return skCallback.getKey();
    }

    @Override
    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityException {
        String actualAlias = alias;
        X509Certificate cert = null;
        if (alias == null || "".equals(alias)) {
            Object obj;
            if (forSigning) {
                if (context != null) {
                    obj = context.get("certificate");
                    if (obj instanceof X509Certificate) {
                        return (X509Certificate)obj;
                    }
                    if (obj != null) {
                        throw new RuntimeException("CERTIFICATE_PROPERTY does not seem to be set to a valid X509Ceritificate");
                    }
                }
                if (this.myAlias != null) {
                    actualAlias = this.myAlias;
                } else if (this.keystoreCertSelectorClass != null) {
                    AliasSelector selector = null;
                    try {
                        selector = (AliasSelector)this.keystoreCertSelectorClass.newInstance();
                    }
                    catch (IllegalAccessException ex) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0811_EXCEPTION_INSTANTIATING_ALIASSELECTOR(), ex);
                        throw new RuntimeException(ex);
                    }
                    catch (InstantiationException ex) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0811_EXCEPTION_INSTANTIATING_ALIASSELECTOR(), ex);
                        throw new RuntimeException(ex);
                    }
                    actualAlias = selector.select(context);
                }
            } else {
                if (context != null && (obj = context.get("server-certificate")) instanceof X509Certificate) {
                    return (X509Certificate)obj;
                }
                if (this.peerEntityAlias != null) {
                    actualAlias = this.peerEntityAlias;
                }
            }
        }
        PrivateKeyCallback pkCallback = null;
        if (forSigning) {
            try {
                Set<X500PrivateCredential> set;
                Subject subject = this.getSubject(context);
                if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                    for (X500PrivateCredential cred : set) {
                        if (!cred.getAlias().equals(actualAlias)) continue;
                        return cred.getCertificate();
                    }
                }
                PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(actualAlias);
                pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
                Callback[] callbacks = null;
                if (this.useXWSSCallbacks) {
                    RuntimeProperties props = new RuntimeProperties(context);
                    callbacks = new Callback[]{props, pkCallback};
                } else {
                    callbacks = new Callback[]{pkCallback};
                }
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                throw new XWSSecurityException((Throwable)e);
            }
            Certificate[] chain = pkCallback.getChain();
            if (chain != null) {
                cert = (X509Certificate)chain[0];
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0296_NULL_CHAIN_CERT());
            }
        } else if (actualAlias != null && !"".equals(actualAlias)) {
            TrustStoreCallback tsCallback = new TrustStoreCallback();
            Callback[] _callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                _callbacks = new Callback[]{props, tsCallback};
            } else {
                _callbacks = new Callback[]{tsCallback};
            }
            try {
                this._handler.handle(_callbacks);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                throw new XWSSecurityException((Throwable)ex);
            }
            if (tsCallback.getTrustStore() != null) {
                try {
                    cert = (X509Certificate)tsCallback.getTrustStore().getCertificate(actualAlias);
                }
                catch (KeyStoreException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                    throw new XWSSecurityException((Throwable)ex);
                }
            }
        } else {
            RuntimeProperties props;
            Callback[] _callbacks;
            if (this.certSelectorClass != null) {
                CertSelector selector;
                CertStoreCallback csCallback = new CertStoreCallback();
                _callbacks = null;
                if (this.useXWSSCallbacks) {
                    props = new RuntimeProperties(context);
                    _callbacks = new Callback[]{props, csCallback};
                } else {
                    _callbacks = new Callback[]{csCallback};
                }
                try {
                    this._handler.handle(_callbacks);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                    throw new XWSSecurityException((Throwable)ex);
                }
                catch (UnsupportedCallbackException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                    throw new XWSSecurityException((Throwable)ex);
                }
                if (csCallback.getCertStore() != null && (selector = XWSSUtil.getCertSelector(this.certSelectorClass, context)) != null) {
                    Collection<? extends Certificate> certs = null;
                    try {
                        certs = csCallback.getCertStore().getCertificates(selector);
                    }
                    catch (CertStoreException ex) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0813_FAILEDTO_GETCERTIFICATE(), ex);
                        throw new RuntimeException(ex);
                    }
                    if (certs.size() > 0) {
                        cert = (X509Certificate)certs.iterator().next();
                    }
                }
            }
            if (cert == null && this.truststoreCertSelectorClass != null) {
                CertSelector selector;
                TrustStoreCallback tsCallback = new TrustStoreCallback();
                _callbacks = null;
                if (this.useXWSSCallbacks) {
                    props = new RuntimeProperties(context);
                    _callbacks = new Callback[]{props, tsCallback};
                } else {
                    _callbacks = new Callback[]{tsCallback};
                }
                try {
                    this._handler.handle(_callbacks);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                    throw new XWSSecurityException((Throwable)ex);
                }
                catch (UnsupportedCallbackException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(alias), new Object[]{alias});
                    throw new XWSSecurityException((Throwable)ex);
                }
                KeyStore trustStore = tsCallback.getTrustStore();
                if (trustStore != null && this.truststoreCertSelectorClass != null && (selector = XWSSUtil.getCertSelector(this.truststoreCertSelectorClass, context)) != null) {
                    Enumeration<String> aliases = null;
                    try {
                        aliases = trustStore.aliases();
                    }
                    catch (KeyStoreException ex) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0813_FAILEDTO_GETCERTIFICATE(), ex);
                        throw new RuntimeException(ex);
                    }
                    while (aliases.hasMoreElements()) {
                        String currAlias = aliases.nextElement();
                        Certificate thisCertificate = null;
                        try {
                            thisCertificate = trustStore.getCertificate(currAlias);
                        }
                        catch (KeyStoreException ex) {
                            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0813_FAILEDTO_GETCERTIFICATE(), ex);
                            throw new RuntimeException(ex);
                        }
                        if (!(thisCertificate instanceof X509Certificate) || !selector.match(thisCertificate)) continue;
                        return (X509Certificate)thisCertificate;
                    }
                }
            }
            if (cert == null) {
                cert = this.getDynamicCertificate(context);
            }
        }
        if (cert == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(actualAlias));
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + actualAlias + "'");
        }
        return cert;
    }

    private boolean isMyCert(X509Certificate certificate, Map context) {
        try {
            X509Certificate cert = this.getDefaultCertificate(context);
            if (cert != null && cert.equals(certificate)) {
                return true;
            }
        }
        catch (XWSSecurityException xWSSecurityException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class loadUsingResourceLoader(String classname) {
        Class<?> ret = null;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Entered loadUsingResourceLoader to load class.." + classname);
        }
        if (this.container != null) {
            ResourceLoader loader = (ResourceLoader)this.container.getSPI(ResourceLoader.class);
            if (loader != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Obtained Non null ResourceLoader instance....");
                }
                try {
                    URL classpathUrl = loader.getResource(classname);
                    ClassLoader parent = this.getClass().getClassLoader();
                    URLClassLoader classloader = URLClassLoader.newInstance(new URL[]{classpathUrl}, parent);
                    return classloader.loadClass(classname);
                }
                catch (ClassNotFoundException ex) {
                    if (!log.isLoggable(Level.FINE)) return null;
                    log.log(Level.FINE, "Failed load class using ResourceLoader instance....", ex);
                    return null;
                }
                catch (MalformedURLException e) {
                    if (!log.isLoggable(Level.FINE)) return null;
                    log.log(Level.FINE, "Failed load class using ResourceLoader instance....", e);
                    return null;
                }
            } else {
                if (!log.isLoggable(Level.FINE)) return null;
                log.log(Level.FINE, "Failed to obtain ResourceLoader instance....");
            }
            return null;
        } else {
            if (!log.isLoggable(Level.FINE)) return null;
            log.log(Level.FINE, "Failed to obtain \"Container\" for getting ResourceLoader SPI ....");
        }
        return null;
    }

    private boolean matchesKeyIdentifier(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private boolean matchesThumbPrint(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = XWSSUtil.getThumbprintIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private X509Certificate getMatchingCertificate(byte[] keyIdMatch, KeyStore kStore) throws XWSSecurityException {
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(keyIdMatch, keyId)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdMatch), new Object[]{keyIdMatch});
            throw new XWSSecurityException("No Matching Certificate for :" + new String(keyIdMatch) + " found in KeyStore.", (Throwable)kEx);
        }
        return null;
    }

    private X509Certificate getMatchingCertificate(byte[] keyIdMatch, KeyStore kStore, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getMatchingCertificate(keyIdMatch, kStore);
        }
        if (!"Thumbprint".equals(valueType)) {
            throw new XWSSecurityException("Internal Error : Unsupported Valuetype :" + valueType + " passed to getMatchingCertificate()");
        }
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || !Arrays.equals(keyIdMatch, keyId = XWSSUtil.getThumbprintIdentifier(x509Cert = (X509Certificate)cert))) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdMatch), new Object[]{keyIdMatch});
            throw new XWSSecurityException("No Matching Certificate for :" + new String(keyIdMatch) + " found in KeyStore.", (Throwable)kEx);
        }
        return null;
    }

    private boolean matchesIssuerSerialAndName(BigInteger serialNumberMatch, String issuerNameMatch, X509Certificate x509Cert) {
        BigInteger serialNumber = x509Cert.getSerialNumber();
        X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
        X500Principal issuerPrincipal = new X500Principal(issuerNameMatch);
        return serialNumber.equals(serialNumberMatch) && currentIssuerPrincipal.equals(issuerPrincipal);
    }

    private X509Certificate getMatchingCertificate(BigInteger serialNumber, String issuerName, KeyStore kStore) throws XWSSecurityException {
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
                X500Principal issuerPrincipal = new X500Principal(issuerName);
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisSerialNumber.equals(serialNumber) || !currentIssuerPrincipal.equals(issuerName)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(issuerName + " : " + serialNumber), new Object[]{issuerName + " : " + serialNumber});
            throw new XWSSecurityException("No Matching Certificate for :" + issuerName + " : " + serialNumber + " found in KeyStore.", (Throwable)kEx);
        }
        return null;
    }

    private X509Certificate getMatchingCertificate(PublicKey publicKey, KeyStore kStore) throws XWSSecurityException {
        if (kStore == null) {
            return null;
        }
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || !(x509Cert = (X509Certificate)cert).getPublicKey().equals(publicKey)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(publicKey), new Object[]{publicKey});
            throw new XWSSecurityException("No Matching Certificate for :" + publicKey + " found in KeyStore.", (Throwable)kEx);
        }
        return null;
    }

    @Override
    public void updateOtherPartySubject(Subject subject, String username, String password) {
        CallerPrincipalCallback pvCallback = new CallerPrincipalCallback(subject, username);
        Callback[] callbacks = new Callback[]{pvCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("CallerPrincipalCallback"), new Object[]{"CallerPrincipalCallback"});
            throw new XWSSecurityRuntimeException(e);
        }
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                subject.getPublicCredentials().add(cert);
                return null;
            }
        });
        CallerPrincipalCallback pvCallback = new CallerPrincipalCallback(subject, (Principal)principal);
        Callback[] callbacks = new Callback[]{pvCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("CallerPrincipalCallback"), new Object[]{"CallerPrincipalCallback"});
            throw new XWSSecurityRuntimeException(e);
        }
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final Assertion assertion) {
        if (this.sValidator instanceof SAMLValidator) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    @Override
    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    public PublicKey getPublicKey(String keyIdentifier) throws XWSSecurityException {
        try {
            return this.getMatchingCertificate(null, this.getDecodedBase64EncodedData(keyIdentifier)).getPublicKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdentifier), new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching Certificate for :" + keyIdentifier + " found in KeyStore ");
        }
    }

    @Override
    public PublicKey getPublicKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        try {
            return this.getCertificate(context, keyIdentifier).getPublicKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0706_NO_MATCHING_CERT(keyIdentifier), new Object[]{keyIdentifier});
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public PublicKey getPublicKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        return this.getCertificate(context, identifier, valueType).getPublicKey();
    }

    private byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0144_UNABLETO_DECODE_BASE_64_DATA(e.getMessage()), e);
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }

    @Override
    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        Object obj;
        X509Certificate cert;
        if (context != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = context.get("server-certificate"), serialNumber, issuerName)) != null) {
            return cert;
        }
        return this.getMatchingCertificate(context, serialNumber, issuerName);
    }

    public X509Certificate getCertificate(String keyIdentifier) throws XWSSecurityException {
        try {
            byte[] decoded = this.getDecodedBase64EncodedData(keyIdentifier);
            return this.getMatchingCertificate(null, decoded);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0711_ERROR_MATCH_CERT_FOR_DECODED_STRING(), e);
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) {
        PrivateKey key;
        if (XWSSUtil.matchesProgrammaticInfo(context, publicKey) != null && (key = XWSSUtil.getProgrammaticPrivateKey(context)) != null) {
            return key;
        }
        PublicKey myAliasKey = null;
        try {
            myAliasKey = this.getCertificate(context, this.myAlias, true).getPublicKey();
            if (myAliasKey.equals(publicKey)) {
                PrivateKey ret = this.getPrivateKey(context, this.myAlias);
                return ret;
            }
        }
        catch (XWSSecurityException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
        throw new XWSSecurityRuntimeException("Could not locate Matching Private Key for: " + publicKey);
    }

    @Override
    public X509Certificate getCertificate(Map context, byte[] ski) {
        X509Certificate cert = XWSSUtil.matchesProgrammaticInfo((Object)context, ski, "Identifier");
        if (cert != null) {
            return cert;
        }
        try {
            return this.getMatchingCertificate(context, ski);
        }
        catch (XWSSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        Set<X500PrivateCredential> set;
        Object obj;
        X509Certificate certificate;
        if (context != null && (certificate = XWSSUtil.matchesProgrammaticInfo(obj = context.get("server-certificate"), publicKey)) != null) {
            return certificate;
        }
        Subject subject = this.getSubject(context);
        if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            for (X500PrivateCredential cred : set) {
                X509Certificate cert = cred.getCertificate();
                if (!cert.getPublicKey().equals(publicKey)) continue;
                return cert;
            }
        }
        if (!forSign) {
            X509Certificate otherPartyCert;
            KeyStore trustStore;
            CertStoreCallback csCallback = new CertStoreCallback();
            TrustStoreCallback tsCallback = new TrustStoreCallback();
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, csCallback, tsCallback};
            } else {
                callbacks = new Callback[]{csCallback, tsCallback};
            }
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("CertStoreCallback"), new Object[]{"CertStoreCallback"});
                throw new XWSSecurityException((Throwable)e);
            }
            CertStore certStore = csCallback.getCertStore();
            if (certStore != null) {
                PublicKeyCertSelector selector = null;
                if (selector == null) {
                    selector = new PublicKeyCertSelector(publicKey);
                }
                try {
                    Collection<? extends Certificate> certs = certStore.getCertificates(selector);
                    if (!certs.isEmpty()) {
                        Iterator<? extends Certificate> it = certs.iterator();
                        return (X509Certificate)it.next();
                    }
                }
                catch (CertStoreException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0713_ERROR_IN_CERTSTORE_LOOKUP(), ex);
                    throw new XWSSecurityException((Throwable)ex);
                }
            }
            if ((trustStore = tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(publicKey, trustStore)) != null) {
                return otherPartyCert;
            }
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION(publicKey), new Object[]{publicKey});
        throw new XWSSecurityException("No Matching Certificate for :" + publicKey + " found in KeyStore or TrustStore");
    }

    @Override
    public X509Certificate getCertificate(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        Object obj;
        X509Certificate cert;
        if (context != null && (cert = XWSSUtil.matchesProgrammaticInfo(obj = context.get("server-certificate"), identifier, valueType)) != null) {
            return cert;
        }
        if ("Identifier".equals(valueType)) {
            return this.getMatchingCertificate(context, identifier);
        }
        return this.getMatchingCertificate(context, identifier, valueType);
    }

    public boolean validateSamlIssuer(String issuer) {
        return true;
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        return true;
    }

    public void setSubject(Subject subject, Map context) {
        context.put("javax.security.auth.Subject.self", subject);
    }

    public void setRequesterSubject(Subject subject, Map context) {
        context.put("javax.security.auth.Subject", subject);
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    public Subject getSubject(Map context) {
        if (context == null) {
            return null;
        }
        if (this.loginContextSubjectForKeystore != null) {
            return this.loginContextSubjectForKeystore;
        }
        return (Subject)context.get("javax.security.auth.Subject.self");
    }

    public Subject getRequesterSubject(final Map context) {
        if (context == null) {
            return null;
        }
        Subject otherPartySubject = (Subject)context.get("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject otherPartySubj = new Subject();
                context.put("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    private Date getGMTDateWithSkewAdjusted(Calendar c, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += 300000L) : (currentTime -= 300000L);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    @Override
    public String getUsername(Map context) throws XWSSecurityException {
        if (context == null) {
            return null;
        }
        if (this.myUsername != null) {
            return this.myUsername;
        }
        String username = (String)context.get("username");
        if (username == null) {
            username = (String)context.get("javax.xml.ws.security.auth.username");
        }
        if (username != null) {
            return username;
        }
        NameCallback nameCallback = new NameCallback("Username: ");
        try {
            Callback[] cbs = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                cbs = new Callback[]{props, nameCallback};
            } else {
                cbs = new Callback[]{nameCallback};
            }
            if (this.usernameCbHandler != null) {
                this.usernameHandler = (CallbackHandler)this.usernameCbHandler.newInstance();
                this.usernameHandler.handle(cbs);
                nameCallback.setName(((NameCallback)cbs[0]).getName());
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Got NULL for Username Callback Handler");
                }
                if (!this.isAppClient) {
                    return null;
                }
                this._handler.handle(cbs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("NameCallback"), new Object[]{"NameCallback"});
            throw new RuntimeException(e);
        }
        return nameCallback.getName();
    }

    @Override
    public String getPassword(Map context) throws XWSSecurityException {
        RuntimeProperties props;
        if (this.myPassword != null) {
            if (this.myPassword.startsWith("$")) {
                String alias = this.myPassword.substring(1);
                SecretKeyCallback.AliasRequest ar = new SecretKeyCallback.AliasRequest(alias);
                SecretKeyCallback skcb = new SecretKeyCallback((SecretKeyCallback.Request)ar);
                Callback[] callbacks = null;
                if (this.useXWSSCallbacks) {
                    RuntimeProperties props2 = new RuntimeProperties(context);
                    callbacks = new Callback[]{props2, skcb};
                } else {
                    callbacks = new Callback[]{skcb};
                }
                try {
                    this._handler.handle(callbacks);
                    SecretKey key = skcb.getKey();
                    byte[] password = key.getEncoded();
                    return new String(password);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SecretKeyCallback.AliasRequest"), new Object[]{"SecretKeyCallback.AliasRequest"});
                    throw new XWSSecurityException((Throwable)ex);
                }
            }
            return this.myPassword;
        }
        String password = (String)context.get("password");
        if (password == null) {
            password = (String)context.get("javax.xml.ws.security.auth.password");
        }
        if (password != null) {
            return password;
        }
        PasswordCallback pwdCallback = new PasswordCallback("Password: ", false);
        Callback[] cbs = null;
        if (this.useXWSSCallbacks) {
            props = new RuntimeProperties(context);
            cbs = new Callback[]{props, pwdCallback};
        } else {
            cbs = new Callback[]{pwdCallback};
        }
        try {
            if (this.passwordCbHandler != null) {
                this.passwordHandler = (CallbackHandler)this.passwordCbHandler.newInstance();
                this.passwordHandler.handle(cbs);
                char[] pass = ((PasswordCallback)cbs[0]).getPassword();
                pwdCallback.setPassword(pass);
            } else {
                if (!this.isAppClient) {
                    return null;
                }
                if (this.useXWSSCallbacks) {
                    props = new RuntimeProperties(context);
                    cbs = new Callback[]{props, pwdCallback};
                } else {
                    cbs = new Callback[]{pwdCallback};
                }
                this._handler.handle(cbs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
            throw new RuntimeException(e);
        }
        if (pwdCallback.getPassword() == null) {
            return null;
        }
        return new String(pwdCallback.getPassword());
    }

    @Override
    public boolean validateAndCacheNonce(Map context, String nonce, String created, long nonceAge) throws XWSSecurityException {
        NonceManager nonceMgr = null;
        nonceMgr = this.mna != null ? NonceManager.getInstance(this.maxNonceAge, (WSEndpoint)context.get("WSEndpoint")) : NonceManager.getInstance(nonceAge, (WSEndpoint)context.get("WSEndpoint"));
        return nonceMgr.validateNonce(nonce, created);
    }

    @Override
    public void validateTimestamp(Map context, String created, String expires, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        if (this.tsValidator != null) {
            TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(created, expires, maxClockSkew, freshnessLimit);
            TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
            timestampValidationCallback.setValidator(this.tsValidator);
            try {
                timestampValidationCallback.getResult();
                return;
            }
            catch (TimestampValidationCallback.TimestampValidationException e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
            }
        }
        if (this.useXWSSCallbacks) {
            TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(created, expires, maxClockSkew, freshnessLimit);
            TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{timestampValidationCallback};
            try {
                this._handler.handle(callbacks);
                return;
            }
            catch (UnsupportedCallbackException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
            }
        }
        if (WSITProviderSecurityEnvironment.expiresBeforeCreated(created, expires)) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0232_EXPIRED_MESSAGE());
            XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
        }
        this.validateCreationTime(context, created, maxClockSkew, freshnessLimit);
        this.validateExpirationTime(expires, maxClockSkew, freshnessLimit);
    }

    @Override
    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        this.validateTimestamp(context, timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date expires;
        Date created;
        block16: {
            created = null;
            expires = null;
            try {
                try {
                    SimpleDateFormat simpleDateFormat = calendarFormatter1;
                    synchronized (simpleDateFormat) {
                        created = calendarFormatter1.parse(creationTime);
                    }
                    if (expirationTime == null) break block16;
                    simpleDateFormat = calendarFormatter1;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter1.parse(expirationTime);
                    }
                }
                catch (ParseException pe) {
                    SimpleDateFormat simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        created = calendarFormatter2.parse(creationTime);
                    }
                    if (expirationTime == null) break block16;
                    simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter2.parse(expirationTime);
                    }
                }
            }
            catch (ParseException pe) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0394_ERROR_PARSING_EXPIRATIONTIME());
                throw new XWSSecurityException(pe.getMessage());
            }
        }
        return expires != null && expires.before(created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        Date created;
        if (this.tsValidator != null) {
            TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(creationTime, null, maxClockSkew, timestampFreshnessLimit);
            request.isUsernameToken(true);
            TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
            timestampValidationCallback.setValidator(this.tsValidator);
            try {
                timestampValidationCallback.getResult();
                return;
            }
            catch (TimestampValidationCallback.TimestampValidationException e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
            }
        }
        if (this.useXWSSCallbacks) {
            TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(creationTime, null, maxClockSkew, timestampFreshnessLimit);
            TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{timestampValidationCallback};
            try {
                this._handler.handle(callbacks);
                return;
            }
            catch (UnsupportedCallbackException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
            }
        }
        long maxClockSkewActual = maxClockSkew;
        long freshnessLimitActual = timestampFreshnessLimit;
        if (this.mcs != null && this.maxClockSkewG >= 0L) {
            maxClockSkewActual = this.maxClockSkewG;
        }
        if (this.tfl != null && this.timestampFreshnessLimitG > 0L) {
            freshnessLimitActual = this.timestampFreshnessLimitG;
        }
        try {
            SimpleDateFormat simpleDateFormat = calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = calendarFormatter1.parse(creationTime);
            }
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat simpleDateFormat = calendarFormatter2;
                synchronized (simpleDateFormat) {
                    created = calendarFormatter2.parse(creationTime);
                }
            }
            catch (ParseException pe1) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0226_FAILED_VALIDATING_DEFAULT_CREATION_TIME(), pe1);
                throw new XWSSecurityException("Exception while parsing Creation Time :" + pe1.getMessage());
            }
        }
        Date current = null;
        try {
            current = WSITProviderSecurityEnvironment.getFreshnessAndSkewAdjustedDate(maxClockSkewActual, freshnessLimitActual);
        }
        catch (ParseException pe) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0712_ERROR_ADJUST_SKEW_FRESHNESS_TIME(), pe);
            throw new XWSSecurityException(pe.getMessage());
        }
        if (created.before(current)) {
            XWSSecurityException xwsse = new XWSSecurityException("Creation Time is older than configured Timestamp Freshness Interval!");
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Creation Time is older than configured Timestamp Freshness Interval!", xwsse, true);
        }
        Date currentTime = WSITProviderSecurityEnvironment.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkewActual, true);
        if (currentTime.before(created)) {
            XWSSecurityException xwsse = new XWSSecurityException("Creation Time ahead of Current Time!");
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Creation Time ahead of Current Time!", xwsse, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExpirationTime(String expirationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        long maxClockSkewActual = maxClockSkew;
        long freshnessLimitActual = timestampFreshnessLimit;
        if (this.mcs != null && this.maxClockSkewG >= 0L) {
            maxClockSkewActual = this.maxClockSkewG;
        }
        if (this.tfl != null && this.timestampFreshnessLimitG > 0L) {
            freshnessLimitActual = this.timestampFreshnessLimitG;
        }
        if (expirationTime != null) {
            Date expires;
            try {
                SimpleDateFormat simpleDateFormat = calendarFormatter1;
                synchronized (simpleDateFormat) {
                    expires = calendarFormatter1.parse(expirationTime);
                }
            }
            catch (ParseException pe) {
                try {
                    SimpleDateFormat simpleDateFormat = calendarFormatter2;
                    synchronized (simpleDateFormat) {
                        expires = calendarFormatter2.parse(expirationTime);
                    }
                }
                catch (ParseException pe1) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0394_ERROR_PARSING_EXPIRATIONTIME());
                    throw new XWSSecurityException("Exception while parsing Expiration Time :" + pe1.getMessage());
                }
            }
            Date currentTime = WSITProviderSecurityEnvironment.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkewActual, false);
            if (expires.before(currentTime)) {
                XWSSecurityException xwsse = new XWSSecurityException("Message Expired!");
                throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message Expired!", xwsse);
            }
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() throws XWSSecurityException {
        return this._handler;
    }

    @Override
    public void validateSAMLAssertion(Map context, Element assertion) throws XWSSecurityException {
        if (this.sValidator != null) {
            try {
                if (this.sValidator instanceof ValidatorExtension) {
                    ((ValidatorExtension)((Object)this.sValidator)).setRuntimeProperties(context);
                }
                if (this.sValidator instanceof SAMLValidator) {
                    ((SAMLValidator)this.sValidator).validate(assertion, context, this.getRequesterSubject(context));
                } else {
                    this.sValidator.validate(assertion);
                }
            }
            catch (SAMLAssertionValidator.SAMLValidationException e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0716_FAILED_VALIDATE_SAML_ASSERTION(), e);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ", e, true);
            }
        }
    }

    @Override
    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) throws XWSSecurityException {
        if (this.samlHandler != null) {
            SAMLCallback sc = new SAMLCallback();
            sc.setAssertionId(assertionId);
            sc.setAuthorityBindingElement(binding);
            Callback[] cbs = new Callback[]{sc};
            try {
                this.samlHandler.handle(cbs);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            return sc.getAssertionElement();
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0717_NO_SAML_CALLBACK_HANDLER());
        throw new XWSSecurityException((Throwable)new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, DynamicApplicationContext context) throws XWSSecurityException {
        AuthenticationTokenPolicy.SAMLAssertionBinding ret = (AuthenticationTokenPolicy.SAMLAssertionBinding)samlBinding.clone();
        if ("SV".equals(samlBinding.getAssertionType())) {
            if (this.samlHandler != null) {
                SAMLCallback sc = new SAMLCallback();
                SecurityUtil.copy(sc.getRuntimeProperties(), fpcontext);
                sc.setConfirmationMethod("SV-Assertion");
                sc.setSAMLVersion(samlBinding.getSAMLVersion());
                Callback[] cbs = new Callback[]{sc};
                try {
                    this.samlHandler.handle(cbs);
                }
                catch (UnsupportedCallbackException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                    throw new XWSSecurityException((Throwable)ex);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                    throw new XWSSecurityException((Throwable)ex);
                }
                ret.setAssertion(sc.getAssertionElement());
                ret.setAssertion(sc.getAssertionReader());
                ret.setAuthorityBinding(sc.getAuthorityBindingElement());
                ret.setSAMLVersion(sc.getSAMLVersion());
                return ret;
            }
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0717_NO_SAML_CALLBACK_HANDLER());
            throw new XWSSecurityException((Throwable)new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion"));
        }
        if (this.samlHandler != null) {
            SAMLCallback sc = new SAMLCallback();
            SecurityUtil.copy(sc.getRuntimeProperties(), fpcontext);
            sc.setConfirmationMethod("HOK-Assertion");
            sc.setSAMLVersion(samlBinding.getSAMLVersion());
            Callback[] cbs = new Callback[]{sc};
            try {
                this.samlHandler.handle(cbs);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0718_EXCEPTION_INVOKING_SAML_HANDLER(), ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            ret.setAssertion(sc.getAssertionElement());
            ret.setAuthorityBinding(sc.getAuthorityBindingElement());
            ret.setAssertion(sc.getAssertionReader());
            PrivateKeyBinding pkBinding = (PrivateKeyBinding)ret.newPrivateKeyBinding();
            PrivateKey key = this.getPrivateKey(fpcontext, this.myAlias);
            pkBinding.setPrivateKey(key);
            ret.setAssertionId(sc.getAssertionId());
            ret.setSAMLVersion(sc.getSAMLVersion());
            return ret;
        }
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0717_NO_SAML_CALLBACK_HANDLER());
        throw new XWSSecurityException((Throwable)new UnsupportedCallbackException(null, "A Required SAML Callback Handler was not specified in configuration : Cannot Populate SAML Assertion"));
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private X509Certificate getDynamicCertificate(Map context) {
        X509Certificate cert = null;
        X509Certificate self = null;
        Subject requesterSubject = this.getRequesterSubject(context);
        if (requesterSubject != null) {
            Set<Object> publicCredentials = requesterSubject.getPublicCredentials();
            for (Object cred : publicCredentials) {
                if (!(cred instanceof X509Certificate)) continue;
                X509Certificate certificate = (X509Certificate)cred;
                if (!this.isMyCert(certificate, context)) {
                    cert = certificate;
                    break;
                }
                self = certificate;
            }
            if (cert != null) {
                return cert;
            }
            if (self != null) {
                return self;
            }
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier, String valueType) throws XWSSecurityException {
        PrivateKey key;
        X509Certificate cert = XWSSUtil.matchesProgrammaticInfo((Object)context, keyIdentifier, valueType);
        if (cert != null && (key = XWSSUtil.getProgrammaticPrivateKey(context)) != null) {
            return key;
        }
        if ("Identifier".equals(valueType)) {
            return this.getPrivateKey(context, keyIdentifier);
        }
        if (!"Thumbprint".equals(valueType)) {
            throw new XWSSecurityException("Internal Error : Unsupported Valuetype :" + valueType + " passed to getPrivateKey()");
        }
        try {
            Set<X500PrivateCredential> set;
            Subject subject = this.getSubject(context);
            if (subject != null && (set = subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                for (X500PrivateCredential cred : set) {
                    if (!this.matchesThumbPrint(Base64.decode(keyIdentifier), cred.getCertificate())) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.DigestRequest request = new PrivateKeyCallback.DigestRequest(keyIdentifier, "SHA-1");
            PrivateKeyCallback pkCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)request);
            Callback[] callbacks = null;
            if (this.useXWSSCallbacks) {
                RuntimeProperties props = new RuntimeProperties(context);
                callbacks = new Callback[]{props, pkCallback};
            } else {
                callbacks = new Callback[]{pkCallback};
            }
            this._handler.handle(callbacks);
            return pkCallback.getKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("PrivateKeyCallback.SubjectKeyIDRequest"), new Object[]{"PrivateKeyCallback.SubjectKeyIDRequest"});
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public void validateSAMLAssertion(Map context, XMLStreamReader assertion) throws XWSSecurityException {
        if (this.sValidator != null) {
            try {
                if (this.sValidator instanceof ValidatorExtension) {
                    ((ValidatorExtension)((Object)this.sValidator)).setRuntimeProperties(context);
                }
                if (this.sValidator instanceof SAMLValidator) {
                    ((SAMLValidator)this.sValidator).validate(assertion, context, this.getRequesterSubject(context));
                } else {
                    this.sValidator.validate(assertion);
                }
            }
            catch (SAMLAssertionValidator.SAMLValidationException e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0716_FAILED_VALIDATE_SAML_ASSERTION(), e);
                throw new XWSSecurityException((Throwable)e);
            }
        }
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final XMLStreamReader assertion) {
        if (this.sValidator instanceof SAMLValidator) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    @Override
    public boolean isSelfCertificate(X509Certificate cert) {
        return false;
    }

    private Class loadClass(String classname) throws XWSSecurityException {
        ClassLoader loader;
        Class ret;
        block9: {
            if (classname == null) {
                return null;
            }
            ret = null;
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    ret = loader.loadClass(classname);
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isLoggable(Level.FINE)) break block9;
                    log.log(Level.FINE, "Failed to load class Thread Context ClassLoader..." + classname);
                }
            }
        }
        loader = this.getClass().getClassLoader();
        try {
            ret = loader.loadClass(classname);
            return ret;
        }
        catch (ClassNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Failed to load class using this.getClass().getClassLoader()..." + classname);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Calling loadUsingResourceLoader to load class.." + classname);
            }
            if (ret == null && (ret = this.loadUsingResourceLoader(classname)) != null) {
                return ret;
            }
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0714_ERROR_GETTING_USER_CLASS(classname), new Object[]{classname});
            throw new XWSSecurityException("Could not find User Class " + classname);
        }
    }

    @Override
    public void updateOtherPartySubject(Subject subject, Subject bootStrapSubject) {
        SecurityUtil.copySubject(subject, bootStrapSubject);
    }

    @Override
    public KerberosContext doKerberosLogin() throws XWSSecurityException {
        if (this.krbLoginModule == null || this.krbLoginModule.equals("")) {
            throw new XWSSecurityException("Login Module for Kerberos login is not set or could not be obtained");
        }
        if (this.krbServicePrincipal == null || this.krbServicePrincipal.equals("")) {
            throw new XWSSecurityException("Kerberos Service Principal is not set or could not be obtained");
        }
        return new KerberosLogin().login(this.krbLoginModule, this.krbServicePrincipal, this.krbCredentialDelegation);
    }

    @Override
    public KerberosContext doKerberosLogin(byte[] tokenValue) throws XWSSecurityException {
        return new KerberosLogin().login(this.krbLoginModule, tokenValue);
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final GSSName clientCred, final GSSCredential gssCred) {
        try {
            final KerberosPrincipal kerbPrincipal = new KerberosPrincipal(((Object)clientCred).toString());
            CallerPrincipalCallback pvCallback = new CallerPrincipalCallback(subject, kerbPrincipal.getName());
            Callback[] callbacks = new Callback[]{pvCallback};
            this._handler.handle(callbacks);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrincipals().add(kerbPrincipal);
                    subject.getPublicCredentials().add(clientCred);
                    if (gssCred != null) {
                        subject.getPrivateCredentials().add(gssCred);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("CallerPrincipalCallback"), new Object[]{"CallerPrincipalCallback"});
            throw new XWSSecurityRuntimeException(e);
        }
    }

    class PriviledgedHandler
    implements CallbackHandler {
        CallbackHandler delegate = null;

        public PriviledgedHandler(CallbackHandler handler) {
            this.delegate = handler;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PriviledgedHandler.this.delegate.handle(callbacks);
                        return null;
                    }
                    catch (Exception ex) {
                        throw new XWSSecurityRuntimeException(ex);
                    }
                }
            });
        }
    }
}

