/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.IssuedTokens;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.elements.str.DirectReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenResponseCollectionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ActAsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.IssuedTokensImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenResponseCollectionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenResponseImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedAttachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedProofTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedTokenCancelledImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedUnattachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.SecondaryParametersImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.StatusImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ValidateTargetImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.TrustNamespacePrefixMapper;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSTrustElementFactoryImpl
extends WSTrustElementFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public RequestSecurityToken createRSTForIssue(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lt) throws WSTrustException {
        RequestSecurityTokenImpl rst = new RequestSecurityTokenImpl(tokenType, requestType, context, scopes, claims, entropy, lt, null);
        return rst;
    }

    public RequestSecurityTokenResponse createRSTRForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedReference, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) throws WSTrustException {
        return new RequestSecurityTokenResponseImpl(tokenType, context, token, scopes, attachedReference, unattachedReference, proofToken, entropy, lt, null);
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) throws WSTrustException {
        return new RequestSecurityTokenResponseCollectionImpl(tokenType, context, token, scopes, attached, unattached, proofToken, entropy, lt);
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(List rstrs) throws WSTrustException {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        for (int i = 0; i < rstrs.size(); ++i) {
            rstrc.addRequestSecurityTokenResponse((RequestSecurityTokenResponse)rstrs.get(i));
        }
        return rstrc;
    }

    public RequestSecurityTokenResponse createRSTRForRenew(URI tokenType, URI context, RequestedSecurityToken token, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, null, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    public IssuedTokens createIssuedTokens(RequestSecurityTokenResponseCollection issuedTokens) {
        return new IssuedTokensImpl(issuedTokens);
    }

    public Entropy createEntropy(BinarySecret secret) {
        return new EntropyImpl(secret);
    }

    public Entropy createEntropy(EncryptedKey key) {
        return new EntropyImpl(key);
    }

    public BinarySecret createBinarySecret(byte[] rawValue, String type) {
        return new BinarySecretImpl(rawValue, type);
    }

    public BinarySecret createBinarySecret(Element elem) throws WSTrustException {
        return new BinarySecretImpl(BinarySecretImpl.fromElement(elem));
    }

    public Claims createClaims(Element elem) throws WSTrustException {
        return new ClaimsImpl(ClaimsImpl.fromElement(elem));
    }

    public Claims createClaims(Claims claims) throws WSTrustException {
        ClaimsImpl newClaims = new ClaimsImpl();
        if (claims != null) {
            newClaims.setDialect(claims.getDialect());
            newClaims.getAny().addAll(claims.getAny());
            newClaims.getOtherAttributes().putAll(claims.getOtherAttributes());
        }
        return newClaims;
    }

    public Claims createClaims() throws WSTrustException {
        return new ClaimsImpl();
    }

    public Status createStatus(String code, String reason) {
        return new StatusImpl(code, reason);
    }

    public Lifetime createLifetime(AttributedDateTime created, AttributedDateTime expires) {
        return new LifetimeImpl(created, expires);
    }

    public OnBehalfOf createOnBehalfOf(Token oboToken) {
        return new OnBehalfOfImpl(oboToken);
    }

    public ActAs createActAs(Token actAsToken) {
        return new ActAsImpl(actAsToken);
    }

    public RequestedSecurityToken createRequestedSecurityToken(Token token) {
        return new RequestedSecurityTokenImpl(token);
    }

    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityTokenImpl();
    }

    public DirectReference createDirectReference(String valueType, String uri) {
        return new DirectReferenceImpl(valueType, uri);
    }

    public KeyIdentifier createKeyIdentifier(String valueType, String encodingType) {
        return new KeyIdentifierImpl(valueType, encodingType);
    }

    public SecurityTokenReference createSecurityTokenReference(Reference ref) {
        return new SecurityTokenReferenceImpl(ref);
    }

    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference str) {
        return new RequestedAttachedReferenceImpl(str);
    }

    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference str) {
        return new RequestedUnattachedReferenceImpl(str);
    }

    public RequestedProofToken createRequestedProofToken() {
        return new RequestedProofTokenImpl();
    }

    public RequestSecurityToken createRSTForRenew(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        return new RequestSecurityTokenImpl(tokenType, requestType, context, target, apd, renewingInfo);
    }

    public RenewTarget createRenewTarget(SecurityTokenReference str) {
        return new RenewTargetImpl(str);
    }

    public CancelTarget createCancelTarget(SecurityTokenReference str) {
        return new CancelTargetImpl(str);
    }

    public ValidateTarget createValidateTarget(Token token) {
        return new ValidateTargetImpl(token);
    }

    public SecondaryParameters createSecondaryParameters() {
        return new SecondaryParametersImpl();
    }

    public UseKey createUseKey(Token token, String sig) {
        UseKeyImpl useKey = new UseKeyImpl(token);
        if (sig != null) {
            useKey.setSignatureID(URI.create(sig));
        }
        return useKey;
    }

    public RequestSecurityToken createRSTForCancel(URI requestType, CancelTarget target) {
        return new RequestSecurityTokenImpl(null, requestType, target);
    }

    public RequestSecurityTokenResponse createRSTRForCancel() {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl();
        rstr.setRequestedTokenCancelled(new RequestedTokenCancelledImpl());
        return rstr;
    }

    public RequestSecurityToken createRSTForValidate(URI tokenType, URI requestType) {
        return new RequestSecurityTokenImpl(tokenType, requestType);
    }

    public RequestSecurityTokenResponse createRSTRForValidate(URI tokenType, RequestedSecurityToken token, Status status) {
        return new RequestSecurityTokenResponseImpl(tokenType, null, token, null, null, null, null, null, null, status);
    }

    public RequestSecurityToken createRST() {
        return new RequestSecurityTokenImpl();
    }

    public RequestSecurityTokenResponse createRSTR() {
        return new RequestSecurityTokenResponseImpl();
    }

    public RequestSecurityTokenResponseCollection createRSTRC(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        for (int i = 0; i < rstrs.size(); ++i) {
            rstrc.addRequestSecurityTokenResponse(rstrs.get(i));
        }
        return rstrc;
    }

    public RequestSecurityToken createRSTFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal(src, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityToken createRSTFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal((Node)elem, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal(src, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal((Node)elem, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal(src, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Element elem) {
        this.checkElement(elem);
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal((Node)elem, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityToken createRSTFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenType type = (RequestSecurityTokenType)elem.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RST from JAXBElement", e);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)elem.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RSTR from JAXBElement", e);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)elem.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RSTRCollection from JAXBElement", e);
        }
    }

    public Object createResponseFrom(JAXBElement elem) {
        String local = elem.getName().getLocalPart();
        if (local.equalsIgnoreCase("RequestSecurityTokenResponseType")) {
            return this.createRSTRFrom(elem);
        }
        return this.createRSTRCollectionFrom(elem);
    }

    public SecurityTokenReference createSecurityTokenReference(JAXBElement elem) {
        try {
            SecurityTokenReferenceType type = (SecurityTokenReferenceType)elem.getValue();
            return new SecurityTokenReferenceImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating STR from JAXBElement", e);
        }
    }

    public SecurityContextToken createSecurityContextToken(URI identifier, String instance, String wsuId) {
        throw new UnsupportedOperationException("this operation is not supported");
    }

    public JAXBElement toJAXBElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toJAXBElement((RequestSecurityToken)request);
        }
        return null;
    }

    public JAXBElement toJAXBElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toJAXBElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toJAXBElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public JAXBElement toJAXBElement(SecurityTokenReference str) {
        JAXBElement strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)str);
        return strElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityToken rst) {
        JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)rst);
        return rstElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityTokenResponse rstr) {
        JAXBElement<RequestSecurityTokenResponseType> rstElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
        return rstElement;
    }

    public JAXBElement toJAXBElement(Entropy entropy) {
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)entropy);
        return etElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityTokenResponseCollection rstrCollection) {
        JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)rstrCollection);
        return rstElement;
    }

    public Source toSource(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toSource((RequestSecurityToken)request);
        }
        return null;
    }

    public Source toSource(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toSource((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toSource((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public Source toSource(RequestSecurityToken rst) {
        return new DOMSource(this.toElement(rst));
    }

    public Source toSource(RequestSecurityTokenResponse rstr) {
        return new DOMSource(this.toElement(rstr));
    }

    public Source toSource(RequestSecurityTokenResponseCollection rstrCollection) {
        return new DOMSource(this.toElement(rstrCollection));
    }

    public Element toElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toElement((RequestSecurityToken)request);
        }
        return null;
    }

    public Element toElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public Element toElement(RequestSecurityToken rst) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)rst);
            this.getMarshaller().marshal(rstElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(RequestSecurityTokenResponse rstr) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(RequestSecurityTokenResponse rstr, Document doc) {
        try {
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)rstrCollection);
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(BinarySecret bs) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)bs);
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(SecurityTokenReference str, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)str);
            this.getMarshaller().marshal((Object)strElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Element toElement(BinarySecret bs, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)bs);
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Marshaller getMarshaller() {
        try {
            Marshaller marshaller = WSTrustElementFactoryImpl.getContext((WSTrustVersion)WSTrustVersion.WS_TRUST_13).createMarshaller();
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new TrustNamespacePrefixMapper());
            return marshaller;
        }
        catch (PropertyException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
        }
        catch (JAXBException jbe) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
        }
    }

    private void checkElement(Element elem) {
        if (elem != null && elem.getLocalName().equalsIgnoreCase("Fault")) {
            try {
                QName qname = null;
                Node codeNode = elem.getFirstChild();
                Node reasonNode = elem.getLastChild();
                String reasonText = reasonNode.getFirstChild().getTextContent();
                if (elem.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    qname = new QName("http://schemas.xmlsoap.org/soap/envelope/", elem.getLocalName());
                    throw new SOAPFaultException(SOAPFactory.newInstance((String)"SOAP 1.1 Protocol").createFault(reasonText, qname));
                }
                if (elem.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                    qname = new QName("http://www.w3.org/2003/05/soap-envelope", elem.getLocalName());
                    throw new SOAPFaultException(SOAPFactory.newInstance((String)"SOAP 1.2 Protocol").createFault(reasonText, qname));
                }
            }
            catch (SOAPException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
    }
}

