/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.jmx.JmxConnectorServerCreator;
import com.sun.xml.ws.api.config.management.jmx.JmxConstants;
import com.sun.xml.ws.api.config.management.jmx.JmxUtil;
import com.sun.xml.ws.api.config.management.jmx.ReconfigMBean;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.jmx.MBeanAttribute;
import com.sun.xml.ws.config.management.jmx.Reconfig;
import com.sun.xml.ws.config.management.jmx.ReconfigAttribute;
import com.sun.xml.ws.config.management.jmx.ReconfigNotification;
import com.sun.xml.ws.metro.api.config.management.CommunicationServer;
import com.sun.xml.ws.metro.api.config.management.Configurator;
import com.sun.xml.ws.metro.api.config.management.EndpointStarter;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.metro.api.config.management.ReconfigNotifier;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXAgent<T>
implements CommunicationServer<T> {
    private static final Logger LOGGER = Logger.getLogger(JMXAgent.class);
    private static final QName JMX_CONNECTOR_SERVER_ENVIRONMENT_NAME = new QName("http://java.sun.com/xml/ns/metro/management", "JmxConnectorServerEnvironment");
    private static final QName JMX_SERVICE_URL_PARAMETER_NAME = new QName("http://java.sun.com/xml/ns/metro/management", "JmxServiceUrl");
    private static final QName JMX_CONNECTOR_SERVER_CREATOR_PARAMETER_NAME = new QName("http://java.sun.com/xml/ns/metro/management", "JmxConnectorServerCreator");
    private MBeanServer server;
    private JMXConnectorServer connector;
    private String endpointId;
    private ManagedEndpoint<T> managedEndpoint;
    private EndpointCreationAttributes endpointCreationAttributes;
    private ClassLoader classLoader;
    private Configurator<T> configurator;

    public void init(ManagedEndpoint<T> endpoint, ManagedServiceAssertion assertion, EndpointCreationAttributes creationAttributes, ClassLoader classLoader, Configurator<T> configurator, EndpointStarter starter) {
        JMXServiceURL jmxUrl = null;
        this.managedEndpoint = endpoint;
        this.endpointId = endpoint.getId();
        this.endpointCreationAttributes = creationAttributes;
        this.classLoader = classLoader;
        this.configurator = configurator;
        this.server = MBeanServerFactory.createMBeanServer();
        jmxUrl = this.getServiceURL(assertion);
        Map<String, String> env = JMXAgent.getConnectorServerEnvironment(assertion);
        this.connector = JMXAgent.getJmxConnectorServer(assertion, jmxUrl, env, this.server);
    }

    public void start() {
        if (this.server != null && this.connector != null) {
            ReconfigMBean mbean = this.createMBean();
            try {
                this.server.registerMBean(mbean, this.getObjectName());
                this.connector.start();
                LOGGER.info(ManagementMessages.WSM_5001_ENDPOINT_CREATED((Object)this.endpointId, (Object)this.connector.getAddress()));
            }
            catch (InstanceAlreadyExistsException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5041_MBEAN_INSTANCE_EXISTS((Object)mbean), (Throwable)ex));
            }
            catch (MBeanRegistrationException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5042_MBEAN_REGISTRATION_FAILED((Object)mbean), (Throwable)ex));
            }
            catch (NotCompliantMBeanException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5042_MBEAN_REGISTRATION_FAILED((Object)mbean), (Throwable)ex));
            }
            catch (IOException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5043_MBEAN_CONNECTOR_START_FAILED((Object)this.connector), (Throwable)ex));
            }
        } else {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5044_MBEAN_SERVER_START_FAILED((Object)this.server, (Object)this.connector)));
        }
    }

    public void stop() {
        try {
            if (this.connector != null) {
                this.connector.stop();
            }
        }
        catch (IOException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5046_MBEAN_CONNECTOR_STOP_FAILED((Object)this.connector), (Throwable)ex));
        }
        finally {
            ObjectName name = this.getObjectName();
            try {
                if (this.server != null) {
                    this.server.unregisterMBean(name);
                }
            }
            catch (InstanceNotFoundException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5047_MBEAN_UNREGISTER_INSTANCE_FAILED((Object)name), (Throwable)ex));
            }
            catch (MBeanRegistrationException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5048_MBEAN_UNREGISTRATION_FAILED((Object)name), (Throwable)ex));
            }
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder("JMXAgent [ ");
        text.append("Endpoint ID = ").append(this.endpointId);
        text.append(", ManagedEndpoint = ").append(this.managedEndpoint);
        text.append(", MBeanServer = ").append(this.server);
        text.append(", JMXConnectorServer = ").append(this.connector);
        text.append(", EndpointCreationAttributes = ").append(this.endpointCreationAttributes);
        text.append(", ClassLoader = ").append(this.classLoader);
        text.append(" ]");
        return text.toString();
    }

    private ReconfigMBean createMBean() {
        HashMap<String, MBeanAttribute> attributeToListener = new HashMap<String, MBeanAttribute>();
        HashMap<String, ReconfigNotification> notificationToListener = new HashMap<String, ReconfigNotification>();
        Reconfig mbean = new Reconfig(attributeToListener, notificationToListener);
        attributeToListener.put(JmxConstants.SERVICE_POLICIES_ATTRIBUTE_NAME, new ReconfigAttribute<T>(this.managedEndpoint, this.configurator, this.endpointCreationAttributes, this.classLoader));
        ReconfigNotification notification = new ReconfigNotification(mbean, this.getObjectName());
        notificationToListener.put(notification.getName(), notification);
        this.managedEndpoint.addNotifier((ReconfigNotifier)notification);
        return mbean;
    }

    private ObjectName getObjectName() {
        try {
            return JmxUtil.getObjectName((String)this.endpointId);
        }
        catch (MalformedObjectNameException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5049_INVALID_OBJECT_NAME(), (Throwable)e));
        }
    }

    private JMXServiceURL getServiceURL(ManagedServiceAssertion managedService) {
        String jmxServiceUrl = null;
        try {
            Map<QName, String> parameters = JMXAgent.getParameters(managedService);
            if (parameters != null) {
                jmxServiceUrl = parameters.get(JMX_SERVICE_URL_PARAMETER_NAME);
            }
            if (jmxServiceUrl == null) {
                jmxServiceUrl = "service:jmx:rmi:///jndi/rmi://localhost:8686/metro/" + this.endpointId;
            }
            LOGGER.config(ManagementMessages.WSM_5005_JMX_SERVICE_URL((Object)jmxServiceUrl));
            return new JMXServiceURL(jmxServiceUrl);
        }
        catch (MalformedURLException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5050_INVALID_JMX_SERVICE_URL(jmxServiceUrl), (Throwable)ex));
        }
    }

    private static Map<String, String> getConnectorServerEnvironment(ManagedServiceAssertion assertion) {
        Collection records = assertion.getCommunicationServerImplementations();
        for (ManagedServiceAssertion.ImplementationRecord record : records) {
            Collection nestedParameters;
            String name = record.getImplementation();
            if (name != null && !name.equals(JMXAgent.class.getName()) || (nestedParameters = record.getNestedParameters()) == null) continue;
            for (ManagedServiceAssertion.NestedParameters parameter : nestedParameters) {
                if (!JMX_CONNECTOR_SERVER_ENVIRONMENT_NAME.equals(parameter.getName())) continue;
                Map parameters = parameter.getParameters();
                HashMap<String, String> result = new HashMap<String, String>();
                if (parameters != null) {
                    for (Map.Entry entry : parameters.entrySet()) {
                        result.put(((QName)entry.getKey()).getLocalPart(), (String)entry.getValue());
                    }
                }
                return result;
            }
        }
        return null;
    }

    private static JMXConnectorServer getJmxConnectorServer(ManagedServiceAssertion managedService, JMXServiceURL jmxUrl, Map<String, String> env, MBeanServer server) {
        String connectorServerName = null;
        try {
            Map<QName, String> parameters = JMXAgent.getParameters(managedService);
            if (parameters != null && (connectorServerName = parameters.get(JMX_CONNECTOR_SERVER_CREATOR_PARAMETER_NAME)) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(ManagementMessages.WSM_5051_FOUND_JMX_CONNECTOR_SERVER_CREATOR((Object)connectorServerName));
                }
                Class<?> creatorClass = Class.forName(connectorServerName);
                JmxConnectorServerCreator creator = (JmxConnectorServerCreator)creatorClass.newInstance();
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    LOGGER.config(ManagementMessages.WSM_5052_INVOKING_JMX_CONNECTOR_SERVER_CREATOR((Object)creator, (Object)jmxUrl, env, (Object)server));
                }
                return creator.create(jmxUrl, env, server);
            }
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(ManagementMessages.WSM_5089_CREATING_JMX_CONNECTOR_SERVER((Object)jmxUrl, env, (Object)server));
            }
            return JMXConnectorServerFactory.newJMXConnectorServer(jmxUrl, env, server);
        }
        catch (ClassNotFoundException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5053_CLASS_NOT_FOUND_JMX_CONNECTOR_SERVER_CREATOR(connectorServerName), (Throwable)e));
        }
        catch (ClassCastException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5054_FAILED_CLASS_CAST_JMX_CONNECTOR_SERVER_CREATOR(connectorServerName), (Throwable)e));
        }
        catch (InstantiationException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5090_FAILED_INSTANTIATION_JMX_CONNECTOR_SERVER_CREATOR(connectorServerName), (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5090_FAILED_INSTANTIATION_JMX_CONNECTOR_SERVER_CREATOR(connectorServerName), (Throwable)e));
        }
        catch (IOException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5045_MBEAN_CONNECTOR_CREATE_FAILED((Object)jmxUrl), (Throwable)e));
        }
    }

    private static Map<QName, String> getParameters(ManagedServiceAssertion assertion) {
        Collection records = assertion.getCommunicationServerImplementations();
        Map parameters = null;
        for (ManagedServiceAssertion.ImplementationRecord record : records) {
            String name = record.getImplementation();
            if (name != null && !name.equals(JMXAgent.class.getName())) continue;
            parameters = record.getParameters();
            break;
        }
        return parameters;
    }
}

