/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultNonceManager;
import com.sun.xml.wss.impl.misc.HANonceManager;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URL;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="per-endpoint NonceManager")
@AMXMetadata(type="WSNonceManager")
public abstract class NonceManager {
    protected static final Logger LOGGER = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    public static final String nonceManager = "com.sun.xml.xwss.NonceManager";
    private static final String NONCE_MANAGER = "NonceManager";
    private static WeakHashMap<WSEndpoint, NonceManager> nonceMgrMap = new WeakHashMap();
    private static NonceManager jaxRPCNonceManager = null;
    private long maxNonceAge;

    @ManagedAttribute
    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public abstract boolean validateNonce(String var1, String var2) throws NonceException;

    public static synchronized NonceManager getInstance(long maxNonceAge, WSEndpoint endpoint) {
        NonceManager nonceMgr;
        if (endpoint == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("getInstance(): endpoint is null: using singleton", new Object[0]));
        }
        NonceManager nonceManager = nonceMgr = endpoint != null ? nonceMgrMap.get(endpoint) : jaxRPCNonceManager;
        if (nonceMgr != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("getInstance(%s): found existing: %s", endpoint, nonceMgr));
            }
            return nonceMgr;
        }
        URL url = SecurityUtil.loadFromClasspath("/META-INF/services/com.sun.xml.xwss.NonceManager");
        if (url != null) {
            Object obj = SecurityUtil.loadSPIClass(url, nonceManager);
            if (obj != null && !(obj instanceof NonceManager)) {
                throw new XWSSecurityRuntimeException("Class :" + obj.getClass().getName() + " is not a valid NonceManager");
            }
            nonceMgr = (NonceManager)obj;
        }
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            nonceMgr = new HANonceManager(maxNonceAge);
        } else if (url == null) {
            nonceMgr = new DefaultNonceManager();
        }
        if (nonceMgr == null) {
            nonceMgr = new DefaultNonceManager();
        }
        nonceMgr.setMaxNonceAge(maxNonceAge);
        if (endpoint != null) {
            nonceMgrMap.put(endpoint, nonceMgr);
            endpoint.getManagedObjectManager().registerAtRoot((Object)nonceMgr, NONCE_MANAGER);
        } else {
            jaxRPCNonceManager = nonceMgr;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("getInstance(%s): created: %s", endpoint, nonceMgr));
        }
        return nonceMgr;
    }

    public static synchronized void deleteInstance(WSEndpoint endpoint) {
        NonceManager o;
        NonceManager nonceManager = o = endpoint != null ? nonceMgrMap.remove(endpoint) : jaxRPCNonceManager;
        if (endpoint == null) {
            jaxRPCNonceManager = null;
        }
        if (endpoint != null && o != null) {
            endpoint.getManagedObjectManager().unregister((Object)o);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("deleteInstance(%s): %s", endpoint, o));
        }
    }

    public static class NonceException
    extends XWSSecurityException {
        public NonceException(String message) {
            super(message);
        }

        public NonceException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonceException(Throwable cause) {
            super(cause);
        }
    }
}

