/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedProofTokenType;
import com.sun.xml.ws.security.trust.impl.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestedProofTokenImpl
extends RequestedProofTokenType
implements RequestedProofToken {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private String tokenType;
    private URI computedKey;
    private BinarySecret secret;
    private SecurityTokenReference str;

    public RequestedProofTokenImpl() {
    }

    public RequestedProofTokenImpl(String proofTokenType) {
        this.setProofTokenType(proofTokenType);
    }

    public RequestedProofTokenImpl(RequestedProofTokenType rptType) {
        JAXBElement obj = (JAXBElement)rptType.getAny();
        String local = obj.getName().getLocalPart();
        if (local.equalsIgnoreCase("ComputedKey")) {
            this.setComputedKey(URI.create((String)obj.getValue()));
        } else if (local.equalsIgnoreCase("BinarySecret")) {
            BinarySecretType bsType = (BinarySecretType)obj.getValue();
            this.setBinarySecret(new BinarySecretImpl(bsType));
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(local, null));
            throw new RuntimeException(LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(local, null));
        }
    }

    public String getProofTokenType() {
        return this.tokenType;
    }

    public final void setProofTokenType(@NotNull String proofTokenType) {
        if (!(proofTokenType.equalsIgnoreCase("BinarySecret") || proofTokenType.equalsIgnoreCase("ComputedKey") || proofTokenType.equalsIgnoreCase("EncryptedKey") || proofTokenType.equalsIgnoreCase("Custom") || proofTokenType.equalsIgnoreCase("SecurityTokenReference"))) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(proofTokenType, null));
            throw new RuntimeException(LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(proofTokenType, null));
        }
        this.tokenType = proofTokenType;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        if (reference != null) {
            this.str = reference;
            JAXBElement strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)reference);
            this.setAny(strElement);
        }
        this.setProofTokenType("SecurityTokenReference");
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.str;
    }

    public final void setComputedKey(@NotNull URI computedKey) {
        if (computedKey != null) {
            String ckString = computedKey.toString();
            if (!ckString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKHASHalgorithmURI()) && !ckString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKPSHA1algorithmURI())) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0028_INVALID_CK(ckString));
                throw new RuntimeException(LogStringsMessages.WST_0028_INVALID_CK(ckString));
            }
            this.computedKey = computedKey;
            JAXBElement<String> ckElement = new ObjectFactory().createComputedKey(computedKey.toString());
            this.setAny(ckElement);
        }
        this.setProofTokenType("ComputedKey");
    }

    public URI getComputedKey() {
        return this.computedKey;
    }

    public final void setBinarySecret(BinarySecret secret) {
        if (secret != null) {
            this.secret = secret;
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)secret);
            this.setAny(bsElement);
        }
        this.setProofTokenType("BinarySecret");
    }

    public BinarySecret getBinarySecret() {
        return this.secret;
    }

    public static RequestedProofTokenType fromElement(Element element) throws WSTrustException {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactory.getContext().createUnmarshaller();
            return (RequestedProofTokenType)unmarshaller.unmarshal((Node)element);
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), (Throwable)ex);
        }
    }
}

