/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.TargetResolver;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetResolverImpl
implements TargetResolver {
    private ProcessingContext ctx = null;
    private FilterProcessingContext fpContext = null;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public TargetResolverImpl(ProcessingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void resolveAndVerifyTargets(List<Target> actualTargets, List<Target> inferredTargets, WSSPolicy actualPolicy) throws XWSSecurityException {
        SignaturePolicy.FeatureBinding fp;
        String policyType = PolicyTypeUtil.signaturePolicy(actualPolicy) ? "Signature" : "Encryption";
        boolean isEndorsing = false;
        if (PolicyTypeUtil.signaturePolicy(actualPolicy) && (fp = (SignaturePolicy.FeatureBinding)actualPolicy.getFeatureBinding()).isEndorsingSignature()) {
            isEndorsing = true;
        }
        this.fpContext = new FilterProcessingContext(this.ctx);
        SecurityHeader header = this.fpContext.getSecurableSoapMessage().findSecurityHeader();
        Document doc = header.getOwnerDocument();
        for (Target actualTarget : actualTargets) {
            NodeList nl;
            boolean found = false;
            String targetInPolicy = this.getTargetValue(doc, actualTarget);
            for (Target inferredTarget : inferredTargets) {
                String targetInMessage = this.getTargetValue(doc, inferredTarget);
                if (targetInPolicy == null || !targetInPolicy.equals(targetInMessage)) continue;
                found = true;
                break;
            }
            if (found || targetInPolicy == null || (nl = doc.getElementsByTagName(targetInPolicy)) == null || nl.getLength() <= 0) continue;
            log.log(Level.SEVERE, LogStringsMessages.WSS_0206_POLICY_VIOLATION_EXCEPTION());
            log.log(Level.SEVERE, LogStringsMessages.WSS_0814_POLICY_VERIFICATION_ERROR_MISSING_TARGET(targetInPolicy, policyType));
            if (isEndorsing) {
                throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for Endorsing " + policyType);
            }
            throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for " + policyType);
        }
    }

    private String getTargetValue(Document doc, Target actualTarget) {
        String targetInPolicy = null;
        if (actualTarget.getType() == "qname") {
            targetInPolicy = actualTarget.getQName().getLocalPart();
        } else if (actualTarget.getType() == "uri") {
            String val = actualTarget.getValue();
            String id = null;
            id = val.charAt(0) == '#' ? val.substring(1, val.length()) : val;
            Element signedElement = doc.getElementById(id);
            if (signedElement != null) {
                targetInPolicy = signedElement.getLocalName();
            }
        }
        return targetInPolicy;
    }

    @Override
    public boolean isTargetPresent(List<Target> actualTargets) throws XWSSecurityException {
        FilterProcessingContext fpContext = new FilterProcessingContext(this.ctx);
        SecurityHeader header = fpContext.getSecurableSoapMessage().findSecurityHeader();
        Document doc = header.getOwnerDocument();
        for (Target actualTarget : actualTargets) {
            if (actualTarget.getType() == "xpath") {
                String val = actualTarget.getValue();
                try {
                    XPathFactory xpathFactory = XPathFactory.newInstance();
                    XPath xpath = xpathFactory.newXPath();
                    xpath.setNamespaceContext(fpContext.getSecurableSoapMessage().getNamespaceContext());
                    XPathExpression xpathExpr = xpath.compile(val);
                    NodeList nodes = (NodeList)xpathExpr.evaluate(fpContext.getSecurableSoapMessage().getSOAPPart(), XPathConstants.NODESET);
                    if (nodes == null || nodes.getLength() <= 0) continue;
                    return true;
                }
                catch (XPathExpressionException xpe) {
                    throw new XWSSecurityException((Throwable)xpe);
                }
            }
            String targetInPolicy = this.getTargetValue(doc, actualTarget);
            NodeList nl = doc.getElementsByTagName(targetInPolicy);
            if (nl == null || nl.getLength() <= 0) continue;
            return true;
        }
        return false;
    }
}

