/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedData
public class NonceCache
extends TimerTask {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Map<String, String> nonceCache = Collections.synchronizedMap(new HashMap());
    private Map<String, String> oldNonceCache = Collections.synchronizedMap(new HashMap());
    private long MAX_NONCE_AGE = 900000L;
    private boolean scheduledFlag = false;
    private boolean canceledFlag = false;

    @ManagedAttribute
    private Map<String, String> getNonceCache() {
        return this.nonceCache;
    }

    @ManagedAttribute
    private Map<String, String> getOldNonceCache() {
        return this.oldNonceCache;
    }

    public NonceCache() {
    }

    public NonceCache(long maxNonceAge) {
        this.MAX_NONCE_AGE = maxNonceAge;
    }

    public boolean validateAndCacheNonce(String nonce, String created) throws NonceManager.NonceException {
        if (this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce)) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0815_NONCE_REPEATED_ERROR(nonce));
            throw new NonceManager.NonceException(LogStringsMessages.WSS_0815_NONCE_REPEATED_ERROR(nonce));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Storing Nonce Value {0} into {1}", new Object[]{nonce, this});
        }
        this.nonceCache.put(nonce, created);
        return true;
    }

    @ManagedAttribute
    public boolean isScheduled() {
        return this.scheduledFlag;
    }

    public void scheduled(boolean flag) {
        this.scheduledFlag = flag;
    }

    @ManagedAttribute
    public boolean wasCanceled() {
        return this.canceledFlag;
    }

    @Override
    public void run() {
        if (this.nonceCache.isEmpty()) {
            this.cancel();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Canceled Timer Task due to inactivity ...for {0}", this);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Clearing old Nonce values...for {0}", this);
        }
        this.oldNonceCache.clear();
        Map<String, String> temp = this.nonceCache;
        this.nonceCache = this.oldNonceCache;
        this.oldNonceCache = temp;
    }

    @Override
    public boolean cancel() {
        boolean ret = super.cancel();
        this.canceledFlag = true;
        this.oldNonceCache.clear();
        this.nonceCache.clear();
        return ret;
    }

    @ManagedAttribute
    public long getMaxNonceAge() {
        return this.MAX_NONCE_AGE;
    }
}

