/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.message.jaxws;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.localization.LocalizationMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class SerializableMessage {
    private static final Logger LOGGER = Logger.getLogger(SerializableMessage.class);
    @Nullable
    private Packet packet;
    @NotNull
    private final Message message;
    @Nullable
    private final String wsaAction;

    public SerializableMessage(Packet packet, String wsaAction) {
        this.packet = packet;
        this.message = packet.getMessage();
        this.wsaAction = wsaAction;
    }

    public SerializableMessage(Message message, String wsaAction) {
        assert (message != null);
        this.packet = null;
        this.message = message;
        this.wsaAction = wsaAction;
    }

    public Message getMessage() {
        return this.message;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public void setPacket(Packet newPacket) {
        newPacket.setMessage(this.message);
        this.packet = newPacket;
    }

    public String getWsaAction() {
        return this.wsaAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.message != null) {
                XMLStreamWriter xsw = XMLStreamWriterFactory.create((OutputStream)baos, (String)"UTF-8");
                try {
                    this.packet.getMessage().copy().writeTo(xsw);
                }
                catch (XMLStreamException ex) {
                    throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM(), ex))));
                }
                finally {
                    try {
                        xsw.close();
                    }
                    catch (XMLStreamException ex) {
                        LOGGER.warning(LocalizationMessages.WSRX_1002_ERROR_CLOSING_XSW_AFTER_MSG_SERIALIZATION(), (Throwable)ex);
                    }
                }
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ex) {
                LOGGER.warning(LocalizationMessages.WSRX_1003_ERROR_CLOSING_BAOS_AFTER_MSG_SERIALIZATION(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerializableMessage newInstance(@NotNull InputStream dataStream, String wsaAction) {
        try {
            SerializableMessage serializableMessage;
            XMLStreamReader xsr = XMLStreamReaderFactory.create(null, (InputStream)dataStream, (String)"UTF-8", (boolean)true);
            try {
                Message m = Messages.create((XMLStreamReader)xsr);
                serializableMessage = new SerializableMessage(m, wsaAction);
            }
            catch (Throwable throwable) {
                try {
                    xsr.close();
                }
                catch (XMLStreamException ex) {
                    LOGGER.warning(LocalizationMessages.WSRX_1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION(), (Throwable)ex);
                }
                throw throwable;
            }
            try {
                xsr.close();
            }
            catch (XMLStreamException ex) {
                LOGGER.warning(LocalizationMessages.WSRX_1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION(), (Throwable)ex);
            }
            return serializableMessage;
        }
        finally {
            try {
                dataStream.close();
            }
            catch (IOException ex) {
                LOGGER.warning(LocalizationMessages.WSRX_1005_ERROR_CLOSING_IS_AFTER_MSG_DESERIALIZATION(), (Throwable)ex);
            }
        }
    }
}

