/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.metro.api.config.management;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.Reconfigurable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.ReconfigNotifier;
import com.sun.xml.ws.policy.PolicyMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedEndpoint<T>
extends WSEndpoint<T> {
    private static final Logger LOGGER = Logger.getLogger(ManagedEndpoint.class);
    private WSEndpoint<T> endpointDelegate;
    private final Collection<ReconfigNotifier> reconfigNotifiers = new LinkedList<ReconfigNotifier>();
    private static final long ENDPOINT_DISPOSE_DELAY_DEFAULT = 120000L;
    private long endpointDisposeDelay = 120000L;
    private final ScheduledExecutorService disposeThreadPool = Executors.newScheduledThreadPool(1);
    private final EndpointCreationAttributes creationAttributes;

    public ManagedEndpoint(WSEndpoint<T> endpoint, EndpointCreationAttributes attributes) {
        this.creationAttributes = attributes;
        this.endpointDelegate = endpoint;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        for (ReconfigNotifier notifier : this.reconfigNotifiers) {
            notifier.sendNotification();
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(ManagementMessages.WSM_5066_STARTING_ENDPOINT());
        }
    }

    public void addNotifier(ReconfigNotifier notifier) {
        this.reconfigNotifiers.add(notifier);
    }

    public EndpointCreationAttributes getCreationAttributes() {
        return this.creationAttributes;
    }

    public synchronized void swapEndpointDelegate(WSEndpoint<T> endpoint) {
        Set endpointComponents = endpoint.getComponentRegistry();
        WSEndpoint<T> oldEndpoint = this.endpointDelegate;
        this.endpointDelegate = endpoint;
        for (EndpointComponent component : endpointComponents) {
            Reconfigurable reconfigurable = (Reconfigurable)component.getSPI(Reconfigurable.class);
            if (reconfigurable == null) continue;
            reconfigurable.reconfigure();
        }
        this.disposeDelegate(oldEndpoint);
        LOGGER.info(ManagementMessages.WSM_5000_RECONFIGURED_ENDPOINT((Object)this));
    }

    public synchronized void dispose() {
        this.disposeThreadPool.shutdown();
        if (this.endpointDelegate != null) {
            this.endpointDelegate.dispose();
        }
    }

    public Codec createCodec() {
        return this.endpointDelegate.createCodec();
    }

    public QName getServiceName() {
        return this.endpointDelegate.getServiceName();
    }

    public QName getPortName() {
        return this.endpointDelegate.getPortName();
    }

    public Class<T> getImplementationClass() {
        return this.endpointDelegate.getImplementationClass();
    }

    public WSBinding getBinding() {
        return this.endpointDelegate.getBinding();
    }

    public Container getContainer() {
        return this.endpointDelegate.getContainer();
    }

    public WSDLPort getPort() {
        return this.endpointDelegate.getPort();
    }

    public void setExecutor(Executor exec) {
        this.endpointDelegate.setExecutor(exec);
    }

    public void schedule(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.schedule(request, callback, interceptor);
    }

    public void process(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.process(request, callback, interceptor);
    }

    public WSEndpoint.PipeHead createPipeHead() {
        return this.endpointDelegate.createPipeHead();
    }

    public ServiceDefinition getServiceDefinition() {
        return this.endpointDelegate.getServiceDefinition();
    }

    public Set<EndpointComponent> getComponentRegistry() {
        return this.endpointDelegate.getComponentRegistry();
    }

    @NotNull
    public Set<Component> getComponents() {
        return this.endpointDelegate.getComponents();
    }

    public SEIModel getSEIModel() {
        return this.endpointDelegate.getSEIModel();
    }

    public PolicyMap getPolicyMap() {
        return this.endpointDelegate.getPolicyMap();
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.endpointDelegate.getManagedObjectManager();
    }

    public void closeManagedObjectManager() {
        this.endpointDelegate.closeManagedObjectManager();
    }

    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.endpointDelegate.getAssemblerContext();
    }

    private void disposeDelegate(final WSEndpoint<T> endpoint) {
        Runnable dispose = new Runnable(){
            final WSEndpoint<T> disposableEndpoint;
            {
                this.disposableEndpoint = endpoint;
            }

            public void run() {
                try {
                    this.disposableEndpoint.dispose();
                }
                catch (WebServiceException e) {
                    LOGGER.severe(ManagementMessages.WSM_5101_DISPOSE_FAILED(), (Throwable)e);
                }
            }
        };
        this.disposeThreadPool.schedule(dispose, this.endpointDisposeDelay, TimeUnit.MILLISECONDS);
    }
}

