/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.dev;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class WSATRuntimeConfig {
    private static final Lock DATA_LOCK = new ReentrantLock();
    private static WSATRuntimeConfig instance;
    private static boolean isWsatRecoveryEnabled;
    private static String txLogLocation;
    private static boolean isWsatSslEnabled;
    private static String hostName;
    private static String httpPort;
    private static String httpsPort;

    private WSATRuntimeConfig() {
    }

    public static Initializer initializer() {
        DATA_LOCK.lock();
        return new Initializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSATRuntimeConfig getInstance() {
        DATA_LOCK.lock();
        try {
            if (instance == null) {
                instance = new WSATRuntimeConfig();
            }
            WSATRuntimeConfig wSATRuntimeConfig = instance;
            return wSATRuntimeConfig;
        }
        finally {
            DATA_LOCK.unlock();
        }
    }

    public boolean isWSATRecoveryEnabled() {
        return isWsatRecoveryEnabled;
    }

    public String getHostAndPort() {
        return isWsatSslEnabled ? "https://" + hostName + ":" + httpsPort : "http://" + hostName + ":" + httpPort;
    }

    public String getTxLogLocation() {
        return txLogLocation;
    }

    static {
        isWsatRecoveryEnabled = Boolean.valueOf(System.getProperty("wsat.recovery.enabled", "true"));
        isWsatSslEnabled = Boolean.valueOf(System.getProperty("wsat.ssl.enabled", "false"));
        hostName = "localhost";
        httpPort = "8080";
        httpsPort = "8181";
    }

    public class WSATRecoveryEventListener
    implements RecoveryEventListener {
        public void beforeRecovery(boolean delegated, String instance) {
            if (!delegated) {
                return;
            }
        }

        public void afterRecovery(boolean success, boolean delegated, String instance) {
        }
    }

    public static interface RecoveryEventListener {
        public void beforeRecovery(boolean var1, String var2);

        public void afterRecovery(boolean var1, boolean var2, String var3);
    }

    public static final class Initializer {
        private Initializer() {
        }

        public Initializer hostName(String value) {
            hostName = value;
            return this;
        }

        public Initializer httpPort(String value) {
            httpPort = value;
            return this;
        }

        public Initializer httpsPort(String value) {
            httpsPort = value;
            return this;
        }

        public Initializer txLogLocation(String value) {
            txLogLocation = value;
            return this;
        }

        public Initializer enableWsatRecovery(boolean value) {
            isWsatRecoveryEnabled = value;
            return this;
        }

        public Initializer enableWsatSsl(boolean value) {
            isWsatSslEnabled = value;
            return this;
        }

        public void done() {
            DATA_LOCK.unlock();
        }
    }
}

