/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.xwss.SecurityConfiguration;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConstants;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class XWSSClientTube
extends AbstractFilterTubeImpl {
    protected WSDLPort port = null;
    protected WSService service = null;
    protected WSBinding binding = null;
    protected SOAPFactory soapFactory = null;
    protected MessageFactory messageFactory = null;
    protected SOAPVersion soapVersion = null;
    protected boolean isSOAP12 = false;
    private static final String MESSAGE_SECURITY_CONFIGURATION = "com.sun.xml.ws.security.configuration";
    private static final String CONTEXT_WSDL_OPERATION = "com.sun.xml.ws.wsdl.operation";
    protected boolean wasConfigChecked = false;
    protected SecurityConfiguration sConfig;

    public XWSSClientTube(WSDLPort prt, WSService svc, WSBinding bnd, Tube nextTube) {
        super(nextTube);
        this.port = prt;
        this.service = svc;
        this.binding = bnd;
        this.soapVersion = bnd.getSOAPVersion();
        this.isSOAP12 = this.soapVersion == SOAPVersion.SOAP_12;
        this.soapFactory = this.soapVersion.getSOAPFactory();
        this.messageFactory = this.soapVersion.getMessageFactory();
    }

    public XWSSClientTube(XWSSClientTube that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
        this.port = that.port;
        this.service = that.service;
        this.soapFactory = that.soapFactory;
        this.messageFactory = that.messageFactory;
        this.soapVersion = that.soapVersion;
        this.isSOAP12 = that.isSOAP12;
        this.sConfig = that.sConfig;
        this.wasConfigChecked = that.wasConfigChecked;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new XWSSClientTube(this, cloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        try {
            this.sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
            if (this.sConfig == null) {
                URL url = null;
                if (!this.wasConfigChecked) {
                    this.wasConfigChecked = true;
                    String configUrl = "META-INF/client_security_config.xml";
                    url = SecurityUtil.loadFromClasspath(configUrl);
                }
                if (url != null) {
                    try {
                        this.sConfig = new SecurityConfiguration(url);
                        packet.invocationProperties.put(MESSAGE_SECURITY_CONFIGURATION, this.sConfig);
                    }
                    catch (XWSSecurityException e) {
                        throw new XWSSecurityRuntimeException(e);
                    }
                } else {
                    return this.doInvoke(this.next, packet);
                }
            }
            Packet ret = this.secureRequest(packet);
            return this.doInvoke(this.next, ret);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
    }

    @Override
    public NextAction processResponse(Packet ret) {
        try {
            if (ret == null || ret.getMessage() == null) {
                return this.doReturnWith(ret);
            }
            Packet response = this.validateResponse(ret);
            return this.doReturnWith(response);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
    }

    @Override
    public void preDestroy() {
    }

    public Packet validateResponse(Packet packet) {
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return packet;
            }
            SOAPMessage message = null;
            try {
                message = packet.getMessage().readAsSOAPMessage();
            }
            catch (SOAPException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            String operation = (String)packet.invocationProperties.get(CONTEXT_WSDL_OPERATION);
            StaticApplicationContext sContext = this.getPolicyContext(packet, sConfig);
            sContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            ProcessingContextImpl context = new ProcessingContextImpl(packet.invocationProperties);
            context.setPolicyContext(sContext);
            context.setSOAPMessage(message);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(true);
            if (config.retainSecurityHeader()) {
                context.retainSecurityHeader(true);
            }
            if (config.resetMustUnderstand()) {
                context.resetMustUnderstand(true);
            }
            SecurityRecipient.validateMessage(context);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException, this.isSOAP12);
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe, this.isSOAP12);
        }
    }

    public Packet secureRequest(Packet packet) {
        ProcessingContextImpl context = null;
        SOAPMessage message = null;
        try {
            message = packet.getMessage().readAsSOAPMessage();
        }
        catch (SOAPException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return packet;
            }
            WSDLBoundOperation op = null;
            if (this.port != null) {
                op = packet.getMessage().getOperation(this.port);
            }
            QName operationQName = null;
            if (op != null) {
                operationQName = op.getName();
            }
            String operation = null;
            try {
                operation = operationQName == null ? this.getOperationName(message) : operationQName.toString();
            }
            catch (XWSSecurityException e) {
                throw new WebServiceException((Throwable)e);
            }
            packet.invocationProperties.put(CONTEXT_WSDL_OPERATION, operation);
            StaticApplicationContext sContext = this.getPolicyContext(packet, sConfig);
            sContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            context = new ProcessingContextImpl(packet.invocationProperties);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(false);
            context.setSOAPMessage(message);
            SecurityAnnotator.secureMessage(context);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (XWSSecurityException | WssSoapFaultException soapFaultException) {
            throw new WebServiceException((Throwable)soapFaultException);
        }
    }

    private String getOperationName(SOAPMessage message) throws XWSSecurityException {
        Node node = null;
        Object key = null;
        SOAPBody body = null;
        if (message != null) {
            try {
                body = message.getSOAPBody();
            }
            catch (SOAPException ex) {
                throw new XWSSecurityException(ex);
            }
        } else {
            throw new XWSSecurityException("SOAPMessage in message context is null");
        }
        if (body == null) {
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        StringBuilder tmp = new StringBuilder();
        String operation = "";
        for (node = body.getFirstChild(); node != null; node = node.getNextSibling()) {
            tmp.append("{").append(node.getNamespaceURI()).append("}").append(node.getLocalName()).append(":");
        }
        operation = tmp.toString();
        if (operation.length() > 0) {
            return operation.substring(0, operation.length() - 1);
        }
        return operation;
    }

    public SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe, boolean isSOAP12) {
        SOAPFault fault = null;
        try {
            if (isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this + ": Internal Error while trying to create a SOAPFault");
        }
        return new SOAPFaultException(fault);
    }

    private StaticApplicationContext getPolicyContext(Packet packet, SecurityConfiguration config) {
        ApplicationSecurityConfiguration appconfig = config.getSecurityConfiguration();
        StaticApplicationContext iContext = (StaticApplicationContext)appconfig.getAllContexts().next();
        StaticApplicationContext sContext = new StaticApplicationContext(iContext);
        QName portQname = null;
        if (this.port != null) {
            portQname = this.port.getName();
        }
        String prt = null;
        prt = portQname == null ? "" : portQname.toString();
        sContext.setPortIdentifier(prt);
        return sContext;
    }
}

