/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.connectioncache.impl.transport;

import com.sun.xml.ws.transport.tcp.connectioncache.impl.transport.ConnectionCacheBlockingBase;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.Connection;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ConnectionFinder;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ContactInfo;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.OutboundConnectionCache;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public final class OutboundConnectionCacheBlockingImpl<C extends Connection>
extends ConnectionCacheBlockingBase<C>
implements OutboundConnectionCache<C> {
    private final int maxParallelConnections;
    private Map<ContactInfo<C>, CacheEntry<C>> entryMap;
    private Map<C, ConnectionState<C>> connectionMap;

    @Override
    public int maxParallelConnections() {
        return this.maxParallelConnections;
    }

    @Override
    protected String thisClassName() {
        return "OutboundConnectionCacheBlockingImpl";
    }

    public OutboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, int maxParallelConnections, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        if (maxParallelConnections < 1) {
            throw new IllegalArgumentException("maxParallelConnections must be > 0");
        }
        this.maxParallelConnections = maxParallelConnections;
        this.entryMap = new HashMap<ContactInfo<C>, CacheEntry<C>>();
        this.connectionMap = new HashMap<C, ConnectionState<C>>();
        if (this.debug()) {
            this.dprint(".constructor completed: " + cacheType);
        }
    }

    @Override
    public boolean canCreateNewConnection(ContactInfo<C> cinfo) {
        CacheEntry<C> entry = this.entryMap.get(cinfo);
        if (entry == null) {
            return true;
        }
        return this.internalCanCreateNewConnection(entry);
    }

    private boolean internalCanCreateNewConnection(CacheEntry<C> entry) {
        int totalConnectionsInEntry = entry.totalConnections();
        boolean createNewConnection = totalConnectionsInEntry == 0 || this.numberOfConnections() < (long)this.highWaterMark() && totalConnectionsInEntry < this.maxParallelConnections;
        return createNewConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry<C> getEntry(ContactInfo<C> cinfo) {
        if (this.debug()) {
            this.dprint("->getEntry: " + cinfo);
        }
        try {
            CacheEntry<C> result = this.entryMap.get(cinfo);
            if (result == null) {
                if (this.debug()) {
                    this.dprint(".getEntry: " + cinfo + " creating new CacheEntry");
                }
                result = new CacheEntry();
                this.entryMap.put(cinfo, result);
            } else if (this.debug()) {
                this.dprint(".getEntry: " + cinfo + " re-using existing CacheEntry");
            }
            CacheEntry<C> cacheEntry = result;
            return cacheEntry;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-getEntry: " + cinfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C tryNewConnection(CacheEntry<C> entry, ContactInfo<C> cinfo) throws IOException {
        if (this.debug()) {
            this.dprint("->tryNewConnection: " + cinfo);
        }
        try {
            Connection conn = null;
            if (this.internalCanCreateNewConnection(entry)) {
                conn = (Connection)cinfo.createConnection();
                if (this.debug()) {
                    this.dprint(".tryNewConnection: " + cinfo + " created connection " + conn);
                }
            }
            Connection connection = conn;
            return (C)connection;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-tryNewConnection: " + cinfo);
            }
        }
    }

    private void decrementTotalIdle() {
        if (this.debug()) {
            this.dprint("->decrementTotalIdle: totalIdle = " + this.totalIdle);
        }
        try {
            if (this.totalIdle > 0) {
                --this.totalIdle;
            } else if (this.debug()) {
                this.dprint(".decrementTotalIdle: incorrect idle count: was already 0");
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-decrementTotalIdle: totalIdle = " + this.totalIdle);
            }
        }
    }

    private void decrementTotalBusy() {
        if (this.debug()) {
            this.dprint("->decrementTotalBusy: totalBusy = " + this.totalBusy);
        }
        try {
            if (this.totalBusy > 0) {
                --this.totalBusy;
            } else if (this.debug()) {
                this.dprint(".decrementTotalBusy: incorrect idle count: was already 0");
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-decrementTotalBusy: totalBusy = " + this.totalBusy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeResultBusy(C result, ConnectionState<C> cs, CacheEntry<C> entry) {
        if (this.debug()) {
            this.dprint("->makeResultBusy: " + result + " was previously " + cs.csv);
        }
        try {
            switch (cs.csv) {
                case NEW: {
                    ++this.totalBusy;
                    break;
                }
                case IDLE: {
                    ++this.totalBusy;
                    this.decrementTotalIdle();
                    ConcurrentQueue.Handle handle = cs.reclaimableHandle;
                    if (handle == null) break;
                    if (!handle.remove() && this.debug()) {
                        this.dprint(".makeResultBusy: " + cs.cinfo + " result was not on reclaimable Q");
                    }
                    cs.reclaimableHandle = null;
                    break;
                }
            }
            entry.busyConnections.offer(result);
            cs.csv = ConnectionStateValue.BUSY;
            ++cs.busyCount;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-makeResultBusy: " + result);
            }
        }
    }

    private C tryIdleConnections(CacheEntry<C> entry) {
        if (this.debug()) {
            this.dprint("->tryIdleConnections");
        }
        try {
            Connection connection = (Connection)entry.idleConnections.poll();
            return (C)connection;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-tryIdleConnections");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C tryBusyConnections(CacheEntry<C> entry) {
        if (this.debug()) {
            this.dprint("->tryBusyConnections");
        }
        try {
            Connection result = (Connection)entry.busyConnections.poll();
            if (result == null) {
                throw new RuntimeException("INTERNAL ERROR: no busy connection available");
            }
            Connection connection = result;
            return (C)connection;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-tryBusyConnections");
            }
        }
    }

    @Override
    public synchronized C get(ContactInfo<C> cinfo) throws IOException {
        return this.get(cinfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionState<C> getConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
        if (this.debug()) {
            this.dprint("->getConnectionState: " + conn);
        }
        try {
            ConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".getConnectionState: " + conn + " creating new ConnectionState" + cs);
                }
                cs = new ConnectionState<C>(cinfo, entry, conn);
                this.connectionMap.put(conn, cs);
            } else if (this.debug()) {
                this.dprint(".getConnectionState: " + conn + " found ConnectionState" + cs);
            }
            ConnectionState<C> connectionState = cs;
            return connectionState;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-getConnectionState: " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized C get(ContactInfo<C> cinfo, ConnectionFinder<C> finder) throws IOException {
        if (this.debug()) {
            this.dprint("->get: " + cinfo);
        }
        ConnectionState<Object> cs = null;
        try {
            CacheEntry<C> entry = this.getEntry(cinfo);
            C result = null;
            if (this.numberOfConnections() >= (long)this.highWaterMark()) {
                this.reclaim();
            }
            if (finder != null) {
                if (this.debug()) {
                    this.dprint(".get: " + cinfo + " Calling the finder to get a connection");
                }
                if ((result = (C)finder.find(cinfo, entry.idleConnectionsView, entry.busyConnectionsView)) != null) {
                    cs = this.getConnectionState(cinfo, entry, result);
                    if (cs.csv == ConnectionStateValue.BUSY) {
                        entry.busyConnections.remove(result);
                    } else if (cs.csv == ConnectionStateValue.IDLE) {
                        entry.idleConnections.remove(result);
                    }
                }
            }
            if (result == null) {
                result = this.tryIdleConnections(entry);
            }
            if (result == null) {
                result = this.tryNewConnection(entry, cinfo);
            }
            if (result == null) {
                result = this.tryBusyConnections(entry);
            }
            if (cs == null) {
                cs = this.getConnectionState(cinfo, entry, result);
            }
            this.makeResultBusy(result, cs, entry);
            C c = result;
            return c;
        }
        finally {
            if (this.debug()) {
                this.dprint(".get " + cinfo + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
                this.dprint("<-get " + cinfo + " ConnectionState=" + cs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaimOrClose(ConnectionState<C> cs, C conn) {
        if (this.debug()) {
            this.dprint("->reclaimOrClose: " + conn);
        }
        try {
            boolean isOverflow;
            boolean bl = isOverflow = this.numberOfConnections() > (long)this.highWaterMark();
            if (isOverflow) {
                if (this.debug()) {
                    this.dprint(".reclaimOrClose: closing overflow connection " + conn);
                }
                this.close(conn);
            } else {
                if (this.debug()) {
                    this.dprint(".reclaimOrClose: queuing reclaimable connection " + conn);
                }
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
            boolean bl2 = isOverflow;
            return bl2;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-reclaimOrClose: " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(C conn, int numResponsesExpected) {
        if (this.debug()) {
            this.dprint("->release: " + conn + " expecting " + numResponsesExpected + " responses");
        }
        ConnectionState<C> cs = this.connectionMap.get(conn);
        try {
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".release: " + conn + " was closed");
                }
            } else {
                int numBusy;
                cs.expectedResponseCount += numResponsesExpected;
                int numResp = cs.expectedResponseCount;
                if ((numBusy = --cs.busyCount) < 0) {
                    if (this.debug()) {
                        this.dprint(".release: " + conn + " numBusy=" + numBusy + " is < 0: error");
                    }
                    cs.busyCount = 0;
                    return;
                }
                if (this.debug()) {
                    this.dprint(".release: " + numResp + " responses expected");
                    this.dprint(".release: " + numBusy + " busy count");
                }
                if (numBusy == 0) {
                    CacheEntry entry = cs.entry;
                    boolean wasOnBusy = entry.busyConnections.remove(conn);
                    if (!wasOnBusy && this.debug()) {
                        this.dprint(".release: " + conn + " was NOT on busy queue, but should have been");
                    }
                    boolean connectionClosed = false;
                    if (numResp == 0) {
                        connectionClosed = this.reclaimOrClose(cs, conn);
                    }
                    this.decrementTotalBusy();
                    if (!connectionClosed) {
                        if (this.debug()) {
                            this.dprint(".release: queuing idle connection " + conn);
                        }
                        ++this.totalIdle;
                        entry.idleConnections.offer(conn);
                        cs.csv = ConnectionStateValue.IDLE;
                    }
                }
            }
        }
        finally {
            if (this.debug()) {
                this.dprint(".release " + conn + " cs=" + cs + " totalIdle=" + this.totalIdle + " totalBusy=" + this.totalBusy);
                this.dprint("<-release" + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void responseReceived(C conn) {
        if (this.debug()) {
            this.dprint("->responseReceived: " + conn);
        }
        try {
            ConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".responseReceived: received response on closed connection " + conn);
                }
                return;
            }
            int waitCount = --cs.expectedResponseCount;
            if (this.debug()) {
                this.dprint(".responseReceived: " + conn + " waitCount=" + waitCount);
            }
            if (waitCount < 0) {
                if (this.debug()) {
                    this.dprint(".responseReceived: " + conn + " incorrect call: error");
                }
                cs.expectedResponseCount = 0;
                return;
            }
            if (waitCount == 0 && cs.busyCount == 0) {
                this.reclaimOrClose(cs, conn);
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-responseReceived: " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(C conn) {
        if (this.debug()) {
            this.dprint("->close: " + conn);
        }
        try {
            ConcurrentQueue.Handle rh;
            ConnectionState<C> cs = this.connectionMap.remove(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".close: " + conn + " was already closed");
                }
                return;
            }
            if (this.debug()) {
                this.dprint(".close: " + conn + "Connection state=" + cs);
            }
            if ((rh = cs.reclaimableHandle) != null) {
                boolean result = rh.remove();
                if (this.debug()) {
                    this.dprint(".close: " + conn + "reclaimableHandle .remove = " + result);
                }
            }
            if (cs.entry.busyConnections.remove(conn)) {
                if (this.debug()) {
                    this.dprint(".close: " + conn + " removed from busyConnections");
                }
                this.decrementTotalBusy();
            }
            if (cs.entry.idleConnections.remove(conn)) {
                if (this.debug()) {
                    this.dprint(".close: " + conn + " removed from idleConnections");
                }
                this.decrementTotalIdle();
            }
            conn.close();
        }
        finally {
            if (this.debug()) {
                this.dprintStatistics();
                this.dprint("<-close: " + conn);
            }
        }
    }

    private static final class CacheEntry<C extends Connection> {
        final Queue<C> idleConnections = new LinkedBlockingQueue<C>();
        final Collection<C> idleConnectionsView = Collections.unmodifiableCollection(this.idleConnections);
        final Queue<C> busyConnections = new LinkedBlockingQueue<C>();
        final Collection<C> busyConnectionsView = Collections.unmodifiableCollection(this.busyConnections);

        private CacheEntry() {
        }

        public int totalConnections() {
            return this.idleConnections.size() + this.busyConnections.size();
        }
    }

    private static final class ConnectionState<C extends Connection> {
        ConnectionStateValue csv = ConnectionStateValue.NEW;
        final ContactInfo<C> cinfo;
        final C connection;
        final CacheEntry<C> entry;
        int busyCount;
        int expectedResponseCount;
        ConcurrentQueue.Handle<C> reclaimableHandle;

        ConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
            this.cinfo = cinfo;
            this.connection = conn;
            this.entry = entry;
            this.busyCount = 0;
            this.expectedResponseCount = 0;
            this.reclaimableHandle = null;
        }

        public String toString() {
            return "ConnectionState[cinfo=" + this.cinfo + " connection=" + this.connection + " busyCount=" + this.busyCount + " expectedResponseCount=" + this.expectedResponseCount + "]";
        }
    }

    private static enum ConnectionStateValue {
        NEW,
        BUSY,
        IDLE;

    }
}

