/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.ha;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;

public class HaContext {
    private static final Logger LOGGER = Logger.getLogger(HaContext.class);
    private static final ThreadLocal<State> state = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return State.EMPTY;
        }
    };

    public static State initFrom(Packet packet) {
        State oldState = state.get();
        HaInfo haInfo = null;
        if (packet != null && packet.supports("com.sun.xml.ws.api.message.packet.hainfo")) {
            haInfo = (HaInfo)packet.get("com.sun.xml.ws.api.message.packet.hainfo");
        }
        State newState = new State(packet, haInfo);
        state.set(newState);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : Initialized from packet - replaced old " + oldState.toString() + " with a new " + newState.toString());
        }
        return oldState;
    }

    public static State initFrom(State newState) {
        State oldState = state.get();
        state.set(newState);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : Initialized from state - replaced old " + oldState.toString() + " with a new " + newState.toString());
        }
        return oldState;
    }

    public static State currentState() {
        return state.get();
    }

    public static void clear() {
        state.set(State.EMPTY);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : Current HA state cleared");
        }
    }

    public static HaInfo currentHaInfo() {
        return state.get().haInfo;
    }

    public static void udpateReplicaInstance(String replicaInstance) {
        boolean updateNeeded = false;
        State currentState = state.get();
        if (currentState.haInfo == null) {
            throw new IllegalStateException("Unable to update replicaInstance. Current HaInfo in the local thread is null.");
        }
        if (replicaInstance == null) {
            updateNeeded = currentState.haInfo.getReplicaInstance() != null;
        } else {
            boolean bl = updateNeeded = !replicaInstance.equals(currentState.haInfo.getReplicaInstance());
        }
        if (updateNeeded) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : Replica instance value changed to '" + replicaInstance + "'. Updating current HaInfo.");
            }
            HaInfo old = currentState.haInfo;
            HaContext.updateHaInfo(new HaInfo(old.getKey(), replicaInstance, old.isFailOver()));
        } else if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : New replica instance value '" + replicaInstance + "' same as current - no HaInfo update necessary");
        }
    }

    public static void updateHaInfo(HaInfo newValue) {
        Packet packet = state.get().packet;
        state.set(new State(packet, newValue));
        if (packet != null && packet.supports("com.sun.xml.ws.api.message.packet.hainfo")) {
            packet.put("com.sun.xml.ws.api.message.packet.hainfo", newValue);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("[METRO-HA] " + Thread.currentThread().toString() + " : HaInfo value updated: " + HaContext.asString(newValue));
        }
    }

    public static boolean failoverDetected() {
        HaInfo haInfo = state.get().haInfo;
        return haInfo != null && haInfo.isFailOver();
    }

    public static String asString(HaInfo haInfo) {
        if (haInfo == null) {
            return "null";
        }
        return "HaInfo{hashableKey=" + haInfo.getKey() + ", replicaInstance=" + haInfo.getReplicaInstance() + ", isFailover=" + haInfo.isFailOver() + "}";
    }

    public static final class State {
        private static final State EMPTY = new State(null, null);
        private final Packet packet;
        private final HaInfo haInfo;

        private State(Packet packet, HaInfo haInfo) {
            this.packet = packet;
            this.haInfo = haInfo;
        }

        public String toString() {
            return "HaState{packet=" + this.packet + ", haInfo=" + HaContext.asString(this.haInfo) + "}";
        }
    }
}

