/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ExtendedModelVisitor;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

public class ClassNameCollector
extends ExtendedModelVisitor
implements SOAPTypeVisitor,
LiteralTypeVisitor {
    private Set _allClassNames;
    private Set _exceptions;
    private Set _wsdlBindingNames;
    private Set _conflictingClassNames;
    private Set _visitedTypes;
    private Set _visitedFaults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Model model) {
        try {
            this._allClassNames = new HashSet();
            this._exceptions = new HashSet();
            this._wsdlBindingNames = new HashSet();
            this._conflictingClassNames = new HashSet();
            this._visitedTypes = new HashSet();
            this._visitedFaults = new HashSet();
            this.visit(model);
        }
        catch (Exception exception) {
        }
        finally {
            this._allClassNames = null;
            this._exceptions = null;
            this._visitedTypes = null;
            this._visitedFaults = null;
        }
    }

    public Set getConflictingClassNames() {
        return this._conflictingClassNames;
    }

    @Override
    protected void postVisit(Model model) throws Exception {
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            this.visitType((AbstractType)iter.next());
        }
    }

    @Override
    protected void preVisit(Service service) throws Exception {
        this.registerClassName(service.getJavaInterface().getName());
        this.registerClassName(service.getJavaInterface().getImpl());
    }

    @Override
    protected void preVisit(Port port) throws Exception {
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(wsdlBindingName)) {
            this.registerClassName(port.getJavaInterface().getName());
        }
        this.registerClassName((String)port.getProperty("com.sun.xml.rpc.processor.model.StubClassName"));
        this.registerClassName((String)port.getProperty("com.sun.xml.rpc.processor.model.TieClassName"));
    }

    @Override
    protected void postVisit(Port port) throws Exception {
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(wsdlBindingName)) {
            this._wsdlBindingNames.add(wsdlBindingName);
        }
    }

    @Override
    protected boolean shouldVisit(Port port) {
        QName wsdlBindingName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        return !this._wsdlBindingNames.contains(wsdlBindingName);
    }

    @Override
    protected void preVisit(Fault fault) throws Exception {
        if (!this._exceptions.contains(fault.getJavaException())) {
            this._exceptions.add(fault.getJavaException());
            this.registerClassName(fault.getJavaException().getName());
            if (fault.getParentFault() != null) {
                this.preVisit(fault.getParentFault());
            }
            Iterator iter = fault.getSubfaults();
            while (iter != null && iter.hasNext()) {
                Fault subfault = (Fault)iter.next();
                this.preVisit(subfault);
            }
        }
    }

    @Override
    protected void visitBodyBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitHeaderBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitFaultBlock(Block block) throws Exception {
        AbstractType type = block.getType();
        if (type instanceof SOAPStructureType) {
            Iterator iter = ((SOAPStructureType)type).getMembers();
            while (iter.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)iter.next();
                this.visitType(member.getType());
            }
        } else if (type instanceof SOAPArrayType) {
            this.visitType(((SOAPArrayType)type).getElementType());
        } else if (type instanceof LiteralStructuredType) {
            Iterator iter = ((LiteralStructuredType)type).getAttributeMembers();
            while (iter.hasNext()) {
                LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
                this.visitType(attribute.getType());
            }
            iter = ((LiteralStructuredType)type).getElementMembers();
            while (iter.hasNext()) {
                LiteralElementMember element = (LiteralElementMember)iter.next();
                this.visitType(element.getType());
            }
        } else if (type instanceof LiteralArrayType) {
            this.visitType(((LiteralArrayType)type).getElementType());
        } else if (type instanceof LiteralArrayWrapperType) {
            this.visitType(((LiteralArrayWrapperType)type).getElementMember().getType());
        }
    }

    protected void visitBlock(Block block) throws Exception {
        this.visitType(block.getType());
    }

    @Override
    protected void visit(Parameter parameter) throws Exception {
        this.visitType(parameter.getType());
    }

    private void visitType(AbstractType type) throws Exception {
        if (type != null) {
            if (type.isLiteralType()) {
                this.visitType((LiteralType)type);
            } else if (type.isSOAPType()) {
                this.visitType((SOAPType)type);
            }
        }
    }

    private void visitType(LiteralType type) throws Exception {
        type.accept(this);
    }

    @Override
    public void visit(LiteralSimpleType type) throws Exception {
    }

    @Override
    public void visit(LiteralSequenceType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    @Override
    public void visit(LiteralAllType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    private void visitLiteralStructuredType(LiteralStructuredType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            this.registerClassName(type.getJavaType().getName());
            Iterator iter = type.getAttributeMembers();
            while (iter.hasNext()) {
                LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
                this.visitType(attribute.getType());
            }
            iter = type.getElementMembers();
            while (iter.hasNext()) {
                LiteralElementMember element = (LiteralElementMember)iter.next();
                this.visitType(element.getType());
            }
        }
    }

    @Override
    public void visit(LiteralArrayType type) throws Exception {
        this.visitType(type.getElementType());
    }

    @Override
    public void visit(LiteralArrayWrapperType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            this.registerClassName(type.getJavaType().getName());
            this.visitType(type.getElementMember().getType());
        }
    }

    @Override
    public void visit(LiteralFragmentType type) throws Exception {
    }

    @Override
    public void visit(LiteralListType type) throws Exception {
    }

    @Override
    public void visit(SOAPListType type) throws Exception {
    }

    @Override
    public void visit(LiteralIDType type) throws Exception {
    }

    @Override
    public void visit(LiteralEnumerationType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            this.registerClassName(type.getJavaType().getName());
        }
    }

    private void visitType(SOAPType type) throws Exception {
        type.accept(this);
    }

    @Override
    public void visit(SOAPArrayType type) throws Exception {
        this.visitType(type.getElementType());
    }

    @Override
    public void visit(SOAPCustomType type) throws Exception {
    }

    @Override
    public void visit(SOAPEnumerationType type) throws Exception {
        this.visitType(type.getBaseType());
    }

    @Override
    public void visit(SOAPSimpleType type) throws Exception {
    }

    @Override
    public void visit(SOAPAnyType type) throws Exception {
    }

    @Override
    public void visit(SOAPOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    @Override
    public void visit(SOAPUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    @Override
    public void visit(RPCRequestOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    @Override
    public void visit(RPCRequestUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    @Override
    public void visit(RPCResponseStructureType type) throws Exception {
        this.visitSOAPStructureType(type);
    }

    private void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        boolean alreadySeen = this._visitedTypes.contains(type);
        if (!alreadySeen) {
            this._visitedTypes.add(type);
            if (this._exceptions.contains(type.getJavaType())) {
                return;
            }
            this.registerClassName(type.getJavaType().getName());
            Iterator iter = type.getMembers();
            while (iter.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)iter.next();
                this.visitType(member.getType());
            }
            iter = type.getSubtypes();
            while (iter != null && iter.hasNext()) {
                SOAPStructureType subType = (SOAPStructureType)iter.next();
                this.visitType(subType);
            }
        }
    }

    private void registerClassName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        if (this._allClassNames.contains(name)) {
            this._conflictingClassNames.add(name);
        } else {
            this._allClassNames.add(name);
        }
    }

    @Override
    public void visit(LiteralAttachmentType type) throws Exception {
    }
}

