/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.IOException;
import javax.naming.OperationNotSupportedException;

public class CustomSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerName;
    private String serializerMemberName;
    private String deserializerName;
    private String deserializerMemberName;
    private SOAPType dataType;

    public CustomSerializerWriter(SOAPType type, Names names) {
        super(type, names);
        this.dataType = type;
        this.serializerName = names.getTypeQName(type.getName()) + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(this.serializerName);
        this.deserializerName = names.getTypeQName(type.getName()) + "_Deserializer";
        this.deserializerMemberName = names.getClassMemberName(this.deserializerName);
    }

    @Override
    public void createSerializer(IndentingWriter p, StringBuffer typeName, String varName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(new OperationNotSupportedException()));
    }

    @Override
    public void registerSerializer(IndentingWriter p, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        TypeMappingInfo mappingInfo = ((JavaCustomType)this.type.getJavaType()).getTypeMappingInfo();
        if (this.soapVer.equals(SOAPVersion.SOAP_11) && !mappingInfo.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/") || this.soapVer.equals(SOAPVersion.SOAP_12) && !mappingInfo.getEncodingStyle().equals("http://www.w3.org/2002/06/soap-encoding")) {
            throw new GeneratorException("generator.unsupported.encoding.encountered", mappingInfo.getEncodingStyle().toString());
        }
        String serFac = mappingInfo.getSerializerFactoryName();
        String deserFac = mappingInfo.getDeserializerFactoryName();
        StringBuffer typeName = new StringBuffer("type");
        this.declareType(p, typeName, this.type.getName(), false, false);
        p.pln(typeMapping + ".register(" + this.type.getJavaType().getName() + ".class, " + typeName.toString() + ", " + "new " + serFac + "(), " + "new " + deserFac + "());");
    }

    @Override
    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln("private JAXRPCSerializer " + this.serializerMemberName() + ";");
        p.pln("private JAXRPCDeserializer " + this.deserializerMemberName() + ";");
    }

    @Override
    public void initializeSerializer(IndentingWriter p, String typeName, String registry) throws IOException {
        p.pln(this.serializerMemberName() + " = (JAXRPCSerializer)registry.getSerializer(" + this.getEncodingStyleString() + ", " + this.type.getJavaType().getName() + ".class, " + typeName + ");");
        p.pln(this.deserializerMemberName() + " = (JAXRPCDeserializer)registry.getDeserializer(" + this.getEncodingStyleString() + ", " + this.type.getJavaType().getName() + ".class, " + typeName + ");");
    }

    @Override
    public String serializerName() {
        return this.serializerName;
    }

    @Override
    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    @Override
    public String deserializerName() {
        return this.deserializerName;
    }

    @Override
    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.deserializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public AbstractType getElementType() {
        SOAPType elemType = ((SOAPArrayType)this.type).getElementType();
        while (elemType instanceof SOAPArrayType) {
            elemType = ((SOAPArrayType)elemType).getElementType();
        }
        return elemType;
    }
}

