/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig;

import com.sun.xml.security.core.dsig.SignatureType;
import com.sun.xml.ws.security.opt.crypto.dsig.Reference;
import com.sun.xml.ws.security.opt.crypto.dsig.SignatureMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.SignatureProcessor;
import com.sun.xml.ws.security.opt.crypto.dsig.SignatureValue;
import com.sun.xml.ws.security.opt.crypto.dsig.SignedInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.XMLObject;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jvnet.staxex.XMLStreamReaderEx;

@XmlRootElement(name="Signature", namespace="http://www.w3.org/2000/09/xmldsig#")
public class Signature
extends SignatureType
implements XMLSignature {
    @XmlTransient
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    @XmlTransient
    private XMLStreamReaderEx _streamSI = null;
    @XmlTransient
    private String type = null;
    @XmlTransient
    private List<XMLObject> objects = null;
    @XmlTransient
    private SignatureProcessor _sp;
    @XmlTransient
    private Key verificationKey = null;
    @XmlTransient
    private byte[] signedInfoBytes = null;

    public void setSignedInfo(XMLStreamReaderEx streamReader) {
        this._streamSI = streamReader;
    }

    public void setSignedInfo(byte[] si) {
        this.signedInfoBytes = si;
    }

    public void setVerificationKey(Key key) {
        this.verificationKey = key;
    }

    public Key getVerificationKey() {
        return this.verificationKey;
    }

    @Override
    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        SignedInfo si = this.getSignedInfo();
        List refList = si.getReferences();
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            Reference ref = (Reference)refList.get(i);
            byte[] originalDigest = ref.getDigestValue();
            ref.digest(xMLValidateContext);
            byte[] calculatedDigest = ref.getDigestValue();
            if (Arrays.equals(originalDigest, calculatedDigest)) continue;
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION("Signature digest values mismatch"));
            throw new XMLSignatureException(LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION("Signature digest values mismatch"));
        }
        si.setSignedInfo(this._streamSI);
        KeySelectorResult keySelectoResult = null;
        try {
            SignatureMethod sm = si.getSignatureMethod();
            if (this.verificationKey == null) {
                keySelectoResult = xMLValidateContext.getKeySelector().select(this.getKeyInfo(), KeySelector.Purpose.VERIFY, sm, xMLValidateContext);
                this.verificationKey = keySelectoResult.getKey();
            }
            if (this.verificationKey == null) {
                throw new XMLSignatureException("The KeySelector" + xMLValidateContext.getKeySelector() + " did not find the key used for signature verification");
            }
            if (this._sp == null) {
                this._sp = new SignatureProcessor();
            }
            try {
                String signatureAlgo = sm.getAlgorithm();
                String algo = this.getRSASignatureAlgorithm(signatureAlgo);
                if (algo != null) {
                    return this._sp.verifyRSASignature(this.verificationKey, si, this.getSignatureValue().getValue(), algo);
                }
                if (signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return this._sp.verifyDSASignature(this.verificationKey, si, this.getSignatureValue().getValue());
                }
                if (signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    SignatureMethodParameterSpec params = (SignatureMethodParameterSpec)sm.getParameterSpec();
                    int outputLength = -1;
                    if (params != null) {
                        if (!(params instanceof HMACParameterSpec)) {
                            throw new XMLSignatureException("SignatureMethodParameterSpec must be of type HMACParameterSpec");
                        }
                        outputLength = ((HMACParameterSpec)params).getOutputLength();
                    }
                    return this._sp.verifyHMACSignature(this.verificationKey, si, this.getSignatureValue().getValue(), outputLength);
                }
                throw new XMLSignatureException("Unsupported signature algorithm found");
            }
            catch (InvalidKeyException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION(ex));
                throw new XMLSignatureException(LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION(ex));
            }
            catch (SignatureException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION("Signature digest values mismatch"));
                throw new XMLSignatureException(LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION(ex));
            }
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException("Cannot find verification key", kse);
        }
    }

    @Override
    public List getObjects() {
        return null;
    }

    @Override
    public void sign(XMLSignContext xMLSignContext) throws MarshalException, XMLSignatureException {
        String signatureAlgo;
        String algo;
        SignatureMethod sm;
        if (xMLSignContext == null) {
            throw new NullPointerException("signContext cannot be null");
        }
        SignedInfo si = this.getSignedInfo();
        List refList = si.getReferences();
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            Reference ref = (Reference)refList.get(i);
            ref.digest(xMLSignContext);
        }
        Key signingKey = null;
        KeySelectorResult keySelectoResult = null;
        try {
            sm = si.getSignatureMethod();
            keySelectoResult = xMLSignContext.getKeySelector().select(this.getKeyInfo(), KeySelector.Purpose.SIGN, sm, xMLSignContext);
            signingKey = keySelectoResult.getKey();
            if (signingKey == null) {
                throw new XMLSignatureException("The KeySelector" + xMLSignContext.getKeySelector() + " did not find the key used for signing");
            }
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException("Cannot find signing key", kse);
        }
        if (this._sp == null) {
            try {
                JAXBContext jc = JAXBUtil.getJAXBContext();
                this._sp = new SignatureProcessor();
                this._sp.setJAXBContext(jc);
                this._sp.setCryptoContext(xMLSignContext);
            }
            catch (Exception ex) {
                throw new XMLSignatureException(ex);
            }
        }
        if ((algo = this.getRSASignatureAlgorithm(signatureAlgo = sm.getAlgorithm())) != null) {
            try {
                SignatureValue sigValue = new SignatureValue();
                sigValue.setValue(this._sp.performRSASign(signingKey, this.signedInfo, algo));
                this.setSignatureValue(sigValue);
            }
            catch (InvalidKeyException ex) {
                throw new XMLSignatureException(ex);
            }
        } else if (signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            try {
                SignatureValue sigValue = new SignatureValue();
                sigValue.setValue(this._sp.performDSASign(signingKey, this.signedInfo));
                this.setSignatureValue(sigValue);
            }
            catch (InvalidKeyException ex) {
                throw new XMLSignatureException(ex);
            }
        } else if (signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            SignatureMethodParameterSpec params = (SignatureMethodParameterSpec)sm.getParameterSpec();
            int outputLength = -1;
            if (params != null) {
                if (!(params instanceof HMACParameterSpec)) {
                    throw new XMLSignatureException("SignatureMethodParameterSpec must be of type HMACParameterSpec");
                }
                outputLength = ((HMACParameterSpec)params).getOutputLength();
            }
            try {
                SignatureValue sigValue = new SignatureValue();
                sigValue.setValue(this._sp.performHMACSign(signingKey, this.signedInfo, outputLength));
                this.setSignatureValue(sigValue);
            }
            catch (InvalidKeyException ex) {
                throw new XMLSignatureException(ex);
            }
        } else {
            throw new XMLSignatureException("Unsupported signature algorithm found");
        }
    }

    @Override
    public KeySelectorResult getKeySelectorResult() {
        return null;
    }

    @Override
    public boolean isFeatureSupported(String string2) {
        return false;
    }

    @Override
    public XMLSignature.SignatureValue getSignatureValue() {
        return this.signatureValue;
    }

    @Override
    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    @Override
    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setObjects(List<XMLObject> objects) {
        this.objects = objects;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private String getRSASignatureAlgorithm(String signatureAlgo) {
        if (signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return "SHA1withRSA";
        }
        if (signatureAlgo.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")) {
            return "SHA256withRSA";
        }
        if (signatureAlgo.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384")) {
            return "SHA384withRSA";
        }
        if (signatureAlgo.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512")) {
            return "SHA512withRSA";
        }
        return null;
    }
}

