/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.Wsrm200502ProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.Wsrm200702ProtocolHandler;
import com.sun.xml.ws.rx.util.Communicator;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;

public abstract class WsrmProtocolHandler {
    private static final Logger LOGGER = Logger.getLogger(WsrmProtocolHandler.class);
    protected final RmRuntimeVersion rmVersion;
    protected final Communicator communicator;
    protected final AddressingVersion addressingVersion;
    protected final SOAPVersion soapVersion;

    public static WsrmProtocolHandler getInstance(RmConfiguration configuration, Communicator communicator, RuntimeContext rc) {
        switch (configuration.getRuntimeVersion()) {
            case WSRM200502: {
                return new Wsrm200502ProtocolHandler(configuration, rc, communicator);
            }
            case WSRM200702: {
                return new Wsrm200702ProtocolHandler(configuration, rc, communicator);
            }
        }
        return null;
    }

    public abstract void appendSequenceHeader(@NotNull Message var1, @NotNull ApplicationMessage var2) throws RxRuntimeException;

    public abstract void appendAcknowledgementHeaders(@NotNull Packet var1, @NotNull AcknowledgementData var2) throws RxRuntimeException;

    public abstract AcknowledgementData getAcknowledgementData(Message var1) throws RxRuntimeException;

    public abstract void loadAcknowledgementData(@NotNull ApplicationMessage var1, @NotNull Message var2) throws RxRuntimeException;

    public abstract void loadSequenceHeaderData(@NotNull ApplicationMessage var1, @NotNull Message var2) throws RxRuntimeException;

    public abstract CreateSequenceData toCreateSequenceData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull CreateSequenceData var1, @Nullable Packet var2) throws RxRuntimeException;

    public abstract CreateSequenceResponseData toCreateSequenceResponseData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull CreateSequenceResponseData var1, @NotNull Packet var2, boolean var3) throws RxRuntimeException;

    public abstract CloseSequenceData toCloseSequenceData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull CloseSequenceData var1, @Nullable Packet var2) throws RxRuntimeException;

    public abstract CloseSequenceResponseData toCloseSequenceResponseData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull CloseSequenceResponseData var1, @NotNull Packet var2, boolean var3) throws RxRuntimeException;

    public abstract TerminateSequenceData toTerminateSequenceData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull TerminateSequenceData var1, @Nullable Packet var2) throws RxRuntimeException;

    public abstract TerminateSequenceResponseData toTerminateSequenceResponseData(@NotNull Packet var1) throws RxRuntimeException;

    public abstract Packet toPacket(@NotNull TerminateSequenceResponseData var1, @NotNull Packet var2, boolean var3) throws RxRuntimeException;

    public abstract Header createSequenceFaultElementHeader(QName var1, Detail var2);

    public abstract Packet createEmptyAcknowledgementResponse(AcknowledgementData var1, Packet var2) throws RxRuntimeException;

    public final boolean containsProtocolMessage(@NotNull Packet packet) {
        assert (packet != null);
        return packet.getMessage() == null ? false : this.rmVersion.protocolVersion.isProtocolAction(this.getWsaAction(packet.getMessage()));
    }

    public final boolean containsProtocolRequest(@NotNull Packet packet) {
        assert (packet != null);
        return packet.getMessage() == null ? false : this.rmVersion.protocolVersion.isProtocolRequest(this.getWsaAction(packet.getMessage()));
    }

    public final boolean containsProtocolResponse(@NotNull Packet packet) {
        assert (packet != null);
        return packet.getMessage() == null ? false : this.rmVersion.protocolVersion.isProtocolResponse(this.getWsaAction(packet.getMessage()));
    }

    protected WsrmProtocolHandler(@NotNull RmRuntimeVersion rmVersion, @NotNull RmConfiguration configuration, @NotNull Communicator communicator) {
        assert (rmVersion != null);
        assert (rmVersion == configuration.getRuntimeVersion());
        assert (configuration != null);
        assert (communicator != null);
        this.rmVersion = rmVersion;
        this.communicator = communicator;
        this.addressingVersion = configuration.getAddressingVersion();
        this.soapVersion = configuration.getSoapVersion();
    }

    protected final Header createHeader(Object jaxbHeaderContent) {
        return Headers.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbHeaderContent);
    }

    protected final <T> T readHeaderAsUnderstood(@NotNull String nsUri, @NotNull String name, @NotNull Message message) throws RxRuntimeException {
        assert (nsUri != null);
        assert (name != null);
        assert (message != null);
        Header header = message.getHeaders().get(nsUri, name, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.getJaxbUnmarshaller());
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1122_ERROR_MARSHALLING_RM_HEADER(nsUri + "#" + name), ex));
        }
    }

    protected final String getWsaAction(@NotNull Message message) {
        return message.getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    protected final JAXBRIContext getJaxbContext() {
        return this.rmVersion.getJaxbContext(this.addressingVersion);
    }

    protected final Unmarshaller getJaxbUnmarshaller() throws RxRuntimeException {
        return this.rmVersion.createUnmarshaller(this.addressingVersion);
    }

    protected final <T> T unmarshallMessage(@NotNull Message message) throws RxRuntimeException {
        assert (message != null);
        try {
            Object result = message.readPayloadAsJAXB(this.getJaxbUnmarshaller());
            return result;
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1123_ERROR_UNMARSHALLING_MESSAGE(), e));
        }
    }
}

