/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.ConnectionManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

final class PersistentSequenceData
implements SequenceData {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceData.class);
    private final String endpointUid;
    private final String sequenceId;
    private final SequenceType type;
    private final String boundSecurityTokenReferenceId;
    private final String boundSequenceId;
    private final long expirationTime;
    private final FieldInfo<Integer> fState = new FieldInfo<Integer>("STATUS", 5, Integer.class);
    private final FieldInfo<String> fAckRequestedFlag = new FieldInfo<String>("ACK_REQUESTED_FLAG", 1, String.class);
    private final FieldInfo<Long> fLastMessageNumber = new FieldInfo<Long>("LAST_MESSAGE_NUMBER", -5, Long.class);
    private final FieldInfo<Long> fLastActivityTime = new FieldInfo<Long>("LAST_ACTIVITY_TIME", -5, Long.class);
    private final FieldInfo<Long> fLastAcknowledgementRequestTime = new FieldInfo<Long>("LAST_ACK_REQUEST_TIME", -5, Long.class);
    private final ConnectionManager cm;
    private final TimeSynchronizer ts;

    private static String b2s(boolean value) {
        return value ? "T" : "F";
    }

    private static boolean s2b(String string2) {
        return "T".equals(string2);
    }

    private PersistentSequenceData(TimeSynchronizer ts, ConnectionManager cm, String endpointUid, String sequenceId, SequenceType type, String securityContextTokenId, String boundId, long expirationTime) {
        this.ts = ts;
        this.cm = cm;
        this.endpointUid = endpointUid;
        this.sequenceId = sequenceId;
        this.type = type;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.boundSequenceId = boundId;
        this.expirationTime = expirationTime;
    }

    static PersistentSequenceData newInstance(TimeSynchronizer ts, ConnectionManager cm, String enpointUid, String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) throws DuplicateSequenceException {
        PersistentSequenceData persistentSequenceData;
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "INSERT INTO RM_SEQUENCES (ENDPOINT_UID, ID, TYPE, EXP_TIME, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_NUMBER, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int i = 0;
            ps.setString(++i, enpointUid);
            ps.setString(++i, sequenceId);
            ps.setString(++i, type.id);
            ps.setLong(++i, expirationTime);
            ps.setString(++i, securityContextTokenId);
            ps.setInt(++i, state.asInt());
            ps.setString(++i, PersistentSequenceData.b2s(ackRequestedFlag));
            ps.setLong(++i, lastMessageId);
            ps.setLong(++i, lastActivityTime);
            ps.setLong(++i, lastAcknowledgementRequestTime);
            if (ps.executeUpdate() != 1) {
                cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Inserting sequence data for %s sequence with id = [ %s ] failed: Expected inserted rows: 1, Actual: %d", new Object[]{type, sequenceId})));
            }
            PersistentSequenceData data = PersistentSequenceData.loadInstance(con, ts, cm, enpointUid, sequenceId);
            cm.commit(con);
            persistentSequenceData = data;
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Inserting sequence data for %s sequence with id = [ %s ] failed: An unexpected JDBC exception occured", new Object[]{type, sequenceId}), ex));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
        return persistentSequenceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PersistentSequenceData loadInstance(TimeSynchronizer ts, ConnectionManager cm, String endpointUid, String sequenceId) {
        Connection con = cm.getConnection(true);
        try {
            PersistentSequenceData persistentSequenceData = PersistentSequenceData.loadInstance(con, ts, cm, endpointUid, sequenceId);
            return persistentSequenceData;
        }
        finally {
            cm.recycle(con);
        }
    }

    private static PersistentSequenceData loadInstance(Connection connection, TimeSynchronizer ts, ConnectionManager cm, String endpointUid, String sequenceId) {
        PersistentSequenceData persistentSequenceData;
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            ps = null;
            ps = cm.prepareStatement(connection, "SELECT TYPE, EXP_TIME, BOUND_ID, STR_ID FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            PersistentSequenceData persistentSequenceData2 = null;
            cm.recycle(ps);
            return persistentSequenceData2;
        }
        try {
            if (!rs.isFirst() && !rs.isLast()) {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Duplicate sequence records detected for a sequence with id [ %s ]", sequenceId)));
            }
            persistentSequenceData = new PersistentSequenceData(ts, cm, endpointUid, sequenceId, SequenceType.fromId(rs.getString("TYPE")), rs.getString("STR_ID"), rs.getString("BOUND_ID"), rs.getLong("EXP_TIME"));
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Loading sequence data for a sequence with id = [ %s ] failed: An unexpected JDBC exception occured", sequenceId), ex));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                throw throwable;
            }
        }
        cm.recycle(ps);
        return persistentSequenceData;
    }

    static void remove(ConnectionManager cm, String endpointUid, String sequenceId) {
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "DELETE FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("%d unacknowledged message records removed for a sequence with id [ %s ]", rowsAffected, sequenceId));
            }
            cm.recycle(ps);
            ps = cm.prepareStatement(con, "DELETE FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                cm.rollback(con);
                throw LOGGER.logException(new PersistenceException(String.format("Removing sequence with id = [ %s ] failed: Expected deleted rows: 1, Actual: %d", sequenceId, rowsAffected)), Level.WARNING);
            }
            cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Removing sequence with id = [ %s ] failed: An unexpected JDBC exception occured", sequenceId), ex));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
    }

    static void bind(ConnectionManager cm, String endpointUid, String referenceSequenceId, String boundSequenceId) {
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "UPDATE RM_SEQUENCES SET BOUND_ID=? WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, boundSequenceId);
            ps.setString(2, endpointUid);
            ps.setString(3, referenceSequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                cm.rollback(con);
                throw LOGGER.logException(new PersistenceException(String.format("Binding a sequence with id = [ %s ] to a sequence with id [ %s ] failed: Expected updated rows: 1, Actual: %d", boundSequenceId, referenceSequenceId, rowsAffected)), Level.WARNING);
            }
            cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Binding a sequence with id = [ %s ] to a sequence with id [ %s ] failed: An unexpected JDBC exception occured", boundSequenceId, referenceSequenceId), ex));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    public SequenceType getType() {
        return this.type;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    public String getBoundSequenceId() {
        return this.boundSequenceId;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public boolean isFailedOver(long messageNumber) {
        return false;
    }

    private <T> T getFieldData(Connection con, FieldInfo<T> fi) throws PersistenceException {
        Object t;
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT " + fi.columnName + " " + "FROM RM_SEQUENCES " + "WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Sequence record not found for a sequence with id [ %s ]", this.sequenceId)));
            }
            if (!rs.isFirst() && !rs.isLast()) {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Duplicate sequence records detected for a sequence with id [ %s ]", this.sequenceId)));
            }
            t = fi.javaClass.cast(rs.getObject(fi.columnName));
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Loading %s column data on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", fi.columnName, this.sequenceId), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getFieldData(FieldInfo<T> fi) {
        Connection con = this.cm.getConnection(true);
        try {
            T t = this.getFieldData(con, fi);
            return t;
        }
        finally {
            this.cm.recycle(con);
        }
    }

    private <T> void setFieldData(Connection con, FieldInfo<T> fi, T value, boolean updateLastActivityTime) {
        PreparedStatement ps = null;
        try {
            String lastActivityTimeUpdateString = "";
            if (updateLastActivityTime) {
                lastActivityTimeUpdateString = ", " + this.fLastActivityTime.columnName + "=? ";
            }
            ps = this.cm.prepareStatement(con, "UPDATE RM_SEQUENCES SET " + fi.columnName + "=?" + lastActivityTimeUpdateString + " " + "WHERE ENDPOINT_UID=? AND ID=?");
            int i = 0;
            ps.setObject(++i, value, fi.sqlType);
            if (updateLastActivityTime) {
                ps.setLong(++i, this.ts.currentTimeInMillis());
            }
            ps.setString(++i, this.endpointUid);
            ps.setString(++i, this.sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw LOGGER.logException(new PersistenceException(String.format("Updating %s column data on a sequence with id = [ %s ]  failed: Expected updated rows: 1, Actual: %d", fi.columnName, this.sequenceId, rowsAffected)), Level.WARNING);
            }
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Updating %s column data on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", fi.columnName, this.sequenceId), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setFieldData(FieldInfo<T> fi, T value, boolean updateLastActivityTime) {
        Connection con = this.cm.getConnection(false);
        boolean commit = false;
        try {
            this.setFieldData(con, fi, value, updateLastActivityTime);
            commit = true;
        }
        finally {
            if (commit) {
                this.cm.commit(con);
            }
            this.cm.recycle(con);
        }
    }

    @Override
    public long getLastMessageNumber() {
        return this.getFieldData(this.fLastMessageNumber);
    }

    @Override
    public Sequence.State getState() {
        return Sequence.State.asState(this.getFieldData(this.fState));
    }

    @Override
    public void setState(Sequence.State newValue) {
        this.setFieldData(this.fState, newValue.asInt(), true);
    }

    @Override
    public boolean getAckRequestedFlag() {
        return PersistentSequenceData.s2b(this.getFieldData(this.fAckRequestedFlag));
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        this.setFieldData(this.fAckRequestedFlag, PersistentSequenceData.b2s(newValue), true);
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        return this.getFieldData(this.fLastAcknowledgementRequestTime);
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newValue) {
        this.setFieldData(this.fLastAcknowledgementRequestTime, newValue, true);
    }

    @Override
    public long getLastActivityTime() {
        return this.getFieldData(this.fLastActivityTime);
    }

    @Override
    public long incrementAndGetLastMessageNumber(boolean received) {
        long l;
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "UPDATE RM_SEQUENCES SET LAST_MESSAGE_NUMBER=LAST_MESSAGE_NUMBER+1, " + this.fLastActivityTime.columnName + "=? " + "WHERE ENDPOINT_UID=? AND ID=?");
            ps.setLong(1, this.ts.currentTimeInMillis());
            ps.setString(2, this.endpointUid);
            ps.setString(3, this.sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                this.cm.rollback(con);
                throw LOGGER.logException(new PersistenceException(String.format("Incrementing last message number on a sequence with id = [ %s ] failed: Expected updated rows: 1, Actual: %d", this.sequenceId, rowsAffected)), Level.WARNING);
            }
            long newLastMessageId = this.getFieldData(con, this.fLastMessageNumber);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("New last message id: " + newLastMessageId);
            }
            try {
                this.registerSingleUnackedMessageNumber(con, newLastMessageId, received);
            }
            catch (DuplicateMessageRegistrationException ex) {
                this.cm.rollback(con);
                throw new PersistenceException("Registering newly created last message id ", ex);
            }
            catch (PersistenceException ex) {
                this.cm.rollback(con);
                throw ex;
            }
            this.cm.commit(con);
            l = newLastMessageId;
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Incrementing last message number on a sequence with id = [ %s ] failed: An unexpected JDBC exception occured", this.sequenceId), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return l;
    }

    private boolean containsUnackedMessageNumberRegistration(Connection con, long messageNumber) throws PersistenceException {
        boolean bl;
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT IS_RECEIVED FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(3, messageNumber);
            ResultSet rs = ps.executeQuery();
            bl = rs.next();
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Retrieving an unacked message number record for a message number [ %d ] on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", messageNumber, this.sequenceId), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        return bl;
    }

    private void registerSingleUnackedMessageNumber(Connection con, long messageNumber, boolean received) throws PersistenceException, DuplicateMessageRegistrationException {
        PreparedStatement ps = null;
        try {
            int rowsAffected;
            boolean doInsert;
            ps = this.cm.prepareStatement(con, "SELECT IS_RECEIVED FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(3, messageNumber);
            ResultSet rs = ps.executeQuery();
            boolean bl = doInsert = !rs.next();
            if (!doInsert && PersistentSequenceData.s2b(rs.getString("IS_RECEIVED")) == received) {
                throw new DuplicateMessageRegistrationException(this.sequenceId, messageNumber);
            }
            this.cm.recycle(ps);
            if (doInsert) {
                ps = this.cm.prepareStatement(con, "INSERT INTO RM_UNACKED_MESSAGES (ENDPOINT_UID, SEQ_ID, MSG_NUMBER, IS_RECEIVED) VALUES (?, ?, ?, ?)");
                ps.setString(1, this.endpointUid);
                ps.setString(2, this.sequenceId);
                ps.setLong(3, messageNumber);
                ps.setString(4, PersistentSequenceData.b2s(received));
                rowsAffected = ps.executeUpdate();
                if (rowsAffected != 1) {
                    throw LOGGER.logSevereException(new PersistenceException(String.format("Inserting new unacked message number record for a message number [ %d ] on a sequence with id = [ %s ]  failed: Expected updated rows: 1, Actual: %d", messageNumber, this.sequenceId, rowsAffected)));
                }
            } else {
                ps = this.cm.prepareStatement(con, "UPDATE RM_UNACKED_MESSAGES SET IS_RECEIVED=? WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=? AND IS_RECEIVED=?");
                ps.setString(1, PersistentSequenceData.b2s(received));
                ps.setString(2, this.endpointUid);
                ps.setString(3, this.sequenceId);
                ps.setLong(4, messageNumber);
                ps.setString(5, PersistentSequenceData.b2s(!received));
                rowsAffected = ps.executeUpdate();
            }
            if (rowsAffected != 1) {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Registering an unacked message number record for a message number [ %d ] on a sequence with id = [ %s ]  failed: Expected affected rows: 1, Actual: %d", messageNumber, this.sequenceId, rowsAffected)));
            }
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Registering an unacked message number record for a message number [ %d ] on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", messageNumber, this.sequenceId), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
    }

    @Override
    public void registerReceivedUnackedMessageNumber(long messageNumber) throws DuplicateMessageRegistrationException {
        Connection con = this.cm.getConnection(false);
        try {
            long lastMessageNumber = this.getFieldData(con, this.fLastMessageNumber);
            if (lastMessageNumber < messageNumber) {
                this.setFieldData(con, this.fLastMessageNumber, messageNumber, false);
                for (long i = lastMessageNumber + 1L; i < messageNumber; ++i) {
                    this.registerSingleUnackedMessageNumber(con, i, false);
                }
            } else if (!this.containsUnackedMessageNumberRegistration(con, messageNumber)) {
                throw new DuplicateMessageRegistrationException(this.sequenceId, messageNumber);
            }
            this.registerSingleUnackedMessageNumber(con, messageNumber, true);
            this.setFieldData(con, this.fLastActivityTime, this.ts.currentTimeInMillis(), false);
            this.cm.commit(con);
        }
        catch (PersistenceException ex) {
            this.cm.rollback(con);
            throw ex;
        }
        catch (DuplicateMessageRegistrationException ex) {
            this.cm.rollback(con);
            throw ex;
        }
        finally {
            this.cm.recycle(con);
        }
    }

    @Override
    public void markAsAcknowledged(long messageNumber) {
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "DELETE FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(3, messageNumber);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                if (rowsAffected == 0) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(String.format("No unacknowledged message record found for %s sequence with id = [ %s ] and message number [ %d ]: Message was probably already acknowledged earlier", new Object[]{this.type, this.sequenceId, messageNumber}));
                    }
                } else {
                    throw LOGGER.logSevereException(new PersistenceException(String.format("Message acknowledgement failed for %s sequence with id = [ %s ] and message number [ %d ]: Expected deleted rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, messageNumber, rowsAffected})));
                }
            }
            this.setFieldData(con, this.fLastActivityTime, this.ts.currentTimeInMillis(), false);
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Message acknowledgement failed for %s sequence with id = [ %s ] and message number [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, messageNumber}), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }

    @Override
    public List<Long> getUnackedMessageNumbers() {
        LinkedList<Long> linkedList;
        Connection con = this.cm.getConnection(true);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT MSG_NUMBER FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            LinkedList<Long> result = new LinkedList<Long>();
            while (rs.next()) {
                result.add(rs.getLong("MSG_NUMBER"));
            }
            linkedList = result;
        }
        catch (SQLException ex) {
            try {
                throw LOGGER.logSevereException(new PersistenceException(String.format("Unable to load list of unacked message registration for %s sequence with id = [ %s ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId}), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return linkedList;
    }

    @Override
    public List<Long> getLastMessageNumberWithUnackedMessageNumbers() {
        LinkedList<Long> linkedList;
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT RM_SEQUENCES.LAST_MESSAGE_NUMBER AS LAST_NUMBER, RM_UNACKED_MESSAGES.MSG_NUMBER AS MESSAGE_NUMBER FROM RM_UNACKED_MESSAGES INNER JOIN RM_SEQUENCES ON RM_UNACKED_MESSAGES.ENDPOINT_UID=RM_SEQUENCES.ENDPOINT_UID AND RM_UNACKED_MESSAGES.SEQ_ID=RM_SEQUENCES.ID WHERE RM_UNACKED_MESSAGES.ENDPOINT_UID=? AND SEQ_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            LinkedList<Long> result = new LinkedList<Long>();
            if (rs.next()) {
                result.add(rs.getLong("LAST_NUMBER"));
                result.add(rs.getLong("MESSAGE_NUMBER"));
            } else {
                result.add(this.getFieldData(con, this.fLastMessageNumber));
            }
            while (rs.next()) {
                result.add(rs.getLong("MESSAGE_NUMBER"));
            }
            this.cm.commit(con);
            linkedList = result;
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Unable to load list of unacked message registration for %s sequence with id = [ %s ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId}), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return linkedList;
    }

    @Override
    public void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        ByteArrayInputStream bais = null;
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "UPDATE RM_UNACKED_MESSAGES SET IS_RECEIVED=?, CORRELATION_ID=?, NEXT_RESEND_COUNT=?, WSA_ACTION=?, MSG_DATA=? WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            int i = 0;
            ps.setString(++i, PersistentSequenceData.b2s(true));
            ps.setString(++i, message.getCorrelationId());
            ps.setLong(++i, message.getNextResendCount());
            ps.setString(++i, ((JaxwsApplicationMessage)message).getWsaAction());
            byte[] msgData = message.toBytes();
            bais = new ByteArrayInputStream(msgData);
            ps.setBinaryStream(++i, (InputStream)bais, msgData.length);
            ps.setString(++i, this.endpointUid);
            ps.setString(++i, this.sequenceId);
            ps.setLong(++i, message.getMessageNumber());
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Storing message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ] has failed: Expected updated rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, message.getMessageNumber(), rowsAffected})));
            }
            this.setFieldData(con, this.fLastActivityTime, this.ts.currentTimeInMillis(), false);
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Unable to store message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, message.getMessageNumber()}), ex));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException ex2) {
                        LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", ex2);
                    }
                }
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", ex);
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        JaxwsApplicationMessage jaxwsApplicationMessage;
        InputStream messageDataStream;
        PreparedStatement ps;
        Connection con;
        block15: {
            ResultSet rs;
            block13: {
                ApplicationMessage applicationMessage;
                block14: {
                    con = this.cm.getConnection(false);
                    ps = null;
                    messageDataStream = null;
                    ps = this.cm.prepareStatement(con, "SELECT MSG_NUMBER, NEXT_RESEND_COUNT, WSA_ACTION, MSG_DATA FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND CORRELATION_ID=?");
                    ps.setString(1, this.endpointUid);
                    ps.setString(2, this.sequenceId);
                    ps.setString(3, correlationId);
                    rs = ps.executeQuery();
                    if (rs.next()) break block13;
                    applicationMessage = null;
                    if (messageDataStream == null) break block14;
                    try {
                        messageDataStream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.cm.recycle(ps);
                this.cm.recycle(con);
                return applicationMessage;
            }
            if (!rs.isFirst() && !rs.isLast()) {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Duplicate records detected for unacked message registration on %s sequence with id = [ %s ] and correlation id [ %d ]", new Object[]{this.type, this.sequenceId, correlationId})));
            }
            messageDataStream = rs.getBlob("MSG_DATA").getBinaryStream();
            JaxwsApplicationMessage message = JaxwsApplicationMessage.newInstance(messageDataStream, rs.getInt("NEXT_RESEND_COUNT"), correlationId, rs.getString("WSA_ACTION"), this.sequenceId, rs.getLong("MSG_NUMBER"));
            this.setFieldData(con, this.fLastActivityTime, this.ts.currentTimeInMillis(), false);
            this.cm.commit(con);
            jaxwsApplicationMessage = message;
            if (messageDataStream == null) break block15;
            try {
                messageDataStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return jaxwsApplicationMessage;
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw LOGGER.logSevereException(new PersistenceException(String.format("Unable to load message data from an unacked message registration for %s sequence with id = [ %s ] and correlation id [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, correlationId}), ex));
            }
            catch (Throwable throwable) {
                if (messageDataStream != null) {
                    try {
                        messageDataStream.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
    }

    static enum SequenceType {
        Inbound("I"),
        Outbound("O");

        private final String id;

        private SequenceType(String id) {
            this.id = id;
        }

        private static SequenceType fromId(String id) {
            for (SequenceType type : SequenceType.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return null;
        }
    }

    private static final class FieldInfo<T> {
        final String columnName;
        final int sqlType;
        final Class<T> javaClass;

        public FieldInfo(String columnName, int sqlType, Class<T> javaClass) {
            this.columnName = columnName;
            this.sqlType = sqlType;
            this.javaClass = javaClass;
        }
    }
}

