/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRM;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import com.sun.xml.ws.tx.at.tube.WSATClient;
import com.sun.xml.ws.tx.coord.common.WSATCoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.WSCBuilderFactory;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientHelper
implements WSATClient {
    private volatile int counter = 0;
    private static final Logger LOGGER = Logger.getLogger(WSATClientHelper.class);

    @Override
    public List<Header> doHandleRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        try {
            if (TransactionManagerImpl.getInstance().getTransactionManager().getTransaction() == null) {
                return new ArrayList<Header>();
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
            return new ArrayList<Header>();
        }
        List<Header> addedHeaders = this.processTransactionalRequest(transactionalAttribute, map);
        return addedHeaders;
    }

    @Override
    public boolean doHandleResponse(Map<String, Object> map) {
        return this.resumeAndClearXidTxMap(map);
    }

    @Override
    public void doHandleException(Map<String, Object> map) {
        LOGGER.info(LocalizationMessages.WSAT_4569_INBOUND_APPLICATION_MESSAGE());
        this.resumeAndClearXidTxMap(map);
    }

    private boolean resumeAndClearXidTxMap(Map<String, Object> map) {
        Transaction transaction;
        Xid xid;
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4569_INBOUND_APPLICATION_MESSAGE());
        }
        if ((xid = this.getWSATXidFromMap(map)) != null) {
            WSATHelper.getInstance().removeFromXidToTransactionMap(xid);
        }
        return (transaction = this.getWSATTransactionFromMap(map)) == null || this.resume(transaction);
    }

    private Transaction getWSATTransactionFromMap(Map map) {
        Transaction transaction = (Transaction)map.get("wsat.transaction");
        return transaction;
    }

    private Xid getWSATXidFromMap(Map map) {
        Xid xid = (Xid)map.get("wsat.transaction.xid");
        return xid;
    }

    private boolean resume(Transaction transaction) {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4570_WILL_RESUME_IN_CLIENT_SIDE_HANDLER(transaction, Thread.currentThread()));
        }
        try {
            TransactionManagerImpl.getInstance().getTransactionManager().resume(transaction);
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4571_RESUMED_IN_CLIENT_SIDE_HANDLER(transaction, Thread.currentThread()));
            }
            return true;
        }
        catch (InvalidTransactionException e) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.severe(LocalizationMessages.WSAT_4572_INVALID_TRANSACTION_EXCEPTION_IN_CLIENT_SIDE_HANDLER(transaction, Thread.currentThread()), e);
            }
            try {
                transaction.setRollbackOnly();
            }
            catch (IllegalStateException ex) {
                Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (SystemException ex) {
                Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, ex);
                return false;
            }
            return false;
        }
        catch (SystemException e) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.severe(LocalizationMessages.WSAT_4573_SYSTEM_EXCEPTION_IN_CLIENT_SIDE_HANDLER(transaction, Thread.currentThread()), e);
            }
            try {
                transaction.setRollbackOnly();
                return false;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (SystemException ex) {
                Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, ex);
                return false;
            }
        }
    }

    private List<Header> processTransactionalRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        while (!WSATGatewayRM.isReadyForRuntime) {
            LOGGER.info("WS-AT recovery is enabled but WS-AT is not ready for runtime.  Processing WS-AT recovery log files...");
            WSATGatewayRM.getInstance().recover();
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        byte[] activityId = WSATHelper.assignUUID().getBytes();
        LOGGER.info("WS-AT activityId:" + activityId);
        XidImpl xid = new XidImpl(1234, new String(System.currentTimeMillis() + "-" + this.counter++).getBytes(), new byte[0]);
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        long ttl = 0L;
        try {
            ttl = TransactionImportManager.getInstance().getTransactionRemainingTimeout();
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4575_WSAT_INFO_IN_CLIENT_SIDE_HANDLER(txId, ttl, "suspendedTransaction", Thread.currentThread()));
            }
        }
        catch (SystemException ex) {
            Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, ex);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4575_WSAT_INFO_IN_CLIENT_SIDE_HANDLER(txId, ttl, "suspendedTransaction", Thread.currentThread()));
        }
        WSCBuilderFactory builderFactory = WSCBuilderFactory.newInstance(transactionalAttribute.getVersion());
        WSATCoordinationContextBuilder builder = builderFactory.newWSATCoordinationContextBuilder();
        CoordinationContextIF cc = builder.txId(txId).expires(ttl).soapVersion(transactionalAttribute.getSoapVersion()).mustUnderstand(true).build();
        Header coordinationHeader = Headers.create(cc.getJAXBRIContext(), cc.getDelegate());
        headers.add(coordinationHeader);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4568_OUTBOUND_APPLICATION_MESSAGE_TRANSACTION_AFTER_ADDING_CONTEXT("suspendedTransaction"));
        }
        Transaction suspendedTransaction = this.suspend(map);
        map.put("wsat.transaction.xid", xid);
        WSATHelper.getInstance().putToXidToTransactionMap(xid, suspendedTransaction);
        return headers;
    }

    private Transaction suspend(Map<String, Object> map) {
        Transaction suspendedTransaction = null;
        try {
            suspendedTransaction = TransactionManagerImpl.getInstance().getTransactionManager().suspend();
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4577_ABOUT_TO_SUSPEND_IN_CLIENT_SIDE_HANDLER(suspendedTransaction, Thread.currentThread()));
            }
            map.put("wsat.transaction", suspendedTransaction);
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4578_SUSPENDED_IN_CLIENT_SIDE_HANDLER(suspendedTransaction, Thread.currentThread()));
            }
        }
        catch (SystemException e) {
            return null;
        }
        return suspendedTransaction;
    }
}

