/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceMaintenanceTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.ConnectionManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DefaultDataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistentSequenceData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSequenceManager
implements SequenceManager {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceManager.class);
    private ConnectionManager cm;
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final long sequenceInactivityTimeout;
    private final long maxConcurrentInboundSequences;
    private final AtomicLong actualConcurrentInboundSequences;
    private final String uniqueEndpointId;
    private volatile boolean disposed = false;

    public PersistentSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration) {
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.sequenceInactivityTimeout = configuration.getRmFeature().getSequenceInactivityTimeout();
        this.actualConcurrentInboundSequences = new AtomicLong(0L);
        this.maxConcurrentInboundSequences = configuration.getRmFeature().getMaxConcurrentSessions();
        this.cm = ConnectionManager.getInstance(new DefaultDataSourceProvider());
        MaintenanceTaskExecutor.INSTANCE.register(new SequenceMaintenanceTask(this, configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS), configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>(this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, String> hashMap = new HashMap<String, String>(this.boundSequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public long concurrentlyOpenedInboundSequencesCount() {
        return this.actualConcurrentInboundSequences.longValue();
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        PersistentSequenceData data = PersistentSequenceData.newInstance(this, this.cm, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Outbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this), data.getBoundSequenceId());
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        long actualSessions = this.actualConcurrentInboundSequences.incrementAndGet();
        if (this.maxConcurrentInboundSequences >= 0L && this.maxConcurrentInboundSequences < actualSessions) {
            this.actualConcurrentInboundSequences.decrementAndGet();
            throw new RxRuntimeException(LocalizationMessages.WSRM_1156_MAX_CONCURRENT_SESSIONS_REACHED(this.maxConcurrentInboundSequences));
        }
        PersistentSequenceData data = PersistentSequenceData.newInstance(this, this.cm, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Inbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this), data.getBoundSequenceId());
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        this.checkIfExist(sequenceId);
        try {
            this.dataLock.readLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            if (this.shouldTeminate(sequence)) {
                this.dataLock.readLock().unlock();
                this.tryTerminateSequence(sequenceId);
                this.dataLock.readLock().lock();
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public Sequence getInboundSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        if (!(sequence instanceof InboundSequence)) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    @Override
    public Sequence getOutboundSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        if (!(sequence instanceof OutboundSequence)) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        Sequence s;
        try {
            this.dataLock.readLock().lock();
            s = this.sequences.get(sequenceId);
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        if (s == null) {
            s = this.fetch(sequenceId);
        }
        return s != null && s.getState() != Sequence.State.TERMINATING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfExist(String ... sequenceIds) throws UnknownSequenceException {
        for (String sequenceId : sequenceIds) {
            Sequence s;
            try {
                this.dataLock.readLock().lock();
                s = this.sequences.get(sequenceId);
            }
            finally {
                this.dataLock.readLock().unlock();
            }
            if (s == null) {
                s = this.fetch(sequenceId);
            }
            if (s != null) continue;
            throw new UnknownSequenceException(sequenceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence fetch(String sequenceId) {
        this.dataLock.writeLock().lock();
        try {
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            PersistentSequenceData sequenceData = PersistentSequenceData.loadInstance(this, this.cm, this.uniqueEndpointId, sequenceId);
            if (sequenceData != null) {
                switch (sequenceData.getType()) {
                    case Inbound: {
                        if (sequenceData.getState() != Sequence.State.TERMINATING) {
                            this.actualConcurrentInboundSequences.incrementAndGet();
                        }
                        AbstractSequence abstractSequence = this.registerSequence(new InboundSequence(sequenceData, this.inboundQueueBuilder, this), sequenceData.getBoundSequenceId());
                        return abstractSequence;
                    }
                    case Outbound: {
                        AbstractSequence abstractSequence = this.registerSequence(new OutboundSequence(sequenceData, this.outboundQueueBuilder, this), sequenceData.getBoundSequenceId());
                        return abstractSequence;
                    }
                }
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence tryTerminateSequence(String sequenceId) {
        try {
            this.dataLock.writeLock().lock();
            AbstractSequence sequence = this.sequences.get(sequenceId);
            if (sequence != null && sequence.getState() != Sequence.State.TERMINATING) {
                if (sequence instanceof InboundSequence) {
                    this.actualConcurrentInboundSequences.decrementAndGet();
                }
                sequence.preDestroy();
            }
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            this.checkIfExist(sequenceId);
            Sequence sequence = this.tryTerminateSequence(sequenceId);
            return sequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            this.checkIfExist(referenceSequenceId, boundSequenceId);
            PersistentSequenceData.bind(this.cm, this.uniqueEndpointId, referenceSequenceId, boundSequenceId);
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        this.checkIfExist(referenceSequenceId);
        try {
            this.dataLock.readLock().lock();
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSequence registerSequence(AbstractSequence sequence, String boundSequenceId) {
        try {
            this.dataLock.writeLock().lock();
            this.sequences.put(sequence.getId(), sequence);
            if (boundSequenceId != null) {
                this.checkIfExist(boundSequenceId);
                this.boundSequences.put(sequence.getId(), boundSequenceId);
            }
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMaintenance() {
        LOGGER.entering();
        boolean continueMaintenance = !this.disposed;
        try {
            this.dataLock.writeLock().lock();
            if (continueMaintenance) {
                Iterator<String> sequenceKeyIterator = this.sequences.keySet().iterator();
                while (sequenceKeyIterator.hasNext()) {
                    String key = sequenceKeyIterator.next();
                    AbstractSequence sequence = this.sequences.get(key);
                    if (this.shouldRemove(sequence)) {
                        LOGGER.config(LocalizationMessages.WSRM_1152_REMOVING_SEQUENCE(sequence.getId()));
                        sequenceKeyIterator.remove();
                        PersistentSequenceData.remove(this.cm, this.uniqueEndpointId, sequence.getId());
                        if (!this.boundSequences.containsKey(sequence.getId())) continue;
                        this.boundSequences.remove(sequence.getId());
                        continue;
                    }
                    if (!this.shouldTeminate(sequence)) continue;
                    LOGGER.config(LocalizationMessages.WSRM_1153_TERMINATING_SEQUENCE(sequence.getId()));
                    this.tryTerminateSequence(sequence.getId());
                }
            }
            boolean bl = continueMaintenance;
            return bl;
        }
        finally {
            this.dataLock.writeLock().unlock();
            LOGGER.exiting(continueMaintenance);
        }
    }

    private boolean shouldTeminate(Sequence sequence) {
        return sequence.getState() != Sequence.State.TERMINATING && (sequence.isExpired() || sequence.getLastActivityTime() + this.sequenceInactivityTimeout < this.currentTimeInMillis());
    }

    private boolean shouldRemove(Sequence sequence) {
        return sequence.getState() == Sequence.State.TERMINATING;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }
}

