/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.message.jaxws;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.commons.xmlutil.Converter;
import com.sun.xml.ws.rx.message.RxMessage;
import com.sun.xml.ws.rx.message.RxMessageBase;
import com.sun.xml.ws.rx.message.jaxws.SerializableMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class JaxwsMessage
extends RxMessageBase {
    private final SerializableMessage jaxwsMessage;

    public JaxwsMessage(@NotNull Packet packet, @NotNull String correlationId) {
        super(correlationId);
        assert (packet != null);
        assert (packet.getMessage() != null);
        this.jaxwsMessage = new SerializableMessage(packet, null);
    }

    private JaxwsMessage(@NotNull SerializableMessage jaxwsMessage, @NotNull String correlationId) {
        super(correlationId);
        this.jaxwsMessage = jaxwsMessage;
    }

    @NotNull
    public Message getJaxwsMessage() {
        return this.jaxwsMessage.getMessage();
    }

    @NotNull
    public Packet getPacket() {
        return this.jaxwsMessage.getPacket();
    }

    public void setPacket(Packet newPacket) {
        this.jaxwsMessage.setPacket(newPacket);
    }

    public byte[] toBytes() {
        return this.jaxwsMessage.toBytes();
    }

    public String getWsaAction() {
        return this.jaxwsMessage.getWsaAction();
    }

    public JaxwsMessageState getState() {
        return new JaxwsMessageState(this);
    }

    public static JaxwsMessage newInstance(@NotNull InputStream dataStream, @NotNull String correlationId, @NotNull String wsaAction) {
        SerializableMessage jaxwsMessage = SerializableMessage.newInstance(dataStream, wsaAction);
        return new JaxwsMessage(jaxwsMessage, correlationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JAX-WS Message { ");
        sb.append("correlationId=[ ").append(this.getCorrelationId()).append(" ], ");
        sb.append("wsaAction=[ ").append(this.jaxwsMessage.getWsaAction());
        sb.append(" ] }");
        return super.toString();
    }

    public static class JaxwsMessageState
    implements RxMessage.State {
        private final byte[] data;
        private final String wsaAction;
        private final String correlationId;

        private JaxwsMessageState(JaxwsMessage message) {
            this.data = message.toBytes();
            this.wsaAction = message.getWsaAction();
            this.correlationId = message.getCorrelationId();
        }

        public JaxwsMessage toMessage() {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            return JaxwsMessage.newInstance(bais, this.correlationId, this.wsaAction);
        }

        public String toString() {
            return "JaxwsMessageState{\n\twsaAction=" + this.wsaAction + ",\n\tcorrelationId=" + this.correlationId + ",\n\tmessage data=\n" + Converter.messageDataToString(this.data, "UTF-8") + "\n}";
        }
    }
}

