/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.dev.AdditionalResponses;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MakeConnectionElement;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.ResponseStorage;
import com.sun.xml.ws.rx.mc.runtime.SoapFaultDetailEntry;
import com.sun.xml.ws.rx.message.jaxws.JaxwsMessage;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.FiberExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(McServerTube.class);
    private final McConfiguration configuration;
    private final FiberExecutor fiberExecutor;
    private final ResponseStorage responseStorage;
    private final Communicator communicator;

    McServerTube(McConfiguration configuration, Tube tubelineHead) {
        super(tubelineHead);
        this.configuration = configuration;
        this.fiberExecutor = new FiberExecutor("McServerTubeCommunicator", tubelineHead);
        this.responseStorage = new ResponseStorage(configuration.getUniqueEndpointId());
        this.communicator = Communicator.builder("mc-server-tube-communincator").soapVersion(configuration.getSoapVersion()).addressingVersion(configuration.getAddressingVersion()).tubelineHead(this.next).jaxbContext(configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion())).build();
    }

    McServerTube(McServerTube original, TubeCloner cloner) {
        super(original, cloner);
        this.configuration = original.configuration;
        this.fiberExecutor = original.fiberExecutor;
        this.responseStorage = original.responseStorage;
        this.communicator = original.communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            McServerTube mcServerTube = new McServerTube(this, cloner);
            return mcServerTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction processRequest(Packet request) {
        try {
            LOGGER.entering();
            HaContext.initFrom(request);
            if (HaContext.failoverDetected()) {
                this.responseStorage.invalidateLocalCache();
            }
            assert (request.getMessage() != null) : "Unexpected [null] message in the server-side Tube.processRequest()";
            String clientUID = this.getClientUID(request);
            if (this.isMakeConnectionRequest(request)) {
                NextAction nextAction = this.handleMakeConnectionRequest(request, clientUID);
                return nextAction;
            }
            if (clientUID == null) {
                NextAction nextAction = super.processRequest(request);
                return nextAction;
            }
            request.getMessage().getHeaders().remove(this.configuration.getAddressingVersion().replyToTag);
            request.getMessage().getHeaders().remove(this.configuration.getAddressingVersion().faultToTag);
            Packet requestCopy = request.copy(true);
            request.addSatellite(new AdditionalResponses());
            this.fiberExecutor.start(request, new AppRequestProcessingCallback(this.responseStorage, clientUID, this.configuration));
            NextAction nextAction = super.doReturnWith(this.createEmptyResponse(requestCopy));
            return nextAction;
        }
        finally {
            HaContext.clear();
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction processResponse(Packet response) {
        try {
            LOGGER.entering();
            NextAction nextAction = super.processResponse(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NextAction handleMakeConnectionRequest(Packet request, String clientUID) {
        try {
            JaxwsMessage pendingMessage;
            MakeConnectionElement mcElement;
            LOGGER.entering();
            try {
                mcElement = (MakeConnectionElement)request.getMessage().readPayloadAsJAXB(this.configuration.getRuntimeVersion().getUnmarshaller(this.configuration.getAddressingVersion()));
            }
            catch (JAXBException ex) {
                throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSMC_0107_ERROR_UNMARSHALLING_PROTOCOL_MESSAGE(), ex));
            }
            if (mcElement.getAddress() == null) {
                NextAction ex = super.doReturnWith(this.createSoapFaultResponse(request, this.configuration.getSoapVersion(), this.configuration.getAddressingVersion(), this.configuration.getRuntimeVersion().protocolVersion.wsmcFaultAction, this.configuration.getSoapVersion().faultCodeServer, this.configuration.getRuntimeVersion().protocolVersion.missingSelectionFaultCode, "The MakeConnection element did not contain any selection criteria.", null));
                return ex;
            }
            if (!mcElement.getAny().isEmpty()) {
                ArrayList<SoapFaultDetailEntry> unsupportedSelections = new ArrayList<SoapFaultDetailEntry>(mcElement.getAny().size());
                for (Object element : mcElement.getAny()) {
                    if (!(element instanceof Node)) continue;
                    Node selectionNode = (Node)element;
                    unsupportedSelections.add(new SoapFaultDetailEntry(this.configuration.getRuntimeVersion().protocolVersion.unsupportedSelectionFaultCode, new QName(selectionNode.getNamespaceURI(), selectionNode.getLocalName()).toString()));
                }
                NextAction i$ = super.doReturnWith(this.createSoapFaultResponse(request, this.configuration.getSoapVersion(), this.configuration.getAddressingVersion(), this.configuration.getRuntimeVersion().protocolVersion.wsmcFaultAction, this.configuration.getSoapVersion().faultCodeServer, this.configuration.getRuntimeVersion().protocolVersion.unsupportedSelectionFaultCode, "The extension element used in the message selection is not supported by the MakeConnection receiver.", unsupportedSelections));
                return i$;
            }
            String selectionUID = this.configuration.getRuntimeVersion().getClientId(mcElement.getAddress().getValue());
            if (selectionUID == null) {
                throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSMC_0108_NULL_SELECTION_ADDRESS()));
            }
            if (clientUID != null && !selectionUID.equals(clientUID)) {
                LOGGER.warning(LocalizationMessages.WSMC_0109_SELECTION_ADDRESS_NOT_MATCHING_WSA_REPLYTO(selectionUID, clientUID));
            }
            Packet response = null;
            JaxwsMessage jaxwsMessage = pendingMessage = selectionUID != null ? this.responseStorage.getPendingResponse(selectionUID) : null;
            if (pendingMessage != null) {
                LOGGER.finer(LocalizationMessages.WSMC_0110_PENDING_MESSAGE_FOUND_FOR_SELECTION_UUID(selectionUID));
                if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured() && pendingMessage.getPacket() == null) {
                    pendingMessage.setPacket(this.communicator.createEmptyResponsePacket(request, pendingMessage.getWsaAction()));
                }
                response = pendingMessage.getPacket();
            }
            if (response == null) {
                LOGGER.finer(LocalizationMessages.WSMC_0111_NO_PENDING_MESSAGE_FOUND_FOR_SELECTION_UUID(selectionUID));
                response = this.createEmptyResponse(request);
            } else {
                Message message = response.getMessage();
                if (message != null) {
                    HeaderList headers = message.getHeaders();
                    headers.add(Headers.create((JAXBRIContext)this.configuration.getRuntimeVersion().getJaxbContext(this.configuration.getAddressingVersion()), (Object)new MessagePendingElement(selectionUID != null && this.responseStorage.hasPendingResponse(selectionUID))));
                }
            }
            NextAction nextAction = super.doReturnWith(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction processException(Throwable t) {
        try {
            LOGGER.entering();
            NextAction nextAction = super.processException(t);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public void preDestroy() {
        this.responseStorage.dispose();
        super.preDestroy();
    }

    private String getClientUID(Packet request) {
        Header replyToHeader = request.getMessage().getHeaders().get(this.configuration.getAddressingVersion().replyToTag, false);
        if (replyToHeader != null) {
            try {
                String replyToAddress = replyToHeader.readAsEPR(this.configuration.getAddressingVersion()).getAddress();
                return this.configuration.getRuntimeVersion().getClientId(replyToAddress);
            }
            catch (XMLStreamException ex) {
                throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSMC_0103_ERROR_RETRIEVING_WSA_REPLYTO_CONTENT(), ex));
            }
        }
        return null;
    }

    private boolean isMakeConnectionRequest(Packet request) {
        return this.configuration.getRuntimeVersion().protocolVersion.wsmcAction.equals(request.getMessage().getHeaders().getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion()));
    }

    private Packet createEmptyResponse(Packet request) {
        return request.createServerResponse(null, null, null, "");
    }

    private Packet createSoapFaultResponse(Packet request, SOAPVersion soapVersion, AddressingVersion av, String action, QName code, QName subcode, String faultReasonText, List<SoapFaultDetailEntry> detailEntries) {
        try {
            SOAPFault soapFault = soapVersion.saajSoapFactory.createFault();
            if (faultReasonText != null) {
                soapFault.setFaultString(faultReasonText, Locale.ENGLISH);
            }
            switch (soapVersion) {
                case SOAP_11: {
                    soapFault.setFaultCode(subcode);
                    break;
                }
                case SOAP_12: {
                    soapFault.setFaultCode(code);
                    soapFault.appendFaultSubcode(subcode);
                    if (detailEntries == null || detailEntries.isEmpty()) break;
                    Detail detail = soapFault.addDetail();
                    for (SoapFaultDetailEntry entry : detailEntries) {
                        detail.addDetailEntry(entry.name).setValue(entry.value);
                    }
                    break;
                }
                default: {
                    throw new RxRuntimeException("Unsupported SOAP version: '" + soapVersion.toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            return request.createServerResponse(soapFaultMessage, av, soapVersion, action);
        }
        catch (SOAPException ex) {
            throw new RxRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    private static final class AppRequestProcessingCallback
    implements Fiber.CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(AppRequestProcessingCallback.class);
        private final ResponseStorage responseStorage;
        private final String clientUID;
        private final McConfiguration configuration;

        public AppRequestProcessingCallback(@NotNull ResponseStorage responseStorage, @NotNull String clientUID, @NotNull McConfiguration configuration) {
            this.responseStorage = responseStorage;
            this.clientUID = clientUID;
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(Packet response) {
            try {
                LOGGER.finer(LocalizationMessages.WSMC_0105_STORING_RESPONSE(this.clientUID));
                HaContext.initFrom(response);
                this.storeResponse(response);
                AdditionalResponses additionalResponses = response.getSatellite(AdditionalResponses.class);
                if (additionalResponses != null) {
                    for (Packet additionalResponse : additionalResponses.getAdditionalResponsePacketQueue()) {
                        this.storeResponse(additionalResponse);
                    }
                } else {
                    LOGGER.fine("Response packet did not contain any AdditionalResponses property set.");
                }
            }
            finally {
                HaContext.clear();
            }
        }

        public void onCompletion(Throwable error) {
            LOGGER.severe(LocalizationMessages.WSMC_0106_EXCEPTION_IN_REQUEST_PROCESSING(this.clientUID), error);
        }

        private void storeResponse(Packet response) {
            if (response.getMessage() != null) {
                HeaderList headers = response.getMessage().getHeaders();
                headers.remove(this.configuration.getAddressingVersion().toTag);
                headers.add(Headers.create(this.configuration.getAddressingVersion().toTag, this.configuration.getRuntimeVersion().getAnonymousAddress(this.clientUID)));
                JaxwsMessage responseMessage = new JaxwsMessage(response, headers.getMessageID(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion()));
                this.responseStorage.store(responseMessage, this.clientUID);
            }
        }
    }
}

