/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.logging.Logger;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.rx.RxRuntimeException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.EndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxbContextRepository {
    private static final Logger LOGGER = Logger.getLogger(JaxbContextRepository.class);
    private Map<AddressingVersion, JAXBRIContext> jaxbContexts;
    private ThreadLocal<Map<AddressingVersion, Unmarshaller>> threadLocalUnmarshallers = new ThreadLocal<Map<AddressingVersion, Unmarshaller>>(){

        @Override
        protected Map<AddressingVersion, Unmarshaller> initialValue() {
            HashMap<AddressingVersion, Unmarshaller> result = new HashMap<AddressingVersion, Unmarshaller>();
            for (Map.Entry entry : JaxbContextRepository.this.jaxbContexts.entrySet()) {
                try {
                    result.put((AddressingVersion)((Object)entry.getKey()), ((JAXBRIContext)((Object)entry.getValue())).createUnmarshaller());
                }
                catch (JAXBException ex) {
                    LOGGER.severe("Unable to create JAXB unmarshaller", ex);
                    throw new RxRuntimeException("Unable to create JAXB unmarshaller", ex);
                }
            }
            return result;
        }
    };

    public JaxbContextRepository(Class<?> ... classes) throws RxRuntimeException {
        this.jaxbContexts = new HashMap<AddressingVersion, JAXBRIContext>();
        for (AddressingVersion av : AddressingVersion.values()) {
            this.jaxbContexts.put(av, JaxbContextRepository.createContext(av, classes));
        }
    }

    private static final JAXBRIContext createContext(AddressingVersion av, Class<?> ... classes) throws RxRuntimeException {
        LinkedList jaxbElementClasses = new LinkedList(Arrays.asList(classes));
        jaxbElementClasses.add(av.eprType.eprClass);
        HashMap<Class, Class> eprClassReplacementMap = new HashMap<Class, Class>();
        eprClassReplacementMap.put(EndpointReference.class, av.eprType.eprClass);
        try {
            return JAXBRIContext.newInstance(jaxbElementClasses.toArray(classes), null, eprClassReplacementMap, null, false, null);
        }
        catch (JAXBException ex) {
            throw new RxRuntimeException("Unable to create JAXB RI Context", ex);
        }
    }

    public Unmarshaller getUnmarshaller(AddressingVersion av) throws RxRuntimeException {
        return this.threadLocalUnmarshallers.get().get((Object)av);
    }

    public JAXBRIContext getJaxbContext(AddressingVersion av) {
        return this.jaxbContexts.get((Object)av);
    }
}

