/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common.endpoint;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATFaultFactory;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATSynchronization;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import com.sun.xml.ws.tx.coord.common.EndpointReferenceBuilder;
import com.sun.xml.ws.tx.coord.common.RegistrationIF;
import com.sun.xml.ws.tx.coord.common.WSCUtil;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterType;
import java.util.logging.Level;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRegistration<T extends EndpointReference, K, P>
implements RegistrationIF<T, K, P> {
    private static final Logger LOGGER = Logger.getLogger(BaseRegistration.class);
    WebServiceContext context;
    Transactional.Version version;

    protected BaseRegistration(WebServiceContext context, Transactional.Version version) {
        this.context = context;
        this.version = version;
    }

    @Override
    public BaseRegisterResponseType<T, P> registerOperation(BaseRegisterType<T, K> parameters) {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4504_REGISTER_OPERATION_ENTERED(parameters));
        }
        String txId = WSATHelper.getInstance().getWSATTidFromWebServiceContextHeaderList(this.context);
        Xid xidFromWebServiceContextHeaderList = TransactionIdHelper.getInstance().wsatid2xid(txId);
        Xid xid = this.processRegisterTypeAndEnlist(parameters, xidFromWebServiceContextHeaderList);
        BaseRegisterResponseType<T, P> registerResponseType = this.createRegisterResponseType(xid);
        try {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4505_REGISTER_OPERATION_EXITED(registerResponseType));
            }
            TransactionManagerImpl.getInstance().getTransactionManager().suspend();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            Logger.getLogger(BaseRegistration.class).log(Level.SEVERE, null, ex);
        }
        return registerResponseType;
    }

    Xid processRegisterTypeAndEnlist(BaseRegisterType<T, K> parameters, Xid xid) {
        if (parameters == null) {
            WSATFaultFactory.throwInvalidParametersFault();
        }
        String protocolIdentifier = parameters.getProtocolIdentifier();
        if (parameters.isDurable()) {
            return this.enlistResource(xid, parameters.getParticipantProtocolService());
        }
        if (parameters.isVolatile()) {
            this.registerSynchronization(xid, parameters.getParticipantProtocolService());
            return null;
        }
        LOGGER.severe(LocalizationMessages.WSAT_4580_UNKNOWN_PARTICIPANT_IDENTIFIER(protocolIdentifier));
        throw new WebServiceException("Unknown participant identifier:" + protocolIdentifier);
    }

    BaseRegisterResponseType<T, P> createRegisterResponseType(Xid xid) {
        BaseRegisterResponseType<T, P> registerResponseType = this.newRegisterResponseType();
        String coordinatorHostAndPort = this.getCoordinatorAddress();
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        String branchQual = new String(xid.getBranchQualifier());
        EndpointReferenceBuilder<T> builder = this.getEndpointReferenceBuilder();
        T endpointReference = builder.address(coordinatorHostAndPort).referenceParameter(WSCUtil.referenceElementTxId(txId), WSCUtil.referenceElementBranchQual(branchQual), WSCUtil.referenceElementRoutingInfo()).build();
        registerResponseType.setCoordinatorProtocolService(endpointReference);
        return registerResponseType;
    }

    private Xid enlistResource(Xid xid, T epr) {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4503_ENLIST_RESOURCE(epr, xid));
        }
        WSATXAResource wsatXAResource = new WSATXAResource(this.version, (EndpointReference)epr, xid);
        try {
            Xid xidFromEnlist = this.getTransactionServices().enlistResource(wsatXAResource, xid);
            wsatXAResource.setXid(xidFromEnlist);
            wsatXAResource.setBranchQualifier(xidFromEnlist.getBranchQualifier());
            return xidFromEnlist;
        }
        catch (WSATException e) {
            e.printStackTrace();
            throw new WebServiceException((Throwable)e);
        }
    }

    private void registerSynchronization(Xid xid, T epr) {
        LOGGER.info(LocalizationMessages.WSAT_4525_REGISTER_SYNCHRONIZATION(epr, xid));
        WSATSynchronization wsatXAResource = new WSATSynchronization(this.version, (EndpointReference)epr, xid);
        try {
            this.getTransactionServices().registerSynchronization(wsatXAResource, xid);
        }
        catch (WSATException e) {
            LOGGER.severe(LocalizationMessages.WSAT_4507_EXCEPTION_DURING_REGISTER_SYNCHRONIZATION(), e);
            WSATFaultFactory.throwContextRefusedFault();
        }
    }

    protected abstract EndpointReferenceBuilder<T> getEndpointReferenceBuilder();

    protected abstract BaseRegisterResponseType<T, P> newRegisterResponseType();

    protected abstract String getCoordinatorAddress();

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }
}

