/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;

public class WSATSynchronization
implements Synchronization {
    private static final Logger LOGGER = Logger.getLogger(WSATSynchronization.class);
    Xid m_xid;
    String m_status = "UNKNOWN";
    private static final String UNKNOWN = "UNKNOWN";
    boolean m_isRemovedFromMap = false;
    Transactional.Version m_version;
    EndpointReference m_epr;

    public WSATSynchronization(EndpointReference epr, Xid xid) {
        this(Transactional.Version.WSAT10, epr, xid);
    }

    public WSATSynchronization(Transactional.Version version, EndpointReference epr, Xid xid) {
        this.m_version = version;
        this.m_xid = xid;
        this.m_epr = epr;
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4526_WSAT_SYNCHRONIZATION(this.m_epr.toString(), this.m_xid, ""));
        }
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4527_BEFORE_COMPLETION_ENTERED(this.m_epr.toString(), this.m_xid));
        }
        try {
            WSATHelper.getInstance().beforeCompletion(this.m_epr, this.m_xid, this);
            WSATSynchronization wSATSynchronization = this;
            synchronized (wSATSynchronization) {
                block17: {
                    if (!this.m_status.equals("Committed")) break block17;
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4528_BEFORE_COMPLETION_COMMITTED_BEFORE_WAIT(this.m_epr.toString(), this.m_xid));
                    }
                    return;
                }
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4529_BEFORE_COMPLETION_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                }
                this.wait(WSATHelper.getInstance().getWaitForReplyTimeout());
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4530_BEFORE_COMPLETION_FINISHED_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                }
            }
            LOGGER.info(LocalizationMessages.WSAT_4531_BEFORE_COMPLETION_RECEIVED_REPLY_WITH_STATUS(this.m_status, this.m_epr.toString(), this.m_xid));
            if (!this.m_status.equals("Committed")) {
                LOGGER.severe(LocalizationMessages.WSAT_4532_BEFORE_COMPLETION_UNEXCEPTED_STATUS(this.m_status, this.m_epr.toString(), this.m_xid));
                this.setRollbackOnly();
            }
        }
        catch (InterruptedException e) {
            LOGGER.severe(LocalizationMessages.WSAT_4533_BEFORE_COMPLETION_INTERRUPTED_EXCEPTION(this.m_epr.toString(), this.m_xid), e);
            this.setRollbackOnly();
        }
        catch (Exception e) {
            LOGGER.severe(LocalizationMessages.WSAT_4534_BEFORE_COMPLETION_EXCEPTION(this.m_epr.toString(), this.m_xid), e);
            this.setRollbackOnly();
        }
        finally {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
            this.m_isRemovedFromMap = true;
        }
    }

    private void setRollbackOnly() {
        Object transaction = null;
        if (transaction != null) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException e) {
                LOGGER.info(LocalizationMessages.WSAT_4535_BEFORE_COMPLETION_SYSTEM_EXCEPTION_DURING_SET_ROLLBACK_ONLY((Object)e, this.m_epr.toString(), this.m_xid));
            }
        }
        LOGGER.info(LocalizationMessages.WSAT_4536_BEFORE_COMPLETION_TRANSACTION_NULL_DURING_SET_ROLLBACK_ONLY(this.m_epr.toString(), this.m_xid));
    }

    public void afterCompletion(int status) {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4537_AFTER_COMPLETION_STATUS(this.m_epr.toString(), this.m_xid, "" + status));
        }
    }

    Xid getXid() {
        return this.m_xid;
    }

    public boolean equals(Object obj) {
        return obj instanceof WSATSynchronization && ((WSATSynchronization)obj).getXid().equals(this.m_xid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
        }
    }
}

