/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Layout;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.HttpsToken;
import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBinding
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.TransportBinding,
SecurityAssertionValidator {
    HttpsToken transportToken;
    private AlgorithmSuite algSuite;
    boolean includeTimeStamp = false;
    MessageLayout layout = MessageLayout.Lax;
    boolean populated = false;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion;

    public TransportBinding() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public TransportBinding(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void addTransportToken(com.sun.xml.ws.security.policy.Token token) {
        this.transportToken = (HttpsToken)token;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getTransportToken() {
        this.populate();
        return this.transportToken;
    }

    public void setAlgorithmSuite(AlgorithmSuite algSuite) {
        this.algSuite = algSuite;
    }

    @Override
    public AlgorithmSuite getAlgorithmSuite() {
        this.populate();
        return this.algSuite;
    }

    public void includeTimeStamp(boolean value) {
        this.includeTimeStamp = value;
    }

    @Override
    public boolean isIncludeTimeStamp() {
        this.populate();
        return this.includeTimeStamp;
    }

    public void setLayout(MessageLayout layout) {
        this.layout = layout;
    }

    @Override
    public MessageLayout getLayout() {
        this.populate();
        return this.layout;
    }

    @Override
    public boolean isSignContent() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSignContent(boolean contentOnly) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setProtectionOrder(String order) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getProtectionOrder() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setTokenProtection(boolean token) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSignatureProtection(boolean token) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean getTokenProtection() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean getSignatureProtection() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            AssertionSet assertions = policy.getAssertionSet();
            if (assertions == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            for (PolicyAssertion assertion : assertions) {
                if (PolicyUtil.isAlgorithmAssertion(assertion, this.spVersion)) {
                    this.algSuite = (AlgorithmSuite)((Object)assertion);
                    String sigAlgo = assertion.getAttributeValue(new QName("signatureAlgorithm"));
                    this.algSuite.setSignatureAlgorithm(sigAlgo);
                    continue;
                }
                if (PolicyUtil.isToken(assertion, this.spVersion)) {
                    this.transportToken = (HttpsToken)((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isMessageLayout(assertion, this.spVersion)) {
                    this.layout = ((Layout)assertion).getMessageLayout();
                    continue;
                }
                if (PolicyUtil.isIncludeTimestamp(assertion, this.spVersion)) {
                    this.includeTimeStamp = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "TransportBinding");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public boolean isDisableTimestampSigning() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

