/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContextImpl;
import com.sun.xml.ws.assembler.ServerTubelineAssemblyContextImpl;
import com.sun.xml.ws.assembler.TubeCreator;
import com.sun.xml.ws.assembler.TubelineAssemblyController;
import com.sun.xml.ws.assembler.localization.LocalizationMessages;
import com.sun.xml.ws.dump.LoggingDumpTube;
import com.sun.xml.ws.runtime.WsdlDocumentFilter;
import java.util.Collection;
import java.util.logging.Level;

public final class TubelineAssemblerFactoryImpl
extends TubelineAssemblerFactory {
    public TubelineAssembler doCreate(BindingID bindingId) {
        return new MetroTubelineAssembler(bindingId);
    }

    private static class MetroTubelineAssembler
    implements TubelineAssembler {
        private static final String COMMON_MESSAGE_DUMP_SYSTEM_PROPERTY_BASE = "com.sun.metro.soap.dump";
        private static final Logger LOGGER = Logger.getLogger(MetroTubelineAssembler.class);
        private final BindingID bindingId;
        private final TubelineAssemblyController tubelineAssemblyController;

        MetroTubelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
            this.tubelineAssemblyController = new TubelineAssemblyController();
        }

        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext jaxwsContext) {
            ClientTubelineAssemblyContextImpl context = new ClientTubelineAssemblyContextImpl(jaxwsContext);
            Collection<TubeCreator> tubeCreators = this.tubelineAssemblyController.getTubeCreators(context);
            for (TubeCreator tubeCreator : tubeCreators) {
                tubeCreator.updateContext(context);
            }
            for (TubeCreator tubeCreator : tubeCreators) {
                MessageDumpingInfo msgDumpInfo = this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), Side.Client);
                Tube oldTubelineHead = context.getTubelineHead();
                LoggingDumpTube afterDumpTube = null;
                if (msgDumpInfo.dumpAfter) {
                    afterDumpTube = new LoggingDumpTube(msgDumpInfo.logLevel, LoggingDumpTube.Position.After, context.getTubelineHead());
                    context.setTubelineHead(afterDumpTube);
                }
                if (!context.setTubelineHead(tubeCreator.createTube(context))) {
                    if (afterDumpTube == null) continue;
                    context.setTubelineHead(oldTubelineHead);
                    continue;
                }
                String loggedTubeName = context.getTubelineHead().getClass().getName();
                if (afterDumpTube != null) {
                    afterDumpTube.setLoggedTubeName(loggedTubeName);
                }
                if (!msgDumpInfo.dumpBefore) continue;
                LoggingDumpTube beforeDumpTube = new LoggingDumpTube(msgDumpInfo.logLevel, LoggingDumpTube.Position.Before, context.getTubelineHead());
                beforeDumpTube.setLoggedTubeName(loggedTubeName);
                context.setTubelineHead(beforeDumpTube);
            }
            return context.getTubelineHead();
        }

        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext jaxwsContext) {
            ServerTubelineAssemblyContextImpl context = new ServerTubelineAssemblyContextImpl(jaxwsContext);
            ServiceDefinition sd = context.getEndpoint().getServiceDefinition();
            if (sd != null) {
                sd.addFilter(new WsdlDocumentFilter());
            }
            Collection<TubeCreator> tubeCreators = this.tubelineAssemblyController.getTubeCreators(context);
            for (TubeCreator tubeCreator : tubeCreators) {
                tubeCreator.updateContext(context);
            }
            for (TubeCreator tubeCreator : tubeCreators) {
                MessageDumpingInfo msgDumpInfo = this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), Side.Endpoint);
                Tube oldTubelineHead = context.getTubelineHead();
                LoggingDumpTube afterDumpTube = null;
                if (msgDumpInfo.dumpAfter) {
                    afterDumpTube = new LoggingDumpTube(msgDumpInfo.logLevel, LoggingDumpTube.Position.After, context.getTubelineHead());
                    context.setTubelineHead(afterDumpTube);
                }
                if (!context.setTubelineHead(tubeCreator.createTube(context))) {
                    if (afterDumpTube == null) continue;
                    context.setTubelineHead(oldTubelineHead);
                    continue;
                }
                String loggedTubeName = context.getTubelineHead().getClass().getName();
                if (afterDumpTube != null) {
                    afterDumpTube.setLoggedTubeName(loggedTubeName);
                }
                if (!msgDumpInfo.dumpBefore) continue;
                LoggingDumpTube beforeDumpTube = new LoggingDumpTube(msgDumpInfo.logLevel, LoggingDumpTube.Position.Before, context.getTubelineHead());
                beforeDumpTube.setLoggedTubeName(loggedTubeName);
                context.setTubelineHead(beforeDumpTube);
            }
            return context.getTubelineHead();
        }

        private MessageDumpingInfo setupMessageDumping(String msgDumpSystemPropertyBase, Side side) {
            boolean dumpBefore = false;
            boolean dumpAfter = false;
            Level logLevel = Level.INFO;
            Boolean value = this.getBooleanValue(COMMON_MESSAGE_DUMP_SYSTEM_PROPERTY_BASE);
            if (value != null) {
                dumpBefore = value;
                dumpAfter = value;
            }
            dumpBefore = (value = this.getBooleanValue("com.sun.metro.soap.dump.before")) != null ? value : dumpBefore;
            value = this.getBooleanValue("com.sun.metro.soap.dump.after");
            dumpAfter = value != null ? value : dumpAfter;
            Level levelValue = this.getLevelValue("com.sun.metro.soap.dump.level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            if ((value = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString())) != null) {
                dumpBefore = value;
                dumpAfter = value;
            }
            dumpBefore = (value = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString() + ".before")) != null ? value : dumpBefore;
            value = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString() + ".after");
            dumpAfter = value != null ? value : dumpAfter;
            levelValue = this.getLevelValue("com.sun.metro.soap.dump." + side.toString() + ".level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            if ((value = this.getBooleanValue(msgDumpSystemPropertyBase)) != null) {
                dumpBefore = value;
                dumpAfter = value;
            }
            dumpBefore = (value = this.getBooleanValue(msgDumpSystemPropertyBase + ".before")) != null ? value : dumpBefore;
            value = this.getBooleanValue(msgDumpSystemPropertyBase + ".after");
            dumpAfter = value != null ? value : dumpAfter;
            levelValue = this.getLevelValue(msgDumpSystemPropertyBase + ".level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            if ((value = this.getBooleanValue(msgDumpSystemPropertyBase = msgDumpSystemPropertyBase + "." + side.toString())) != null) {
                dumpBefore = value;
                dumpAfter = value;
            }
            dumpBefore = (value = this.getBooleanValue(msgDumpSystemPropertyBase + ".before")) != null ? value : dumpBefore;
            value = this.getBooleanValue(msgDumpSystemPropertyBase + ".after");
            dumpAfter = value != null ? value : dumpAfter;
            levelValue = this.getLevelValue(msgDumpSystemPropertyBase + ".level");
            if (levelValue != null) {
                logLevel = levelValue;
            }
            return new MessageDumpingInfo(dumpBefore, dumpAfter, logLevel);
        }

        private Boolean getBooleanValue(String propertyName) {
            Boolean retVal = null;
            String stringValue = System.getProperty(propertyName);
            if (stringValue != null) {
                retVal = Boolean.valueOf(stringValue);
                LOGGER.fine(LocalizationMessages.MASM_0018_MSG_LOGGING_SYSTEM_PROPERTY_SET_TO_VALUE(propertyName, retVal));
            }
            return retVal;
        }

        private Level getLevelValue(String propertyName) {
            Level retVal = null;
            String stringValue = System.getProperty(propertyName);
            if (stringValue != null) {
                LOGGER.fine(LocalizationMessages.MASM_0018_MSG_LOGGING_SYSTEM_PROPERTY_SET_TO_VALUE(propertyName, stringValue));
                try {
                    retVal = Level.parse(stringValue);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(LocalizationMessages.MASM_0019_MSG_LOGGING_SYSTEM_PROPERTY_ILLEGAL_VALUE(propertyName, stringValue), ex);
                }
            }
            return retVal;
        }

        private static class MessageDumpingInfo {
            final boolean dumpBefore;
            final boolean dumpAfter;
            final Level logLevel;

            MessageDumpingInfo(boolean dumpBefore, boolean dumpAfter, Level logLevel) {
                this.dumpBefore = dumpBefore;
                this.dumpAfter = dumpAfter;
                this.logLevel = logLevel;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Side {
            Client("client"),
            Endpoint("endpoint");

            private final String name;

            private Side(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

