/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import java.io.Serializable;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnackedMessageReplicationManager
implements ReplicationManager<String, ApplicationMessage> {
    private BackingStore<StickyKey, JaxwsApplicationMessage.JaxwsApplicationMessageState> unackedMesagesBs;

    public UnackedMessageReplicationManager(String uniqueEndpointId) {
        this.unackedMesagesBs = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), uniqueEndpointId + "_UNACKED_MESSAGES_BS", StickyKey.class, JaxwsApplicationMessage.JaxwsApplicationMessageState.class);
    }

    @Override
    public ApplicationMessage load(String key) {
        JaxwsApplicationMessage.JaxwsApplicationMessageState state = HighAvailabilityProvider.loadFrom(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key)), null);
        return state.toMessage();
    }

    @Override
    public void save(String key, ApplicationMessage value, boolean isNew) {
        if (!(value instanceof JaxwsApplicationMessage)) {
            throw new IllegalArgumentException("Unsupported application message type: " + value.getClass().getName());
        }
        JaxwsApplicationMessage.JaxwsApplicationMessageState ams = ((JaxwsApplicationMessage)value).getState();
        HaInfo haInfo = HaContext.currentHaInfo();
        if (haInfo != null) {
            HighAvailabilityProvider.saveTo(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key), haInfo.getKey()), ams, isNew);
        } else {
            StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
            String replicaId = HighAvailabilityProvider.saveTo(this.unackedMesagesBs, stickyKey, ams, isNew);
            HaContext.updateHaInfo(new HaInfo(stickyKey.getHashKey(), replicaId, false));
        }
    }

    @Override
    public void remove(String key) {
        HighAvailabilityProvider.removeFrom(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key)));
    }

    @Override
    public void close() {
        HighAvailabilityProvider.close(this.unackedMesagesBs);
    }

    @Override
    public void destroy() {
        HighAvailabilityProvider.destroy(this.unackedMesagesBs);
    }
}

