/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.TargetResolver;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetResolverImpl
implements TargetResolver {
    private ProcessingContext ctx = null;
    private StringBuffer tokenList = new StringBuffer();
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public TargetResolverImpl(ProcessingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void resolveAndVerifyTargets(List<Target> actualTargets, List<Target> inferredTargets, WSSPolicy actualPolicy) throws XWSSecurityException {
        SignaturePolicy.FeatureBinding fp;
        String policyType = PolicyTypeUtil.signaturePolicy(actualPolicy) ? "Signature" : "Encryption";
        boolean isEndorsing = false;
        if (PolicyTypeUtil.signaturePolicy(actualPolicy) && (fp = (SignaturePolicy.FeatureBinding)actualPolicy.getFeatureBinding()).isEndorsingSignature()) {
            isEndorsing = true;
        }
        for (Target actualTarget : actualTargets) {
            if ("Signature".equals(policyType) && ((SignatureTarget)actualTarget).isITNever()) continue;
            boolean found = false;
            String targetInPolicy = this.getTargetValue(actualTarget);
            for (Target inferredTarget : inferredTargets) {
                String targetInMessage = this.getTargetValue(inferredTarget);
                if (targetInPolicy == null || !targetInPolicy.equals(targetInMessage)) continue;
                found = true;
                break;
            }
            if (targetInPolicy != null && targetInPolicy.equals("BinarySecurityToken") && !found) {
                if (this.containsSTRTransform(actualTarget, inferredTargets)) continue;
                log.log(Level.SEVERE, LogStringsMessages.WSS_0206_POLICY_VIOLATION_EXCEPTION());
                log.log(Level.SEVERE, LogStringsMessages.WSS_0814_POLICY_VERIFICATION_ERROR_MISSING_TARGET(targetInPolicy, policyType));
                throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for " + policyType);
            }
            if (found || targetInPolicy == null || !this.presentInMessage(targetInPolicy)) continue;
            log.log(Level.SEVERE, LogStringsMessages.WSS_0206_POLICY_VIOLATION_EXCEPTION());
            log.log(Level.SEVERE, LogStringsMessages.WSS_0814_POLICY_VERIFICATION_ERROR_MISSING_TARGET(targetInPolicy, policyType));
            if (isEndorsing) {
                throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for Endorsing " + policyType);
            }
            throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for " + policyType);
        }
        if ("Signature".equals(policyType) && this.countSTRTransforms(actualTargets, true) != this.countSTRTransforms(inferredTargets, false)) {
            if (isEndorsing) {
                throw new XWSSecurityException("Policy verification error:Missing reference for one of { " + this.tokenList.toString() + "} for Endorsing " + policyType);
            }
            this.tokenList.delete(this.tokenList.lastIndexOf(","), this.tokenList.length());
            throw new XWSSecurityException("Policy verification error:Missing reference for one of { " + this.tokenList + "}  for " + policyType);
        }
    }

    private boolean containsSTRTransform(Target actualTarget, List<Target> inferredTargets) {
        for (Target inferredTarget : inferredTargets) {
            SignatureTarget st = (SignatureTarget)inferredTarget;
            ArrayList ar = st.getTransforms();
            for (SignatureTarget.Transform str : ar) {
                if (!str.getTransform().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) continue;
                return true;
            }
        }
        return false;
    }

    private int countSTRTransforms(List<Target> targets, boolean isActualTarget) {
        int strTransformCount = 0;
        for (Target target : targets) {
            if (!(target instanceof SignatureTarget)) continue;
            SignatureTarget st = (SignatureTarget)target;
            ArrayList ar = st.getTransforms();
            for (SignatureTarget.Transform str : ar) {
                if (!str.getTransform().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) continue;
                ++strTransformCount;
                if (!isActualTarget) continue;
                String localPart = st.getPolicyQName() != null ? st.getPolicyQName().getLocalPart() : "";
                this.tokenList.append(localPart);
                this.tokenList.append(", ");
            }
        }
        return strTransformCount;
    }

    private String getTargetValue(Target target) {
        String targetInPolicy = null;
        if ("qname".equals(target.getType())) {
            targetInPolicy = target.getQName().getLocalPart();
        } else if ("uri".equals(target.getType())) {
            if (target.getPolicyQName() != null) {
                targetInPolicy = target.getPolicyQName().getLocalPart();
            } else {
                String val = target.getValue();
                String id = null;
                id = val.charAt(0) == '#' ? val.substring(1, val.length()) : val;
                targetInPolicy = this.getElementById(id);
                if (targetInPolicy == null && id.startsWith("SAML")) {
                    return "Assertion";
                }
            }
        }
        return targetInPolicy;
    }

    private String getElementById(String id) {
        SecurityContext sc = ((JAXBFilterProcessingContext)this.ctx).getSecurityContext();
        MessageHeaders headers = sc.getNonSecurityHeaders();
        if (headers != null && ((HeaderList)headers).size() > 0) {
            Iterator<Header> listItr = headers.getHeaders();
            while (listItr.hasNext()) {
                GenericSecuredHeader header = (GenericSecuredHeader)listItr.next();
                if (!header.hasID(id)) continue;
                return header.getLocalPart();
            }
        }
        ArrayList processedHeaders = sc.getProcessedSecurityHeaders();
        for (int j = 0; j < processedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)processedHeaders.get(j);
            if (!id.equals(header.getId())) continue;
            return header.getLocalPart();
        }
        ArrayList bufferedHeaders = sc.getBufferedSecurityHeaders();
        for (int j = 0; j < bufferedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)bufferedHeaders.get(j);
            if (!id.equals(header.getId())) continue;
            return header.getLocalPart();
        }
        return null;
    }

    private boolean presentInMessage(String targetInPolicy) {
        if ("Body".equals(targetInPolicy)) {
            return true;
        }
        SecurityContext sc = ((JAXBFilterProcessingContext)this.ctx).getSecurityContext();
        HeaderList headers = (HeaderList)sc.getNonSecurityHeaders();
        if (headers != null && headers.size() > 0) {
            ListIterator listItr = headers.listIterator();
            while (listItr.hasNext()) {
                GenericSecuredHeader header = (GenericSecuredHeader)listItr.next();
                if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
                return true;
            }
        }
        ArrayList processedHeaders = sc.getProcessedSecurityHeaders();
        for (int j = 0; j < processedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)processedHeaders.get(j);
            if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
            return true;
        }
        ArrayList bufferedHeaders = sc.getBufferedSecurityHeaders();
        for (int j = 0; j < bufferedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)bufferedHeaders.get(j);
            if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTargetPresent(List<Target> actualTargets) {
        for (Target actualTarget : actualTargets) {
            String targetInPolicy = this.getTargetValue(actualTarget);
            if (!this.presentInMessage(targetInPolicy)) continue;
            return true;
        }
        return false;
    }
}

