/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.CipherDataProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.util.CheckedInputStream;
import com.sun.xml.ws.security.opt.impl.util.DecryptedInputStream;
import com.sun.xml.ws.security.opt.impl.util.FilteredXMLStreamReader;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class EncryptedData
implements SecurityHeaderElement,
SecurityElementWriter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private static final String ENCRYPTION_METHOD = "EncryptionMethod".intern();
    private static final String CIPHER_DATA = "CipherData".intern();
    private static final String KEY_INFO = "KeyInfo".intern();
    private static final int KEYINFO_ELEMENT = 1;
    private static final int ENCRYPTIONMETHOD_ELEMENT = 2;
    private static final int CIPHER_DATA_ELEMENT = 5;
    private JAXBFilterProcessingContext pc = null;
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private String encryptionMethod = "";
    private Key dataEncKey = null;
    private InputStream cin = null;
    private CryptoProcessor cp = null;
    CipherDataProcessor cdp = null;
    private boolean hasCipherReference = false;
    private byte[] decryptedMimeData = null;
    private String attachmentContentId = null;
    private String attachmentContentType = null;
    private String mimeType = null;
    private WSSPolicy inferredKB = null;
    HashMap<String, String> parentNS = null;

    public EncryptedData(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap<String, String> parentNS) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.parentNS = parentNS;
        this.process(reader);
    }

    public EncryptedData(XMLStreamReader reader, Key dataEncKey, JAXBFilterProcessingContext pc, HashMap<String, String> parentNS) throws XMLStreamException, XWSSecurityException {
        this.dataEncKey = dataEncKey;
        this.pc = pc;
        this.parentNS = parentNS;
        this.process(reader);
    }

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        this.id = reader.getAttributeValue(null, "Id");
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        this.mimeType = reader.getAttributeValue(null, "MimeType");
        if (StreamUtil.moveToNextElement(reader)) {
            int refElement = this.getEventType(reader);
            while (true) {
                if (reader.getEventType() == 8) break;
                switch (refElement) {
                    case 2: {
                        this.encryptionMethod = reader.getAttributeValue(null, "Algorithm");
                        if (this.encryptionMethod == null || this.encryptionMethod.length() == 0) {
                            if (this.pc.isBSP()) {
                                logger.log(Level.SEVERE, LogStringsMessages.BSP_5601_ENCRYPTEDDATA_ENCRYPTIONMETHOD(this.id));
                                throw new XWSSecurityException(LogStringsMessages.BSP_5601_ENCRYPTEDDATA_ENCRYPTIONMETHOD(this.id));
                            }
                            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1925_EMPTY_ENCMETHOD_ED());
                            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1925_EMPTY_ENCMETHOD_ED());
                        }
                        if (this.pc.isBSP() && !this.encryptionMethod.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") && !this.encryptionMethod.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") && !this.encryptionMethod.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                            logger.log(Level.SEVERE, LogStringsMessages.BSP_5626_KEYENCRYPTIONALGO());
                            throw new XWSSecurityException(LogStringsMessages.BSP_5626_KEYENCRYPTIONALGO());
                        }
                        reader.next();
                        break;
                    }
                    case 1: {
                        this.pc.getSecurityContext().setInferredKB(null);
                        KeyInfoProcessor kip = new KeyInfoProcessor(this.pc, KeySelector.Purpose.DECRYPT);
                        this.dataEncKey = kip.getKey(reader);
                        this.inferredKB = (WSSPolicy)this.pc.getSecurityContext().getInferredKB();
                        this.pc.getSecurityContext().setInferredKB(null);
                        if (kip.hasSTR() || !this.pc.isBSP()) break;
                        logger.log(Level.SEVERE, LogStringsMessages.BSP_5426_ENCRYPTEDKEYINFO(this.id));
                        throw new XWSSecurityException(LogStringsMessages.BSP_5426_ENCRYPTEDKEYINFO(this.id));
                    }
                    case 5: {
                        this.cdp = new CipherDataProcessor(this.pc);
                        this.cdp.process(reader);
                        this.hasCipherReference = this.cdp.hasCipherReference();
                        if (!this.hasCipherReference) break;
                        this.attachmentContentId = this.cdp.getAttachmentContentId();
                        this.attachmentContentType = this.cdp.getAttachmentContentType();
                        break;
                    }
                }
                if (this.shouldBreak(reader)) break;
                if (reader.getEventType() == 1) {
                    if (this.getEventType(reader) == -1) {
                        reader.next();
                    }
                } else {
                    reader.next();
                }
                refElement = this.getEventType(reader);
            }
        }
        if (reader.hasNext()) {
            reader.next();
        }
    }

    public boolean shouldBreak(XMLStreamReader reader) throws XMLStreamException {
        if (StreamUtil._break(reader, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#")) {
            return true;
        }
        return reader.getEventType() == 8;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionMethod;
    }

    public Key getKey() {
        return this.dataEncKey;
    }

    public InputStream getCipherInputStream() throws XWSSecurityException {
        if (this.dataEncKey == null) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1926_ED_KEY_NOTSET());
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1926_ED_KEY_NOTSET(), null);
        }
        this.cp = new CryptoProcessor(2, this.encryptionMethod, this.dataEncKey);
        try {
            this.cin = this.cp.decryptData(this.cdp.readAsStream());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedData"));
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedData"), ex);
        }
        return this.cin;
    }

    public InputStream getCipherInputStream(Key key) throws XWSSecurityException {
        this.dataEncKey = key;
        return this.getCipherInputStream();
    }

    public XMLStreamReader getDecryptedData() throws XMLStreamException, XWSSecurityException {
        if (this.cin == null) {
            this.cin = this.getCipherInputStream();
        }
        if (logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream decryptedContent = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            try {
                int len = -1;
                while ((len = this.cin.read(buf)) != -1) {
                    decryptedContent.write(buf, 0, len);
                }
                logger.log(Level.FINEST, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1951_ENCRYPTED_DATA_VALUE(new String(decryptedContent.toByteArray())));
                this.cin = new ByteArrayInputStream(decryptedContent.toByteArray());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        CheckedInputStream ccin = null;
        try {
            ccin = new CheckedInputStream(this.cin);
            if (ccin.isEmpty()) {
                return null;
            }
        }
        catch (IOException ioe) {
            throw new XWSSecurityException(ioe);
        }
        DecryptedInputStream decryptedStream = new DecryptedInputStream(ccin, this.parentNS);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(decryptedStream);
        return new FilteredXMLStreamReader(reader);
    }

    public XMLStreamReader getDecryptedData(Key key) throws XMLStreamException, XWSSecurityException {
        if (this.cin == null) {
            this.cin = this.getCipherInputStream(key);
        }
        return this.getDecryptedData();
    }

    public byte[] getDecryptedMimeData(Key key) throws XWSSecurityException {
        this.dataEncKey = key;
        return this.getDecryptedMimeData();
    }

    public byte[] getDecryptedMimeData() throws XWSSecurityException {
        if (this.decryptedMimeData == null) {
            if (this.dataEncKey == null) {
                logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1926_ED_KEY_NOTSET());
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1926_ED_KEY_NOTSET(), null);
            }
            this.cp = new CryptoProcessor(2, this.encryptionMethod, this.dataEncKey);
            try {
                this.decryptedMimeData = this.cp.decryptData(this.cdp.readAsBytes());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedData"));
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedData"), ex);
            }
        }
        return this.decryptedMimeData;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) {
        throw new UnsupportedOperationException();
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == ENCRYPTION_METHOD) {
                return 2;
            }
            if (reader.getLocalName() == KEY_INFO) {
                return 1;
            }
            if (reader.getLocalName() == CIPHER_DATA) {
                return 5;
            }
        }
        return -1;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) {
        throw new UnsupportedOperationException();
    }

    public WSSPolicy getInferredKB() {
        return this.inferredKB;
    }

    public boolean hasCipherReference() {
        return this.hasCipherReference;
    }

    public String getAttachmentContentId() {
        return this.attachmentContentId;
    }

    public String getAttachmentContentType() {
        return this.attachmentContentType;
    }

    public String getAttachmentMimeType() {
        return this.mimeType;
    }
}

