/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.testing;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.testing.PacketFilter;
import jakarta.xml.ws.WebServiceFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
public final class PacketFilteringFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.ws.rm.runtime.testing.PacketFilteringFeature";
    private static final Logger LOGGER = Logger.getLogger(PacketFilteringFeature.class);
    private final List<Class<? extends PacketFilter>> filterClasses;

    public PacketFilteringFeature() {
        this.filterClasses = Collections.emptyList();
        this.enabled = true;
    }

    public PacketFilteringFeature(boolean enabled) {
        this.filterClasses = Collections.emptyList();
        this.enabled = enabled;
    }

    public PacketFilteringFeature(Class<? extends PacketFilter> ... filterClasses) {
        this(true, filterClasses);
    }

    @FeatureConstructor(value={"enabled", "filters"})
    public PacketFilteringFeature(boolean enabled, Class<? extends PacketFilter> ... filterClasses) {
        this.enabled = enabled;
        this.filterClasses = filterClasses != null && filterClasses.length > 0 ? Collections.unmodifiableList(Arrays.asList(filterClasses)) : Collections.emptyList();
    }

    @ManagedAttribute
    public String getID() {
        return ID;
    }

    List<PacketFilter> createFilters(RuntimeContext context) {
        ArrayList<PacketFilter> filters = new ArrayList<PacketFilter>(this.filterClasses.size());
        for (Class<? extends PacketFilter> filterClass : this.filterClasses) {
            try {
                PacketFilter filter = filterClass.newInstance();
                filter.configure(context);
                filters.add(filter);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOGGER.warning("Error instantiating packet filter of class [" + filterClass.getName() + "]", (Throwable)ex);
            }
        }
        return filters;
    }

    @ManagedAttribute
    boolean hasFilters() {
        return !this.filterClasses.isEmpty();
    }
}

