/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.oracle.webservices.api.databinding.WSDLResolver;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceAp;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsgenOptions;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.annotation.XmlAttribute;
import com.sun.xml.txw2.annotation.XmlElement;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.databinding.DatabindingConfig;
import com.sun.xml.ws.api.databinding.DatabindingFactory;
import com.sun.xml.ws.api.databinding.WSDLGenInfo;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.db.DatabindingImpl;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.ExternalMetadataReader;
import com.sun.xml.ws.util.ServiceFinder;
import jakarta.xml.ws.Holder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2Impl;

public class WsgenTool {
    private final PrintStream out;
    private final WsgenOptions options = new WsgenOptions();
    private final Container container;

    public WsgenTool(OutputStream out, Container container) {
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.container = container;
    }

    public WsgenTool(OutputStream out) {
        this(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] args) {
        Listener listener = new Listener();
        for (String arg : args) {
            if (arg.equals("-version")) {
                listener.message(WscompileMessages.WSGEN_VERSION(ToolVersion.VERSION.MAJOR_VERSION));
                return true;
            }
            if (!arg.equals("-fullversion")) continue;
            listener.message(WscompileMessages.WSGEN_FULLVERSION(ToolVersion.VERSION.toString()));
            return true;
        }
        try {
            this.options.parseArguments(args);
            this.options.validate();
            if (!this.buildModel(this.options.endpoint.getName(), listener)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Options.WeAreDone done) {
            this.usage(done.getOptions());
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            this.usage(e.getOptions());
            int n = 0;
            return n != 0;
        }
        catch (AbortException abortException) {
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    public boolean buildModel(String endpoint, final Listener listener) throws BadCommandLineException {
        final ErrorReceiverFilter errReceiver = new ErrorReceiverFilter(listener);
        if (!this.options.nosource) {
            JavaCompiler compiler;
            ArrayList<String> args = new ArrayList<String>(6 + (this.options.nocompile ? 1 : 0) + (this.options.encoding != null ? 2 : 0));
            args.add("-d");
            args.add(this.options.destDir.getAbsolutePath());
            args.add("-classpath");
            args.add(this.options.classpath);
            args.add("-s");
            args.add(this.options.sourceDir.getAbsolutePath());
            if (this.options.nocompile) {
                args.add("-proc:only");
            }
            if (this.options.encoding != null) {
                args.add("-encoding");
                args.add(this.options.encoding);
            }
            if (this.options.javacOptions != null) {
                args.addAll(this.options.getJavacOptions(args, listener));
            }
            if ((compiler = ToolProvider.getSystemJavaCompiler()) == null) {
                this.out.println(WscompileMessages.WSCOMPILE_CANT_GET_COMPILER(this.property("java.home"), this.property("java.version"), this.property("java.vendor")));
                return false;
            }
            DiagnosticListener<JavaFileObject> diagnostics = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    boolean fromFile = diagnostic.getSource() != null;
                    StringBuilder message = new StringBuilder();
                    if (fromFile) {
                        message.append(diagnostic.getSource().getName());
                    }
                    message.append(diagnostic.getMessage(Locale.getDefault()));
                    if (fromFile) {
                        message.append("");
                    }
                    switch (diagnostic.getKind()) {
                        case ERROR: {
                            Locator2Impl l = new Locator2Impl();
                            if (fromFile) {
                                l.setSystemId(diagnostic.getSource().getName());
                            } else {
                                l.setSystemId(null);
                            }
                            l.setLineNumber((int)diagnostic.getLineNumber());
                            l.setColumnNumber((int)diagnostic.getColumnNumber());
                            SAXParseException ex = new SAXParseException(message.toString(), l);
                            listener.error(ex);
                            break;
                        }
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            listener.message(message.toString());
                            break;
                        }
                        default: {
                            if (!WsgenTool.this.options.verbose) break;
                            listener.message(message.toString());
                        }
                    }
                }
            };
            StandardJavaFileManager fileManager = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnostics, null, null);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)diagnostics, args, Collections.singleton(endpoint.replaceAll("\\$", ".")), null);
            task.setProcessors(Collections.singleton(new WebServiceAp(this.options, this.out)));
            boolean result = task.call();
            if (!result) {
                this.out.println(WscompileMessages.WSCOMPILE_ERROR(WscompileMessages.WSCOMPILE_COMPILATION_FAILED()));
                return false;
            }
        }
        if (this.options.genWsdl) {
            Class<?> endpointClass;
            DatabindingConfig config = new DatabindingConfig();
            List<String> externalMetadataFileNames = this.options.externalMetadataFiles;
            boolean disableXmlSecurity = this.options.disableXmlSecurity;
            if (externalMetadataFileNames != null && externalMetadataFileNames.size() > 0) {
                config.setMetadataReader(new ExternalMetadataReader(this.getExternalFiles(externalMetadataFileNames), null, null, true, disableXmlSecurity));
            }
            String tmpPath = this.options.destDir.getAbsolutePath() + File.pathSeparator + this.options.classpath;
            URLClassLoader classLoader = new URLClassLoader(Options.pathToURLs(tmpPath), this.getClass().getClassLoader());
            try {
                endpointClass = classLoader.loadClass(endpoint);
            }
            catch (ClassNotFoundException e) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(endpoint));
            }
            BindingID bindingID = this.options.getBindingID(this.options.protocol);
            if (!this.options.protocolSet) {
                bindingID = BindingID.parse(endpointClass);
            }
            WebServiceFeatureList wsfeatures = new WebServiceFeatureList(endpointClass);
            if (this.options.portName != null) {
                config.getMappingInfo().setPortName(this.options.portName);
            }
            DatabindingFactory fac = DatabindingFactory.newInstance();
            config.setEndpointClass(endpointClass);
            config.getMappingInfo().setServiceName(this.options.serviceName);
            config.setFeatures(wsfeatures.toArray());
            config.setClassLoader(classLoader);
            config.getMappingInfo().setBindingID(bindingID);
            DatabindingImpl rt = (DatabindingImpl)fac.createRuntime(config);
            final File[] wsdlFileName = new File[1];
            final HashMap<String, File> schemaFiles = new HashMap<String, File>();
            WSDLGenInfo wsdlGenInfo = new WSDLGenInfo();
            wsdlGenInfo.setSecureXmlProcessingDisabled(disableXmlSecurity);
            wsdlGenInfo.setWsdlResolver(new WSDLResolver(){

                private File toFile(String suggestedFilename) {
                    return new File(WsgenTool.this.options.nonclassDestDir, suggestedFilename);
                }

                private Result toResult(File file) {
                    StreamResult result;
                    try {
                        result = new StreamResult(new FileOutputStream(file));
                        result.setSystemId(file.getPath().replace('\\', '/'));
                    }
                    catch (FileNotFoundException e) {
                        errReceiver.error(e);
                        return null;
                    }
                    return result;
                }

                @Override
                public Result getWSDL(String suggestedFilename) {
                    File f;
                    wsdlFileName[0] = f = this.toFile(suggestedFilename);
                    return this.toResult(f);
                }

                public Result getSchemaOutput(String namespace, String suggestedFilename) {
                    if (namespace == null) {
                        return null;
                    }
                    File f = this.toFile(suggestedFilename);
                    schemaFiles.put(namespace, f);
                    return this.toResult(f);
                }

                @Override
                public Result getAbstractWSDL(Holder<String> filename) {
                    return this.toResult(this.toFile((String)filename.value));
                }

                @Override
                public Result getSchemaOutput(String namespace, Holder<String> filename) {
                    return this.getSchemaOutput(namespace, (String)filename.value);
                }
            });
            wsdlGenInfo.setContainer(this.container);
            wsdlGenInfo.setExtensions(ServiceFinder.find(WSDLGeneratorExtension.class, ServiceLoader.load(WSDLGeneratorExtension.class)).toArray());
            wsdlGenInfo.setInlineSchemas(this.options.inlineSchemas);
            rt.generateWSDL(wsdlGenInfo);
            if (this.options.wsgenReport != null) {
                this.generateWsgenReport(endpointClass, (AbstractSEIModelImpl)rt.getModel(), wsdlFileName[0], schemaFiles);
            }
        }
        return true;
    }

    private String property(String key) {
        try {
            String property = System.getProperty(key);
            return property != null ? property : "UNKNOWN";
        }
        catch (SecurityException ignored) {
            return "UNKNOWN";
        }
    }

    private List<File> getExternalFiles(List<String> exts) {
        ArrayList<File> files = new ArrayList<File>();
        for (String ext : exts) {
            File file = new File(ext);
            if (!file.exists()) {
                file = new File(this.options.sourceDir.getAbsolutePath() + File.separator + ext);
            }
            files.add(file);
        }
        return files;
    }

    private void generateWsgenReport(Class<?> endpointClass, AbstractSEIModelImpl rtModel, File wsdlFile, Map<String, File> schemaFiles) {
        try {
            ReportOutput.Report report = (ReportOutput.Report)TXW.create(ReportOutput.Report.class, (XmlSerializer)new StreamSerializer((OutputStream)new BufferedOutputStream(new FileOutputStream(this.options.wsgenReport))));
            report.wsdl(wsdlFile.getAbsolutePath());
            ReportOutput.writeQName(rtModel.getServiceQName(), report.service());
            ReportOutput.writeQName(rtModel.getPortName(), report.port());
            ReportOutput.writeQName(rtModel.getPortTypeName(), report.portType());
            report.implClass(endpointClass.getName());
            for (Map.Entry<String, File> e : schemaFiles.entrySet()) {
                ReportOutput.Schema s = report.schema();
                s.ns(e.getKey());
                s.location(e.getValue().getAbsolutePath());
            }
            report.commit();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected void usage(Options options) {
        if (options == null) {
            options = this.options;
        }
        if (options instanceof WsgenOptions) {
            System.out.println(WscompileMessages.WSGEN_HELP("WSGEN", ((WsgenOptions)options).protocols, ((WsgenOptions)options).nonstdProtocols.keySet()));
            System.out.println(WscompileMessages.WSGEN_USAGE_EXTENSIONS());
            System.out.println(WscompileMessages.WSGEN_USAGE_EXAMPLES());
        }
    }

    class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        Listener() {
            this.cer = new ConsoleErrorReporter(WsgenTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsgenTool.this.out);
        }

        @Override
        public void generatedFile(String fileName) {
            this.message(fileName);
        }

        @Override
        public void message(String msg) {
            WsgenTool.this.out.println(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            this.cer.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.cer.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            this.cer.warning(exception);
        }

        @Override
        public void info(SAXParseException exception) {
            this.cer.info(exception);
        }
    }

    static class ReportOutput {
        ReportOutput() {
        }

        private static void writeQName(QName n, QualifiedName w) {
            w.uri(n.getNamespaceURI());
            w.localName(n.getLocalPart());
        }

        static interface QualifiedName
        extends TypedXmlWriter {
            @XmlAttribute
            public void uri(String var1);

            @XmlAttribute
            public void localName(String var1);
        }

        static interface Schema
        extends TypedXmlWriter {
            @XmlAttribute
            public void ns(String var1);

            @XmlAttribute
            public void location(String var1);
        }

        @XmlElement(value="report")
        static interface Report
        extends TypedXmlWriter {
            @XmlElement
            public void wsdl(String var1);

            @XmlElement
            public QualifiedName portType();

            @XmlElement
            public QualifiedName service();

            @XmlElement
            public QualifiedName port();

            @XmlElement
            public void implClass(String var1);

            @XmlElement
            public Schema schema();
        }
    }
}

