/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.WSITServerAuthContext;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class WSITServerAuthConfig
implements ServerAuthConfig {
    private String layer = null;
    private String appContext = null;
    private CallbackHandler callbackHandler = null;
    private WSITServerAuthContext serverAuthContext = null;
    private PolicyMap policyMap = null;
    private boolean secEnabled;
    private ReentrantReadWriteLock rwLock;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;

    public WSITServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) {
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAuthContext getAuthContext(String operation, Subject subject, Map rawMap) throws AuthException {
        PolicyMap pMap;
        Map map;
        block19: {
            map = rawMap;
            pMap = (PolicyMap)map.get("POLICY");
            WSDLPort port = (WSDLPort)map.get("WSDL_MODEL");
            if (pMap == null || pMap.isEmpty()) {
                return null;
            }
            try {
                this.rLock.lock();
                if (this.secEnabled && this.policyMap == pMap) break block19;
                this.rLock.unlock();
                this.wLock.lock();
                try {
                    if (!this.secEnabled || this.policyMap != pMap) {
                        if (!WSITAuthConfigProvider.isSecurityEnabled(pMap, port)) {
                            ServerAuthContext serverAuthContext = null;
                            return serverAuthContext;
                        }
                        this.secEnabled = true;
                    }
                }
                finally {
                    this.rLock.lock();
                    this.wLock.unlock();
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        this.rLock.lock();
        try {
            if (this.serverAuthContext != null && this.policyMap == pMap) {
                WSITServerAuthContext wSITServerAuthContext = this.serverAuthContext;
                return wSITServerAuthContext;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (this.serverAuthContext == null || this.policyMap != pMap) {
                this.serverAuthContext = new WSITServerAuthContext(operation, subject, map, this.callbackHandler);
                this.policyMap = pMap;
            }
            WSITServerAuthContext wSITServerAuthContext = this.serverAuthContext;
            return wSITServerAuthContext;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getOperation(MessageInfo messageInfo) {
        return null;
    }

    public void refresh() {
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    public boolean isProtected() {
        return true;
    }
}

