/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.client;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.mex.client.HttpPoster;
import com.sun.xml.ws.mex.client.MetadataClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataUtil {
    private final HttpPoster postClient = new HttpPoster();
    private static final Logger logger = Logger.getLogger(MetadataUtil.class.getName());

    InputStream getMetadata(String address, MetadataClient.Protocol protocol) throws IOException {
        String request = this.getMexWsdlRequest(address, protocol);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request message:\n" + request + "\n");
        }
        String contentType = "application/soap+xml";
        if (protocol == MetadataClient.Protocol.SOAP_1_1) {
            contentType = "text/xml; charset=\"utf-8\"";
        }
        return this.postClient.post(request, address, contentType);
    }

    private String getMexWsdlRequest(String address, MetadataClient.Protocol protocol) {
        String soapPrefix = "s12";
        String soapNamespace = "http://www.w3.org/2003/05/soap-envelope";
        if (protocol == MetadataClient.Protocol.SOAP_1_1) {
            soapPrefix = "soap-env";
            soapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        return "<" + soapPrefix + ":Envelope xmlns:" + soapPrefix + "='" + soapNamespace + "' xmlns:" + "wsa" + "='" + AddressingVersion.W3C.nsUri + "'><" + soapPrefix + ":Header><" + "wsa" + ":Action>" + "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get" + "</" + "wsa" + ":Action><" + "wsa" + ":To>" + address + "</" + "wsa" + ":To><" + "wsa" + ":ReplyTo><" + "wsa" + ":Address>" + "http://www.w3.org/2005/08/addressing/anonymous" + "</" + "wsa" + ":Address></" + "wsa" + ":ReplyTo><" + "wsa" + ":MessageID>uuid:778b135f-3fdf-44b2-b53e-ebaab7441e40</" + "wsa" + ":MessageID></" + soapPrefix + ":Header><" + soapPrefix + ":Body/></" + soapPrefix + ":Envelope>";
    }
}

