/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.IssuedTokens;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.elements.str.DirectReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenResponseCollectionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ActAsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.IssuedTokensImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenResponseCollectionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestSecurityTokenResponseImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedAttachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedProofTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedTokenCancelledImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RequestedUnattachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.SecondaryParametersImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.StatusImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ValidateTargetImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.TrustNamespacePrefixMapper;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSTrustElementFactoryImpl
extends WSTrustElementFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    @Override
    public RequestSecurityToken createRSTForIssue(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lt) throws WSTrustException {
        RequestSecurityTokenImpl rst = new RequestSecurityTokenImpl(tokenType, requestType, context, scopes, claims, entropy, lt, null);
        return rst;
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedReference, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) throws WSTrustException {
        return new RequestSecurityTokenResponseImpl(tokenType, context, token, scopes, attachedReference, unattachedReference, proofToken, entropy, lt, null);
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) throws WSTrustException {
        return new RequestSecurityTokenResponseCollectionImpl(tokenType, context, token, scopes, attached, unattached, proofToken, entropy, lt);
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(List rstrs) throws WSTrustException {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        for (int i = 0; i < rstrs.size(); ++i) {
            rstrc.addRequestSecurityTokenResponse((RequestSecurityTokenResponse)rstrs.get(i));
        }
        return rstrc;
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForRenew(URI tokenType, URI context, RequestedSecurityToken token, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, null, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    @Override
    public IssuedTokens createIssuedTokens(RequestSecurityTokenResponseCollection issuedTokens) {
        return new IssuedTokensImpl(issuedTokens);
    }

    @Override
    public Entropy createEntropy(BinarySecret secret) {
        return new EntropyImpl(secret);
    }

    @Override
    public Entropy createEntropy(EncryptedKey key) {
        return new EntropyImpl(key);
    }

    @Override
    public BinarySecret createBinarySecret(byte[] rawValue, String type) {
        return new BinarySecretImpl(rawValue, type);
    }

    @Override
    public BinarySecret createBinarySecret(Element elem) throws WSTrustException {
        return new BinarySecretImpl(BinarySecretImpl.fromElement(elem));
    }

    @Override
    public Claims createClaims(Element elem) throws WSTrustException {
        return new ClaimsImpl(ClaimsImpl.fromElement(elem));
    }

    @Override
    public Claims createClaims(Claims claims) throws WSTrustException {
        ClaimsImpl newClaims = new ClaimsImpl();
        if (claims != null) {
            newClaims.setDialect(claims.getDialect());
            newClaims.getAny().addAll(claims.getAny());
            newClaims.getOtherAttributes().putAll(claims.getOtherAttributes());
        }
        return newClaims;
    }

    @Override
    public Claims createClaims() throws WSTrustException {
        return new ClaimsImpl();
    }

    @Override
    public Status createStatus(String code, String reason) {
        return new StatusImpl(code, reason);
    }

    @Override
    public Lifetime createLifetime(AttributedDateTime created, AttributedDateTime expires) {
        return new LifetimeImpl(created, expires);
    }

    @Override
    public OnBehalfOf createOnBehalfOf(Token oboToken) {
        return new OnBehalfOfImpl(oboToken);
    }

    @Override
    public ActAs createActAs(Token actAsToken) {
        return new ActAsImpl(actAsToken);
    }

    @Override
    public RequestedSecurityToken createRequestedSecurityToken(Token token) {
        return new RequestedSecurityTokenImpl(token);
    }

    @Override
    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityTokenImpl();
    }

    @Override
    public DirectReference createDirectReference(String valueType, String uri) {
        return new DirectReferenceImpl(valueType, uri);
    }

    @Override
    public KeyIdentifier createKeyIdentifier(String valueType, String encodingType) {
        return new KeyIdentifierImpl(valueType, encodingType);
    }

    @Override
    public SecurityTokenReference createSecurityTokenReference(Reference ref) {
        return new SecurityTokenReferenceImpl(ref);
    }

    @Override
    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference str) {
        return new RequestedAttachedReferenceImpl(str);
    }

    @Override
    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference str) {
        return new RequestedUnattachedReferenceImpl(str);
    }

    @Override
    public RequestedProofToken createRequestedProofToken() {
        return new RequestedProofTokenImpl();
    }

    @Override
    public RequestSecurityToken createRSTForRenew(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        return new RequestSecurityTokenImpl(tokenType, requestType, context, target, apd, renewingInfo);
    }

    @Override
    public RenewTarget createRenewTarget(SecurityTokenReference str) {
        return new RenewTargetImpl(str);
    }

    @Override
    public CancelTarget createCancelTarget(SecurityTokenReference str) {
        return new CancelTargetImpl(str);
    }

    @Override
    public ValidateTarget createValidateTarget(Token token) {
        return new ValidateTargetImpl(token);
    }

    @Override
    public SecondaryParameters createSecondaryParameters() {
        return new SecondaryParametersImpl();
    }

    @Override
    public UseKey createUseKey(Token token, String sig) {
        UseKeyImpl useKey = new UseKeyImpl(token);
        if (sig != null) {
            useKey.setSignatureID(URI.create(sig));
        }
        return useKey;
    }

    @Override
    public RequestSecurityToken createRSTForCancel(URI requestType, CancelTarget target) {
        return new RequestSecurityTokenImpl(null, requestType, target);
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForCancel() {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl();
        rstr.setRequestedTokenCancelled(new RequestedTokenCancelledImpl());
        return rstr;
    }

    @Override
    public RequestSecurityToken createRSTForValidate(URI tokenType, URI requestType) {
        return new RequestSecurityTokenImpl(tokenType, requestType);
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForValidate(URI tokenType, RequestedSecurityToken token, Status status) {
        return new RequestSecurityTokenResponseImpl(tokenType, null, token, null, null, null, null, null, null, status);
    }

    @Override
    public RequestSecurityToken createRST() {
        return new RequestSecurityTokenImpl();
    }

    @Override
    public RequestSecurityTokenResponse createRSTR() {
        return new RequestSecurityTokenResponseImpl();
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRC(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        for (int i = 0; i < rstrs.size(); ++i) {
            rstrc.addRequestSecurityTokenResponse(rstrs.get(i));
        }
        return rstrc;
    }

    @Override
    public RequestSecurityToken createRSTFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal(src, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityToken createRSTFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal((Node)elem, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal(src, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstType = u.unmarshal((Node)elem, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal(src, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Element elem) {
        this.checkElement(elem);
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal((Node)elem, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityToken createRSTFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenType type = (RequestSecurityTokenType)elem.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RST from JAXBElement", e);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)elem.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RSTR from JAXBElement", e);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)elem.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating RSTRCollection from JAXBElement", e);
        }
    }

    public Object createResponseFrom(JAXBElement elem) {
        String local = elem.getName().getLocalPart();
        if (local.equalsIgnoreCase("RequestSecurityTokenResponseType")) {
            return this.createRSTRFrom(elem);
        }
        return this.createRSTRCollectionFrom(elem);
    }

    @Override
    public SecurityTokenReference createSecurityTokenReference(JAXBElement elem) {
        try {
            SecurityTokenReferenceType type = (SecurityTokenReferenceType)elem.getValue();
            return new SecurityTokenReferenceImpl(type);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem while creating STR from JAXBElement", e);
        }
    }

    @Override
    public SecurityContextToken createSecurityContextToken(URI identifier, String instance, String wsuId) {
        throw new UnsupportedOperationException("this operation is not supported");
    }

    @Override
    public JAXBElement toJAXBElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toJAXBElement((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public JAXBElement toJAXBElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toJAXBElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toJAXBElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public JAXBElement toJAXBElement(SecurityTokenReference str) {
        JAXBElement<SecurityTokenReferenceType> strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)((Object)str));
        return strElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityToken rst) {
        JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)((Object)rst));
        return rstElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityTokenResponse rstr) {
        JAXBElement<RequestSecurityTokenResponseType> rstElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
        return rstElement;
    }

    public JAXBElement toJAXBElement(Entropy entropy) {
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)((Object)entropy));
        return etElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityTokenResponseCollection rstrCollection) {
        JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)((Object)rstrCollection));
        return rstElement;
    }

    @Override
    public Source toSource(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toSource((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public Source toSource(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toSource((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toSource((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public Source toSource(RequestSecurityToken rst) {
        return new DOMSource(this.toElement(rst));
    }

    @Override
    public Source toSource(RequestSecurityTokenResponse rstr) {
        return new DOMSource(this.toElement(rstr));
    }

    @Override
    public Source toSource(RequestSecurityTokenResponseCollection rstrCollection) {
        return new DOMSource(this.toElement(rstrCollection));
    }

    @Override
    public Element toElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toElement((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public Element toElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public Element toElement(RequestSecurityToken rst) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)((Object)rst));
            this.getMarshaller().marshal(rstElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponse rstr) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponse rstr, Document doc) {
        try {
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)((Object)rstrCollection));
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(BinarySecret bs) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)bs));
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(SecurityTokenReference str, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<SecurityTokenReferenceType> strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)((Object)str));
            this.getMarshaller().marshal(strElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Element toElement(BinarySecret bs, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)bs));
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Marshaller getMarshaller() {
        try {
            Marshaller marshaller = WSTrustElementFactoryImpl.getContext(WSTrustVersion.WS_TRUST_13).createMarshaller();
            marshaller.setProperty("org.glassfish.jaxb.runtime.marshaller.namespacePrefixMapper", (Object)new TrustNamespacePrefixMapper());
            return marshaller;
        }
        catch (PropertyException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
        }
        catch (JAXBException jbe) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
        }
    }

    private void checkElement(Element elem) {
        if (elem != null && elem.getLocalName().equalsIgnoreCase("Fault")) {
            try {
                QName qname = null;
                Map faultMap = null;
                LinkedHashSet<String> subcodeValues = new LinkedHashSet<String>();
                if (elem.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    faultMap = this.getFaultCodeAndReasonForSOAP1_1(elem);
                    String codeText = (String)faultMap.get("CodeText");
                    String reasonText = (String)faultMap.get("ReasonText");
                    codeText = codeText.substring(codeText.indexOf(":") + 1);
                    qname = new QName("http://schemas.xmlsoap.org/soap/envelope/", codeText);
                    throw new SOAPFaultException(SOAPFactory.newInstance((String)"SOAP 1.1 Protocol").createFault(reasonText, qname));
                }
                if (elem.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                    faultMap = this.getFaultCodeAndReasonForSOAP1_2(elem, "Code", subcodeValues);
                    String codeText = (String)faultMap.get("CodeText");
                    String reasonText = (String)faultMap.get("ReasonText");
                    codeText = codeText.substring(codeText.indexOf(":") + 1);
                    qname = new QName("http://www.w3.org/2003/05/soap-envelope", codeText);
                    SOAPFault fault = SOAPFactory.newInstance((String)"SOAP 1.2 Protocol").createFault(reasonText, qname);
                    ArrayList<String> subcodesList = new ArrayList<String>(subcodeValues);
                    Collections.reverse(subcodesList);
                    if (!subcodesList.isEmpty()) {
                        for (String subCodeValue : subcodesList) {
                            subCodeValue = subCodeValue.substring(subCodeValue.indexOf(":") + 1);
                            QName subcodeqname = new QName("http://www.w3.org/2003/05/soap-envelope", subCodeValue);
                            fault.appendFaultSubcode(subcodeqname);
                        }
                    }
                    throw new SOAPFaultException(fault);
                }
            }
            catch (SOAPException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
    }

    private Map getFaultCodeAndReasonForSOAP1_1(Element elem) {
        HashMap<String, String> faultMap = new HashMap<String, String>(2);
        Object reasonNode = null;
        String reasonText = null;
        String codeText = null;
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) continue;
            if ("faultcode".equals(node.getLocalName())) {
                codeText = node.getTextContent();
                continue;
            }
            if (!"faultstring".equals(node.getLocalName())) continue;
            reasonText = node.getTextContent();
        }
        faultMap.put("CodeText", codeText);
        faultMap.put("ReasonText", reasonText);
        return faultMap;
    }

    private Map getFaultCodeAndReasonForSOAP1_2(Element elem, String codeString, Set<String> subcodeValues) {
        HashMap<String, String> faultMap = new HashMap<String, String>();
        Node reasonNode = null;
        String reasonText = null;
        Node codeNode = null;
        String codeText = null;
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node subNode;
            int j;
            NodeList subNodes;
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) continue;
            if (codeString.equals(node.getLocalName())) {
                codeNode = node;
                subNodes = codeNode.getChildNodes();
                for (j = 0; j < subNodes.getLength(); ++j) {
                    subNode = subNodes.item(j);
                    if (subNode.getNodeType() == 3) continue;
                    if ("Value".equals(subNode.getLocalName())) {
                        codeText = subNode.getTextContent();
                    }
                    if (!"Subcode".equals(subNode.getLocalName())) continue;
                    Map subcodeMap = this.getFaultCodeAndReasonForSOAP1_2((Element)node, "Subcode", subcodeValues);
                    subcodeValues.add((String)subcodeMap.get("CodeText"));
                }
                continue;
            }
            if (!"Reason".equals(node.getLocalName())) continue;
            reasonNode = node;
            subNodes = reasonNode.getChildNodes();
            for (j = 0; j < subNodes.getLength(); ++j) {
                subNode = subNodes.item(j);
                if (subNode.getNodeType() == 3 || !"Text".equals(subNode.getLocalName())) continue;
                reasonText = subNode.getTextContent();
            }
        }
        faultMap.put("CodeText", codeText);
        faultMap.put("ReasonText", reasonText);
        return faultMap;
    }
}

