/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.tools.ws.api.WsgenExtension;
import com.sun.tools.ws.api.WsgenProtocol;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.Options;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.util.ServiceFinder;
import jakarta.jws.WebService;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WsgenOptions
extends Options {
    public QName serviceName;
    public QName portName;
    public File nonclassDestDir;
    public boolean genWsdl;
    public boolean inlineSchemas;
    public String protocol = "soap1.1";
    public Set<String> protocols = new LinkedHashSet<String>();
    public Map<String, String> nonstdProtocols = new LinkedHashMap<String, String>();
    public File wsgenReport;
    public boolean doNotOverWrite;
    public boolean protocolSet = false;
    public List<String> externalMetadataFiles = new ArrayList<String>();
    private static final String SERVICENAME_OPTION = "-servicename";
    private static final String PORTNAME_OPTION = "-portname";
    private static final String HTTP = "http";
    private static final String SOAP11 = "soap1.1";
    public static final String X_SOAP12 = "Xsoap1.2";
    List<String> endpoints = new ArrayList<String>();
    public Class endpoint;
    private boolean isImplClass;

    public WsgenOptions() {
        this.protocols.add(SOAP11);
        this.protocols.add(X_SOAP12);
        this.nonstdProtocols.put(X_SOAP12, "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/");
        ServiceFinder<WsgenExtension> extn = ServiceFinder.find(WsgenExtension.class);
        for (WsgenExtension ext : extn) {
            Class<?> clazz = ext.getClass();
            WsgenProtocol pro = clazz.getAnnotation(WsgenProtocol.class);
            this.protocols.add(pro.token());
            this.nonstdProtocols.put(pro.token(), pro.lexical());
        }
    }

    @Override
    protected int parseArguments(String[] args, int i) throws BadCommandLineException {
        int j = super.parseArguments(args, i);
        if (args[i].equals(SERVICENAME_OPTION)) {
            this.serviceName = QName.valueOf(this.requireArgument(SERVICENAME_OPTION, args, ++i));
            if (this.serviceName.getNamespaceURI() == null || this.serviceName.getNamespaceURI().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_SERVICENAME_MISSING_NAMESPACE(args[i]));
            }
            if (this.serviceName.getLocalPart() == null || this.serviceName.getLocalPart().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_SERVICENAME_MISSING_LOCALNAME(args[i]));
            }
            return 2;
        }
        if (args[i].equals(PORTNAME_OPTION)) {
            this.portName = QName.valueOf(this.requireArgument(PORTNAME_OPTION, args, ++i));
            if (this.portName.getNamespaceURI() == null || this.portName.getNamespaceURI().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_PORTNAME_MISSING_NAMESPACE(args[i]));
            }
            if (this.portName.getLocalPart() == null || this.portName.getLocalPart().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_PORTNAME_MISSING_LOCALNAME(args[i]));
            }
            return 2;
        }
        if (args[i].equals("-r")) {
            this.nonclassDestDir = new File(this.requireArgument("-r", args, ++i));
            if (!this.nonclassDestDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.nonclassDestDir.getPath()));
            }
            return 2;
        }
        if (args[i].startsWith("-wsdl")) {
            this.genWsdl = true;
            String value = args[i].substring(5);
            int index = value.indexOf(58);
            if (index == 0) {
                index = (value = value.substring(1)).indexOf(47);
                this.protocol = index == -1 ? value : value.substring(0, index);
                this.protocolSet = true;
            }
            return 1;
        }
        if (args[i].equals("-XwsgenReport")) {
            this.wsgenReport = new File(this.requireArgument("-XwsgenReport", args, ++i));
            return 2;
        }
        if (args[i].equals("-Xdonotoverwrite")) {
            this.doNotOverWrite = true;
            return 1;
        }
        if (args[i].equals("-inlineSchemas")) {
            this.inlineSchemas = true;
            return 1;
        }
        if ("-x".equals(args[i])) {
            this.externalMetadataFiles.add(this.requireArgument("-x", args, ++i));
            return 1;
        }
        return j;
    }

    @Override
    protected void addFile(String arg) {
        this.endpoints.add(arg);
    }

    public void validate() throws BadCommandLineException {
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        if (!this.protocols.contains(this.protocol)) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_INVALID_PROTOCOL(this.protocol, this.protocols));
        }
        if (this.endpoints.isEmpty()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_MISSING_FILE());
        }
        if (this.protocol == null || this.protocol.equalsIgnoreCase(X_SOAP12) && !this.isExtensionMode()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_SOAP_12_WITHOUT_EXTENSION());
        }
        if (this.nonstdProtocols.containsKey(this.protocol) && !this.isExtensionMode()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_PROTOCOL_WITHOUT_EXTENSION(this.protocol));
        }
        if (this.inlineSchemas && !this.genWsdl) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_INLINE_SCHEMAS_ONLY_WITH_WSDL());
        }
        this.validateEndpointClass();
        this.validateArguments();
    }

    private void validateEndpointClass() throws BadCommandLineException {
        Class clazz = null;
        for (String cls : this.endpoints) {
            clazz = this.getClass(cls);
            if (clazz == null || clazz.isEnum() || clazz.isInterface() || clazz.isPrimitive()) continue;
            this.isImplClass = true;
            WebService webService = clazz.getAnnotation(WebService.class);
            if (webService == null) continue;
        }
        if (clazz == null) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(this.endpoints.get(0)));
        }
        if (!this.isImplClass) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_MUST_BE_IMPLEMENTATION_CLASS(clazz.getName()));
        }
        this.endpoint = clazz;
        this.validateBinding();
    }

    private void validateBinding() throws BadCommandLineException {
        if (this.genWsdl) {
            BindingID binding = BindingID.parse(this.endpoint);
            if (!(!binding.equals(BindingID.SOAP12_HTTP) && !binding.equals(BindingID.SOAP12_HTTP_MTOM) || this.protocol.equals(X_SOAP12) && this.isExtensionMode())) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CANNOT_GEN_WSDL_FOR_SOAP_12_BINDING(binding.toString(), this.endpoint.getName()));
            }
            if (binding.equals(BindingID.XML_HTTP)) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CANNOT_GEN_WSDL_FOR_NON_SOAP_BINDING(binding.toString(), this.endpoint.getName()));
            }
        }
    }

    private void validateArguments() throws BadCommandLineException {
        if (!this.genWsdl) {
            if (this.serviceName != null) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_WSDL_ARG_NO_GENWSDL(SERVICENAME_OPTION));
            }
            if (this.portName != null) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_WSDL_ARG_NO_GENWSDL(PORTNAME_OPTION));
            }
        }
    }

    BindingID getBindingID(String protocol) {
        if (protocol.equals(SOAP11)) {
            return BindingID.SOAP11_HTTP;
        }
        if (protocol.equals(X_SOAP12)) {
            return BindingID.SOAP12_HTTP;
        }
        String lexical = this.nonstdProtocols.get(protocol);
        return lexical != null ? BindingID.parse(lexical) : null;
    }

    private Class getClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

