/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.tools.ws.Invoker;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.processing.Filer;

public class Options {
    public boolean verbose;
    public boolean quiet;
    public boolean keep;
    public File destDir = new File(".");
    public File sourceDir;
    public Filer filer;
    public String encoding;
    public String classpath = System.getProperty("java.class.path");
    public boolean nocompile;
    public boolean disableSecureXmlProcessing = false;
    public Target target = Target.V2_2;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    public boolean debug = false;
    public boolean debugMode = false;
    private final List<File> generatedFiles = new ArrayList<File>();
    private ClassLoader classLoader;

    public boolean isExtensionMode() {
        return this.compatibilityMode == 2;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public void removeGeneratedFiles() {
        for (File file : this.generatedFiles) {
            if (!file.getName().endsWith(".java")) continue;
            boolean deleted = file.delete();
            if (!this.verbose || deleted) continue;
            System.out.println(MessageFormat.format("{0} could not be deleted.", file));
        }
        this.generatedFiles.clear();
    }

    public Iterable<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        List<File> list = this.generatedFiles;
        synchronized (list) {
            for (File file : this.generatedFiles) {
                if (!file.getName().endsWith(".java")) continue;
                boolean deleted = file.delete();
                if (!this.verbose || deleted) continue;
                System.out.println(MessageFormat.format("{0} could not be deleted.", file));
            }
            this.generatedFiles.clear();
        }
    }

    public void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArguments(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(args[i]));
                }
                i += j - 1;
                continue;
            }
            this.addFile(args[i]);
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
    }

    protected void addFile(String arg) throws BadCommandLineException {
    }

    protected int parseArguments(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-g")) {
            this.debug = true;
            return 1;
        }
        if (args[i].equals("-Xdebug")) {
            this.debugMode = true;
            return 1;
        }
        if (args[i].equals("-Xendorsed")) {
            return 1;
        }
        if (args[i].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (args[i].equals("-keep")) {
            this.keep = true;
            return 1;
        }
        if (args[i].equals("-target")) {
            String token = this.requireArgument("-target", args, ++i);
            this.target = Target.parse(token);
            if (this.target == null) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_ILLEGAL_TARGET_VERSION(token));
            }
            return 2;
        }
        if (args[i].equals("-classpath") || args[i].equals("-cp")) {
            this.classpath = this.requireArgument("-classpath", args, ++i) + File.pathSeparator + System.getProperty("java.class.path");
            return 2;
        }
        if (args[i].equals("-d")) {
            this.destDir = new File(this.requireArgument("-d", args, ++i));
            if (!this.destDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.destDir.getPath()));
            }
            return 2;
        }
        if (args[i].equals("-s")) {
            this.sourceDir = new File(this.requireArgument("-s", args, ++i));
            this.keep = true;
            if (!this.sourceDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.sourceDir.getPath()));
            }
            return 2;
        }
        if (args[i].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (args[i].startsWith("-help")) {
            WeAreDone done = new WeAreDone();
            done.initOptions(this);
            throw done;
        }
        if (args[i].equals("-Xnocompile")) {
            this.nocompile = true;
            this.keep = true;
            return 1;
        }
        if (args[i].equals("-encoding")) {
            this.encoding = this.requireArgument("-encoding", args, ++i);
            try {
                if (!Charset.isSupported(this.encoding)) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_UNSUPPORTED_ENCODING(this.encoding));
                }
            }
            catch (IllegalCharsetNameException icne) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_UNSUPPORTED_ENCODING(this.encoding));
            }
            return 2;
        }
        if (args[i].equals("-XdisableSecureXmlProcessing")) {
            this.disableSecureXmlProcessing = true;
            return 1;
        }
        return 0;
    }

    public String requireArgument(String optionName, String[] args, int i) throws BadCommandLineException {
        if (args[i].startsWith("-")) {
            throw new BadCommandLineException(WscompileMessages.WSCOMPILE_MISSING_OPTION_ARGUMENT(optionName));
        }
        return args[i];
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(Options.pathToURLs(this.classpath), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = Options.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public static final class WeAreDone
    extends BadCommandLineException {
    }

    public static enum Target {
        V2_0,
        V2_1,
        V2_2;

        private static final Target LOADED_API_VERSION;

        public boolean isLaterThan(Target t) {
            return this.ordinal() >= t.ordinal();
        }

        public static Target parse(String token) {
            if (token.equals("2.0")) {
                return V2_0;
            }
            if (token.equals("2.1")) {
                return V2_1;
            }
            if (token.equals("2.2")) {
                return V2_2;
            }
            return null;
        }

        public String getVersion() {
            switch (this) {
                case V2_0: {
                    return "2.0";
                }
                case V2_1: {
                    return "2.1";
                }
                case V2_2: {
                    return "2.2";
                }
            }
            return null;
        }

        public static Target getDefault() {
            return V2_2;
        }

        public static Target getLoadedAPIVersion() {
            return LOADED_API_VERSION;
        }

        static {
            LOADED_API_VERSION = Invoker.checkIfLoading22API() ? V2_2 : (Invoker.checkIfLoading21API() ? V2_1 : V2_0);
        }
    }
}

