/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.ws.security.impl.PasswordDerivedKey;
import com.sun.xml.ws.security.secext10.AttributedString;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.UsernameToken;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UsernameTokenDataResolver {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static AuthenticationTokenPolicy.UsernameTokenBinding setSaltandIterationsforUsernameToken(FilterProcessingContext context, com.sun.xml.ws.security.opt.impl.tokens.UsernameToken unToken, SignaturePolicy policy, AuthenticationTokenPolicy.UsernameTokenBinding untBinding, int firstByte) throws XWSSecurityException, UnsupportedEncodingException {
        int iterations = context.getiterationsForPDK() != 0 ? context.getiterationsForPDK() : 1000;
        if (iterations < 1000) {
            iterations = 1000;
        }
        byte[] macSignature = null;
        PasswordDerivedKey pdk = new PasswordDerivedKey();
        String userName = unToken.getUsernameValue();
        if (userName == null || "".equals(userName)) {
            userName = context.getSecurityEnvironment().getUsername(context.getExtraneousProperties());
        }
        if (userName == null || "".equals(userName)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1409_INVALID_USERNAME_TOKEN());
            throw new XWSSecurityException("Username has not been set");
        }
        unToken.setUsernameValue(userName);
        String password = untBinding.getPassword();
        if (!untBinding.hasNoPassword() && (password == null || "".equals(password))) {
            password = context.getSecurityEnvironment().getPassword(context.getExtraneousProperties());
        }
        if (!untBinding.hasNoPassword() && password == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1424_INVALID_USERNAME_TOKEN());
            throw new XWSSecurityException("Password for the username has not been set");
        }
        AttributedString as = new AttributedString();
        String iterate = Integer.toString(iterations);
        as.setValue(iterate);
        unToken.setIteration(as);
        byte[] salt = null;
        if (unToken.getSalt() == null) {
            salt = pdk.get16ByteSalt();
            AttributedString aString = new AttributedString();
            aString.setValue(Base64.encode(salt));
            unToken.setSalt(aString);
        } else {
            String decodeString = unToken.getSalt().getValue();
            String iter = unToken.getIteration().getValue();
            iterations = Integer.parseInt(iter);
            try {
                salt = Base64.decode(decodeString);
            }
            catch (Base64DecodingException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1426_BASE_64_DECODING_ERROR(), ex);
                throw new UnsupportedEncodingException("error while decoding the salt in username token");
            }
        }
        salt[0] = (byte)firstByte;
        try {
            macSignature = pdk.generate160BitKey(password, iterations, salt);
        }
        catch (UnsupportedEncodingException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1425_UNSUPPORTED_ENCODING(), ex);
            throw new UnsupportedEncodingException("error while creating 160 bit key");
        }
        untBinding.setSecretKey(macSignature);
        return untBinding;
    }

    public static AuthenticationTokenPolicy.UsernameTokenBinding setSaltandIterationsforUsernameToken(FilterProcessingContext context, com.sun.xml.ws.security.opt.impl.tokens.UsernameToken unToken, EncryptionPolicy policy, AuthenticationTokenPolicy.UsernameTokenBinding untBinding) throws XWSSecurityException, UnsupportedEncodingException {
        int iterations = context.getiterationsForPDK() != 0 ? context.getiterationsForPDK() : 1000;
        if (iterations < 1000) {
            iterations = 1000;
        }
        byte[] keyof128bits = new byte[16];
        byte[] encSignature = null;
        String userName = unToken.getUsernameValue();
        if (userName == null || "".equals(userName)) {
            userName = context.getSecurityEnvironment().getUsername(context.getExtraneousProperties());
        }
        if (userName == null || "".equals(userName)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1409_INVALID_USERNAME_TOKEN());
            throw new XWSSecurityException("Username has not been set");
        }
        unToken.setUsernameValue(userName);
        String password = untBinding.getPassword();
        if (!untBinding.hasNoPassword() && (password == null || "".equals(password))) {
            password = context.getSecurityEnvironment().getPassword(context.getExtraneousProperties());
        }
        if (!untBinding.hasNoPassword() && password == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1424_INVALID_USERNAME_TOKEN());
            throw new XWSSecurityException("Password for the username has not been set");
        }
        AttributedString as = new AttributedString();
        String iterate = Integer.toString(iterations);
        as.setValue(iterate);
        unToken.setIteration(as);
        PasswordDerivedKey pdk = new PasswordDerivedKey();
        byte[] salt = null;
        if (unToken.getSalt() == null) {
            salt = pdk.get16ByteSalt();
            AttributedString atbs = new AttributedString();
            atbs.setValue(Base64.encode(salt));
            unToken.setSalt(atbs);
        } else {
            String decodeString = unToken.getSalt().getValue();
            String iter = unToken.getIteration().getValue();
            iterations = Integer.parseInt(iter);
            try {
                salt = Base64.decode(decodeString);
            }
            catch (Base64DecodingException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1426_BASE_64_DECODING_ERROR(), ex);
                throw new UnsupportedEncodingException("error while decoding the salt in username token");
            }
        }
        salt[0] = 2;
        try {
            encSignature = pdk.generate160BitKey(password, iterations, salt);
        }
        catch (UnsupportedEncodingException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1425_UNSUPPORTED_ENCODING(), ex);
            throw new UnsupportedEncodingException("error while creating 128 bit key");
        }
        for (int i = 0; i < 16; ++i) {
            keyof128bits[i] = encSignature[i];
        }
        untBinding.setSecretKey(keyof128bits);
        return untBinding;
    }

    public static AuthenticationTokenPolicy.UsernameTokenBinding resolveUsernameToken(FilterProcessingContext context, UsernameToken token, com.sun.xml.ws.security.opt.impl.tokens.UsernameToken unToken, AuthenticationTokenPolicy policy) throws XWSSecurityException {
        AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
        String userName = userNamePolicy.getUsername();
        String password = userNamePolicy.getPassword();
        if (userName == null || "".equals(userName)) {
            userName = context.getSecurityEnvironment().getUsername(context.getExtraneousProperties());
        }
        if (userName == null || "".equals(userName)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1409_INVALID_USERNAME_TOKEN());
            throw new XWSSecurityException("Username has not been set");
        }
        if (token != null) {
            token.setUsername(userName);
        } else {
            unToken.setUsernameValue(userName);
        }
        if (!userNamePolicy.hasNoPassword() && (password == null || "".equals(password))) {
            password = context.getSecurityEnvironment().getPassword(context.getExtraneousProperties());
        }
        if (!userNamePolicy.hasNoPassword()) {
            if (password == null) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1424_INVALID_USERNAME_TOKEN());
                throw new XWSSecurityException("Password for the username has not been set");
            }
            if (token != null) {
                token.setPassword(password);
            } else {
                unToken.setPasswordValue(password);
            }
        }
        return userNamePolicy;
    }
}

