/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.ComponentRegistry;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.ManagedEndpointFactory;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.server.EndpointAwareTube;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.OperationDispatcher;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import org.glassfish.gmbal.ManagedObjectManager;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public abstract class WSEndpoint<T>
implements ComponentRegistry {
    @NotNull
    public abstract Codec createCodec();

    @NotNull
    public abstract QName getServiceName();

    @NotNull
    public abstract QName getPortName();

    @NotNull
    public abstract Class<T> getImplementationClass();

    @NotNull
    public abstract WSBinding getBinding();

    @NotNull
    public abstract Container getContainer();

    @Nullable
    public abstract WSDLPort getPort();

    public abstract void setExecutor(@NotNull Executor var1);

    public final void schedule(@NotNull Packet request, @NotNull CompletionCallback callback) {
        this.schedule(request, callback, null);
    }

    public abstract void schedule(@NotNull Packet var1, @NotNull CompletionCallback var2, @Nullable FiberContextSwitchInterceptor var3);

    public void process(@NotNull Packet request, @NotNull CompletionCallback callback, @Nullable FiberContextSwitchInterceptor interceptor) {
        this.schedule(request, callback, interceptor);
    }

    public Engine getEngine() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract PipeHead createPipeHead();

    public abstract void dispose();

    @Nullable
    public abstract ServiceDefinition getServiceDefinition();

    public List<BoundEndpoint> getBoundEndpoints() {
        Module m = this.getContainer().getSPI(Module.class);
        return m != null ? m.getBoundEndpoints() : null;
    }

    @NotNull
    public abstract Set<EndpointComponent> getComponentRegistry();

    @Override
    @NotNull
    public Set<Component> getComponents() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public <S> S getSPI(@NotNull Class<S> spiType) {
        Set<Component> componentRegistry = this.getComponents();
        if (componentRegistry != null) {
            for (Component c : componentRegistry) {
                S s = c.getSPI(spiType);
                if (s == null) continue;
                return s;
            }
        }
        return this.getContainer().getSPI(spiType);
    }

    @Nullable
    public abstract SEIModel getSEIModel();

    public abstract PolicyMap getPolicyMap();

    @NotNull
    public abstract ManagedObjectManager getManagedObjectManager();

    public abstract void closeManagedObjectManager();

    @NotNull
    public abstract ServerTubeAssemblerContext getAssemblerContext();

    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable EntityResolver resolver, boolean isTransportSynchronous) {
        return WSEndpoint.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous, true);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable EntityResolver resolver, boolean isTransportSynchronous, boolean isStandard) {
        WSEndpoint<T> endpoint = EndpointFactory.createEndpoint(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous, isStandard);
        Iterator<ManagedEndpointFactory> managementFactories = ServiceFinder.find(ManagedEndpointFactory.class).iterator();
        if (managementFactories.hasNext()) {
            ManagedEndpointFactory managementFactory = managementFactories.next();
            EndpointCreationAttributes attributes = new EndpointCreationAttributes(processHandlerAnnotation, invoker, resolver, isTransportSynchronous);
            WSEndpoint<T> managedEndpoint = managementFactory.createEndpoint(endpoint, attributes);
            if (endpoint.getAssemblerContext().getTerminalTube() instanceof EndpointAwareTube) {
                ((EndpointAwareTube)endpoint.getAssemblerContext().getTerminalTube()).setEndpoint(managedEndpoint);
            }
            return managedEndpoint;
        }
        return endpoint;
    }

    @Deprecated
    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable EntityResolver resolver) {
        return WSEndpoint.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, false);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable URL catalogUrl) {
        return WSEndpoint.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, XmlUtil.createEntityResolver(catalogUrl), false);
    }

    @NotNull
    public static QName getDefaultServiceName(Class endpointClass) {
        return WSEndpoint.getDefaultServiceName(endpointClass, true);
    }

    @NotNull
    public static QName getDefaultServiceName(Class endpointClass, boolean isStandard) {
        return EndpointFactory.getDefaultServiceName(endpointClass, isStandard);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName serviceName, Class endpointClass) {
        return WSEndpoint.getDefaultPortName(serviceName, endpointClass, true);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName serviceName, Class endpointClass, boolean isStandard) {
        return EndpointFactory.getDefaultPortName(serviceName, endpointClass, isStandard);
    }

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> var1, String var2, String var3, Element ... var4);

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> var1, String var2, String var3, List<Element> var4, List<Element> var5);

    public boolean equalsProxiedInstance(WSEndpoint endpoint) {
        if (endpoint == null) {
            return false;
        }
        return this.equals(endpoint);
    }

    @Nullable
    public abstract OperationDispatcher getOperationDispatcher();

    public static interface PipeHead {
        @NotNull
        public Packet process(@NotNull Packet var1, @Nullable WebServiceContextDelegate var2, @Nullable TransportBackChannel var3);
    }

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);
    }
}

