/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.xml.ws.api.server.LazyMOMProvider;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.MOMRegistrationAware;
import java.util.Map;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEndpointCollectionBasedMOMListener<T extends MOMRegistrationAware>
implements LazyMOMProvider.DefaultScopeChangeListener {
    private final Object lock;
    private final Map<WSEndpoint, T> registrationAwareMap;
    private final String registrationName;
    private LazyMOMProvider.Scope lazyMOMProviderScope = LazyMOMProvider.Scope.STANDALONE;

    public WSEndpointCollectionBasedMOMListener(String registrationName, Map<WSEndpoint, T> registrationAwareMap) {
        this(new Object(), registrationName, registrationAwareMap);
    }

    public WSEndpointCollectionBasedMOMListener(Object lock, String registrationName, Map<WSEndpoint, T> registrationAwareMap) {
        this.lock = lock;
        this.registrationName = registrationName;
        this.registrationAwareMap = registrationAwareMap;
    }

    public void initialize() {
        LazyMOMProvider.INSTANCE.registerListener(this);
    }

    public boolean canRegisterAtMOM() {
        return this.lazyMOMProviderScope != LazyMOMProvider.Scope.GLASSFISH_NO_JMX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerObjectsAtMOM() {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<WSEndpoint, T> entry : this.registrationAwareMap.entrySet()) {
                this.registerAtMOM((MOMRegistrationAware)entry.getValue(), entry.getKey());
            }
        }
    }

    public void registerAtMOM(MOMRegistrationAware momRegistrationAware, WSEndpoint wsEndpoint) {
        this.registerAtMOM(momRegistrationAware, wsEndpoint.getManagedObjectManager());
    }

    public void registerAtMOM(MOMRegistrationAware momRegistrationAware, ManagedObjectManager managedObjectManager) {
        if (!momRegistrationAware.isRegisteredAtMOM()) {
            managedObjectManager.registerAtRoot((Object)momRegistrationAware, this.registrationName);
            momRegistrationAware.setRegisteredAtMOM(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scopeChanged(LazyMOMProvider.Scope scope) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lazyMOMProviderScope == scope) {
                return;
            }
            this.lazyMOMProviderScope = scope;
        }
        switch (scope) {
            case GLASSFISH_JMX: {
                this.registerObjectsAtMOM();
                break;
            }
            case GLASSFISH_NO_JMX: {
                this.unregisterObjectsFromMOM();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterObjectsFromMOM() {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<WSEndpoint, T> entry : this.registrationAwareMap.entrySet()) {
                if (!((MOMRegistrationAware)entry.getValue()).isRegisteredAtMOM()) continue;
                this.unregisterFromMOM((MOMRegistrationAware)entry.getValue(), entry.getKey());
            }
        }
    }

    public void unregisterFromMOM(MOMRegistrationAware momRegistrationAware, ManagedObjectManager managedObjectManager) {
        managedObjectManager.unregister((Object)momRegistrationAware);
        momRegistrationAware.setRegisteredAtMOM(false);
    }

    public void unregisterFromMOM(MOMRegistrationAware momRegistrationAware, WSEndpoint wsEndpoint) {
        this.registerAtMOM(momRegistrationAware, wsEndpoint.getManagedObjectManager());
    }
}

