/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.impl.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BinaryExchangeImpl
extends BinaryExchangeType
implements BinaryExchange {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public BinaryExchangeImpl(String encodingType, String valueType, byte[] rawText) {
        this.setEncodingType(encodingType);
        this.setValueType(valueType);
        this.setRawValue(rawText);
    }

    public BinaryExchangeImpl(BinaryExchangeType bcType) throws RuntimeException {
        this.setEncodingType(bcType.getEncodingType());
        this.setValueType(bcType.getValueType());
        this.setValue(bcType.getValue());
    }

    public byte[] getRawValue() {
        try {
            return Base64.decode(this.getTextValue());
        }
        catch (Base64DecodingException de) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0020_ERROR_DECODING(this.getTextValue()), de);
            throw new RuntimeException(LogStringsMessages.WST_0020_ERROR_DECODING(this.getTextValue()), de);
        }
    }

    public String getTextValue() {
        return super.getValue();
    }

    public void setTextValue(@NotNull String encodedText) {
        super.setValue(encodedText);
    }

    public final void setRawValue(@NotNull byte[] rawText) {
        super.setValue(Base64.encode(rawText));
    }
}

