/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.apt.Main;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

@Deprecated
public class Apt
extends Task {
    protected Path compileClasspath = null;
    private File destDir = null;
    private File sourceDestDir;
    protected List<Option> options = new ArrayList<Option>();
    protected List<Jvmarg> jvmargs = new ArrayList<Jvmarg>();
    private boolean noCompile = false;
    private boolean print = false;
    private File factoryPath = null;
    private String factory = null;
    private boolean xListAnnotationTypes = false;
    private boolean xListDeclarations = false;
    private boolean xPrintAptRounds = false;
    private boolean xPrintFactoryInfo = false;
    private boolean xClassesAsDecls = false;
    protected boolean debug = false;
    protected String debugLevel = null;
    protected boolean nowarn = false;
    protected boolean deprecation = false;
    protected Path bootclassPath = null;
    protected String extdirs = null;
    protected String endorseddirs = null;
    protected boolean verbose = false;
    protected Path sourcePath = null;
    protected String encoding = null;
    protected String targetVM = null;
    protected boolean fork = false;
    protected List<FileSet> sourceFileset = new ArrayList<FileSet>();

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public void setSourcedestdir(File sourceBase) {
        this.sourceDestDir = sourceBase;
    }

    public File getSourcedestdir() {
        return this.sourceDestDir;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public List<Jvmarg> getJvmargs() {
        return this.jvmargs;
    }

    public Jvmarg createJvmarg() {
        Jvmarg jvmarg = new Jvmarg();
        this.jvmargs.add(jvmarg);
        return jvmarg;
    }

    public boolean isNocompile() {
        return this.noCompile;
    }

    public void setNocompile(boolean noCompile) {
        this.noCompile = noCompile;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public File getFactorypath() {
        return this.factoryPath;
    }

    public void setFactorypath(File factoryPath) {
        this.factoryPath = factoryPath;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public boolean isXlistannotationtypes() {
        return this.xListAnnotationTypes;
    }

    public void setXlistannotationtypes(boolean xListAnnotationTypes) {
        this.xListAnnotationTypes = xListAnnotationTypes;
    }

    public boolean isXlistdeclarations() {
        return this.xListDeclarations;
    }

    public void setXlistdeclarations(boolean xListDeclarations) {
        this.xListDeclarations = xListDeclarations;
    }

    public boolean isXprintaptrounds() {
        return this.xPrintAptRounds;
    }

    public void setXprintaptrounds(boolean xPrintAptRounds) {
        this.xPrintAptRounds = xPrintAptRounds;
    }

    public boolean isXprintfactoryinfo() {
        return this.xPrintFactoryInfo;
    }

    public void setXprintfactoryinfo(boolean xPrintFactoryInfo) {
        this.xPrintFactoryInfo = xPrintFactoryInfo;
    }

    public boolean isXclassesasdecls() {
        return this.xClassesAsDecls;
    }

    public void setXclassesasdecls(boolean xClassesAsDecls) {
        this.xClassesAsDecls = xClassesAsDecls;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDebuglevel() {
        return this.debugLevel;
    }

    public void setDebuglevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public void setNowarn(boolean nowarn) {
        this.nowarn = nowarn;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public Path getBootclasspath() {
        return this.bootclassPath;
    }

    public void setBootclasspath(Path bootclassPath) {
        this.bootclassPath = bootclassPath;
    }

    public String getExtdirs() {
        return this.extdirs;
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = extdirs;
    }

    public String getEndorseddirs() {
        return this.endorseddirs;
    }

    public void setEndorseddirs(String endorseddirs) {
        this.endorseddirs = endorseddirs;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Path getSourcepath() {
        return this.sourcePath;
    }

    public void setSourcepath(Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTarget() {
        return this.targetVM;
    }

    public void setTarget(String target) {
        this.targetVM = target;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void addConfiguredSource(FileSet fileset) {
        this.sourceFileset.add(fileset);
    }

    private Container setupAptCommand() {
        Container c = this.setupAptArgs();
        Path classpath = this.getClasspath();
        if (classpath != null && !classpath.toString().equals("")) {
            Apt.addValue(c.cmd, c.ap, "-classpath", classpath);
        }
        return c;
    }

    private Container setupAptForkCommand() {
        CommandlineJava forkCmd = new CommandlineJava();
        Path classpath = this.getClasspath();
        forkCmd.createClasspath(this.getProject()).append(classpath);
        forkCmd.setClassname("com.sun.tools.apt.Main");
        if (null != this.getJvmargs()) {
            for (Jvmarg jvmarg : this.jvmargs) {
                forkCmd.createVmArgument().setLine(jvmarg.getValue());
            }
        }
        Container c = this.setupAptArgs();
        c.cmd.createArgument(true).setLine(forkCmd.toString());
        forkCmd = new CommandlineJava();
        forkCmd.createClasspath(this.getProject()).append(classpath);
        forkCmd.setClassname("com.sun.tools.javac.Main");
        if (null != this.getJvmargs()) {
            for (Jvmarg jvmarg : this.jvmargs) {
                forkCmd.createVmArgument().setLine(jvmarg.getValue());
            }
        }
        c.ap.createArgument(true).setLine(forkCmd.toString());
        return c;
    }

    private Container setupAptArgs() {
        Commandline cmd = new Commandline();
        Commandline ap = new Commandline();
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            Apt.addValue(cmd, ap, "-d", this.getDestdir());
        }
        if (null != this.getSourcedestdir() && !this.getSourcedestdir().getName().equals("")) {
            Apt.addValue(cmd, ap, "-s", this.getSourcedestdir());
        }
        if (this.getSourcepath() == null) {
            throw new BuildException("\"sourcePath\" attribute must be set.");
        }
        if (this.getSourcepath() != null && !this.getSourcepath().toString().equals("")) {
            Apt.addValue(cmd, ap, "-sourcepath", this.getSourcepath().toString());
        }
        if (this.getBootclasspath() != null && !this.getBootclasspath().toString().equals("")) {
            Apt.addValue(cmd, ap, "-bootclasspath", this.getBootclasspath().toString());
        }
        if (this.getExtdirs() != null && !this.getExtdirs().equals("")) {
            Apt.addValue(cmd, ap, "-extdirs", this.getExtdirs());
        }
        if (this.getEndorseddirs() != null && !this.getEndorseddirs().equals("")) {
            Apt.addValue(cmd, ap, "-endorseddirs", this.getEndorseddirs());
        }
        if (this.isDebug()) {
            String debugOption = "-g";
            if (this.getDebuglevel() != null && !this.getDebuglevel().equals("")) {
                debugOption = debugOption + ":" + this.getDebuglevel();
            }
            cmd.createArgument().setValue(debugOption);
            ap.createArgument().setValue(debugOption);
        } else {
            Apt.addValue(cmd, ap, "-g:none");
        }
        if (this.isVerbose()) {
            Apt.addValue(cmd, ap, "-verbose");
        }
        if (this.getEncoding() != null && !this.getEncoding().equals("")) {
            Apt.addValue(cmd, ap, "-encoding", this.getEncoding());
        }
        if (this.getTarget() != null && !this.getTarget().equals("")) {
            Apt.addValue(cmd, ap, "-target", this.getTarget());
        }
        if (!this.fork) {
            for (Jvmarg jvmarg : this.jvmargs) {
                Apt.addValue(cmd, ap, "-J" + jvmarg.getValue());
            }
        }
        for (Option option : this.options) {
            Apt.addValue(cmd, ap, "-A" + option.getKey() + "=" + option.getValue());
        }
        if (this.isNowarn()) {
            Apt.addValue(cmd, ap, "-nowarn");
        }
        if (this.isNocompile()) {
            cmd.createArgument().setValue("-nocompile");
            ap.createArgument().setValue("-proc:only");
        }
        if (this.isDeprecation()) {
            Apt.addValue(cmd, ap, "-deprecation");
        }
        if (this.isPrint()) {
            cmd.createArgument().setValue("-print");
            ap.createArgument().setValue("-Xprint");
        }
        if (this.getFactorypath() != null) {
            cmd.createArgument().setValue("-factorypath");
            cmd.createArgument().setValue(this.getFactorypath().toString());
        }
        if (this.getFactory() != null) {
            cmd.createArgument().setValue("-factory");
            cmd.createArgument().setValue(this.getFactory());
        }
        if (this.isXlistannotationtypes()) {
            cmd.createArgument().setValue("-XListAnnotationTypes");
        }
        if (this.isXlistdeclarations()) {
            cmd.createArgument().setValue("-XListDeclarations");
        }
        if (this.isXprintaptrounds()) {
            cmd.createArgument().setValue("-XPrintAptRounds");
            ap.createArgument().setValue("-XprintRounds");
        }
        if (this.isXprintfactoryinfo()) {
            cmd.createArgument().setValue("-XPrintFactoryInfo");
            ap.createArgument().setValue("-XprintProcessorInfo");
        }
        if (this.isXprintfactoryinfo()) {
            cmd.createArgument().setValue("-XclassesAsDecls");
        }
        HashSet<File> sourceFiles = new HashSet<File>();
        this.prepareSourceList(sourceFiles);
        if (!sourceFiles.isEmpty()) {
            for (File source : sourceFiles) {
                cmd.createArgument().setFile(source);
                ap.createArgument().setFile(source);
            }
        }
        ap.createArgument().setValue("-processor");
        ap.createArgument().setValue("com.sun.tools.ws.processor.modeler.annotation.WebServiceAp");
        return new Container(cmd, ap);
    }

    private static void addValue(Commandline cmd, Commandline ap, String name) {
        Apt.addValue(cmd, ap, name, (String)null);
    }

    private static void addValue(Commandline cmd, Commandline ap, String name, String value) {
        cmd.createArgument().setValue(name);
        ap.createArgument().setValue(name);
        if (value != null) {
            cmd.createArgument().setValue(value);
            ap.createArgument().setValue(value);
        }
    }

    private static void addValue(Commandline cmd, Commandline ap, String name, Path value) {
        cmd.createArgument().setValue(name);
        ap.createArgument().setValue(name);
        if (value != null) {
            cmd.createArgument().setPath(value);
            ap.createArgument().setPath(value);
        }
    }

    private static void addValue(Commandline cmd, Commandline ap, String name, File value) {
        cmd.createArgument().setValue(name);
        ap.createArgument().setValue(name);
        if (value != null) {
            cmd.createArgument().setFile(value);
            ap.createArgument().setFile(value);
        }
    }

    void prepareSourceList(Set<File> sourceFiles) throws BuildException {
        if (this.sourceFileset != null) {
            for (FileSet fileset : this.sourceFileset) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                String[] includedFiles = ds.getIncludedFiles();
                File baseDir = ds.getBasedir();
                for (String includedFile : includedFiles) {
                    sourceFiles.add(new File(baseDir, includedFile));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        PrintWriter writer = null;
        try {
            Container c;
            Container container = c = this.fork ? this.setupAptForkCommand() : this.setupAptCommand();
            if (this.verbose) {
                this.log("command line: apt " + c.cmd.toString());
            }
            int status = 0;
            if (this.fork) {
                status = this.run(c.cmd.getCommandline());
                if (status == 0) {
                    status = this.run(c.ap.getCommandline());
                }
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                writer = new PrintWriter(baos);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    Main aptTool = new Main();
                    status = Main.process((PrintWriter)writer, (String[])c.cmd.getArguments());
                    writer.flush();
                    if (this.verbose || baos.size() != 0) {
                        this.log(baos.toString());
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
                if (status == 0) {
                    baos = new ByteArrayOutputStream();
                    writer = new PrintWriter(baos);
                    old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    try {
                        com.sun.tools.javac.Main mainTool = new com.sun.tools.javac.Main();
                        status = com.sun.tools.javac.Main.compile(c.ap.getArguments(), writer);
                        writer.flush();
                        if (this.verbose || baos.size() != 0) {
                            this.log(baos.toString());
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
            }
            if (status != 0) {
                if (!this.verbose) {
                    this.log("Command invoked: apt " + c.cmd.toString());
                }
                throw new BuildException("apt failed", this.location);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error starting apt: ", (Throwable)ex, this.getLocation());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }

    private static class Container {
        private Commandline cmd;
        private Commandline ap;

        private Container(Commandline commandline, Commandline ap) {
            this.cmd = commandline;
            this.ap = ap;
        }
    }

    public static class Jvmarg {
        protected String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Option {
        protected String key;
        protected String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

