/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryEntryImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;

public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme,
Serializable {
    transient boolean childrenLoaded = false;
    transient boolean isPredefined = false;
    ArrayList children = new ArrayList();

    public ClassificationSchemeImpl() {
    }

    public ClassificationSchemeImpl(Key key) {
        this();
        this.key = key;
    }

    public ClassificationSchemeImpl(Concept concept) throws JAXRException {
        this(concept.getKey());
        this.name = concept.getName();
        this.description = concept.getDescription();
    }

    public ClassificationSchemeImpl(Key key, String string2, String string3) {
        this(key);
        this.description = new InternationalStringImpl(string2);
        this.name = new InternationalStringImpl(string3);
    }

    public ClassificationSchemeImpl(String string2, String string3, String string4) {
        this(new KeyImpl(string2), string3, string4);
    }

    public ClassificationSchemeImpl(String string2, String string3) {
        this();
        this.name = new InternationalStringImpl(string2);
        this.description = new InternationalStringImpl(string3);
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.children.contains(concept)) {
            ((ConceptImpl)concept).setClassificationScheme(this);
            this.children.add(concept);
            this.childrenLoaded = true;
            this.setIsModified(true);
        }
    }

    public void addChildConcepts(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                ConceptImpl conceptImpl = (ConceptImpl)iterator.next();
                this.addChildConcept(conceptImpl);
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Objects_in_collection_must_be_Concepts"), classCastException);
        }
    }

    public void removeChildConcept(Concept concept) throws JAXRException {
        if (concept != null) {
            this.children.remove(concept);
            this.setIsModified(true);
        }
    }

    public void removeChildConcepts(Collection collection) throws JAXRException {
        if (collection != null) {
            this.children.removeAll(collection);
            this.setIsModified(true);
        }
    }

    public int getChildConceptCount() throws JAXRException {
        return this.children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return (Collection)this.children.clone();
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList arrayList = new ArrayList(this.children);
        for (Concept concept : this.children) {
            if (concept.getChildConceptCount() <= 0) continue;
            arrayList.addAll(concept.getDescendantConcepts());
        }
        return arrayList;
    }

    public boolean isExternal() {
        return this.children.size() == 0;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setPredefined(boolean bl) {
        this.isPredefined = bl;
    }

    public boolean childrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean bl) {
        this.childrenLoaded = bl;
    }

    public void addExternalLink(ExternalLink externalLink) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (externalLink != null) {
            ExternalLinkImpl externalLinkImpl = (ExternalLinkImpl)externalLink;
            externalLinkImpl.addLinkedObject(this);
            this.externalLinks.add(externalLinkImpl);
            this.setIsModified(true);
        }
    }

    public void addExternalLinks(Collection collection) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (collection != null) {
            if (collection.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    ExternalLinkImpl externalLinkImpl = (ExternalLinkImpl)iterator.next();
                    externalLinkImpl.addLinkedObject(this);
                    this.externalLinks.add(externalLinkImpl);
                    this.setIsModified(true);
                }
            }
            catch (ClassCastException classCastException) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Objects_in_collection_must_be_ExternalLinks"), classCastException);
            }
        }
    }

    public void setExternalLinks(Collection collection) throws JAXRException {
        if (collection == null) {
            this.externalLinks.clear();
            return;
        }
        if (collection.size() > 1) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Cannot_set_more_than_one_ExternalLink."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(collection);
    }

    public int getValueType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setValueType(int n) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

