/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.spi.db;

import com.sun.xml.ws.spi.db.BindingContext;
import com.sun.xml.ws.spi.db.BindingInfo;
import com.sun.xml.ws.spi.db.DatabindingException;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingContextFactory {
    public static final String DefaultDatabindingMode = "glassfish.jaxb";

    private static List<BindingContextFactory> factories() {
        ArrayList<BindingContextFactory> factories = new ArrayList<BindingContextFactory>();
        for (BindingContextFactory bcf : ServiceFinder.find(BindingContextFactory.class)) {
            factories.add(bcf);
        }
        return factories;
    }

    protected abstract BindingContext newContext(JAXBContext var1);

    protected abstract BindingContext newContext(BindingInfo var1);

    protected abstract boolean isFor(String var1);

    protected abstract BindingContext getContext(Marshaller var1);

    private static BindingContextFactory getFactory(String mode) {
        for (BindingContextFactory f : BindingContextFactory.factories()) {
            if (!f.isFor(mode)) continue;
            return f;
        }
        return null;
    }

    public static BindingContext create(JAXBContext context) throws DatabindingException {
        return BindingContextFactory.getJAXBFactory(context).newContext(context);
    }

    public static BindingContext create(BindingInfo bi) {
        BindingContextFactory f;
        String mode = bi.getDatabindingMode();
        if (mode == null) {
            mode = System.getProperty("BindingContextFactory");
        }
        if (mode == null) {
            mode = DefaultDatabindingMode;
        }
        if ((f = BindingContextFactory.getFactory(mode)) != null) {
            return f.newContext(bi);
        }
        throw new DatabindingException("Unknown Databinding mode: " + mode);
    }

    public static boolean isContextSupported(Object o) {
        if (o == null) {
            return false;
        }
        String pkgName = o.getClass().getPackage().getName();
        for (BindingContextFactory f : BindingContextFactory.factories()) {
            if (!f.isFor(pkgName)) continue;
            return true;
        }
        return false;
    }

    static BindingContextFactory getJAXBFactory(Object o) {
        String pkgName = o.getClass().getPackage().getName();
        BindingContextFactory f = BindingContextFactory.getFactory(pkgName);
        if (f != null) {
            return f;
        }
        throw new DatabindingException("Unknown JAXBContext implementation: " + o.getClass());
    }

    public static BindingContext getBindingContext(Marshaller m) {
        return BindingContextFactory.getJAXBFactory(m).getContext(m);
    }
}

