/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.HTTPBindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.developer.BindingTypeFeature;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements WSBinding {
    protected static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];
    protected HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();
    protected Service.Mode serviceMode = Service.Mode.PAYLOAD;

    protected BindingImpl(BindingID bindingId, WebServiceFeature ... features) {
        this.bindingId = bindingId;
        this.handlerConfig = new HandlerConfiguration(Collections.<String>emptySet(), Collections.<Handler>emptyList());
        this.setFeatures(features);
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setMode(@NotNull Service.Mode mode) {
        this.serviceMode = mode;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        for (WebServiceFeature feature : features) {
            if (!(feature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature f = (BindingTypeFeature)feature;
            bindingId = BindingID.parse(f.getBindingId());
        }
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl(features);
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> featureType) {
        return this.features.get(featureType);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        return this.features.isEnabled(feature);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        return this.features;
    }

    public void setFeatures(WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.features.add(f);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature newFeature) {
        this.features.add(newFeature);
    }
}

