/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message.saaj;

import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.saaj.SAAJMessage;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.xml.XmlUtil;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAAJFactory {
    private static final SAAJFactory instance = new SAAJFactory();

    public static MessageFactory getMessageFactory(String saajFactoryString) throws SOAPException {
        for (SAAJFactory s : ServiceFinder.find(SAAJFactory.class)) {
            MessageFactory mf = s.createMessageFactory(saajFactoryString);
            if (mf == null) continue;
            return mf;
        }
        return instance.createMessageFactory(saajFactoryString);
    }

    public static SOAPFactory getSOAPFactory(String saajFactoryString) throws SOAPException {
        for (SAAJFactory s : ServiceFinder.find(SAAJFactory.class)) {
            SOAPFactory sf = s.createSOAPFactory(saajFactoryString);
            if (sf == null) continue;
            return sf;
        }
        return instance.createSOAPFactory(saajFactoryString);
    }

    public static Message create(SOAPMessage saaj) {
        for (SAAJFactory s : ServiceFinder.find(SAAJFactory.class)) {
            Message m = s.createMessage(saaj);
            if (m == null) continue;
            return m;
        }
        return instance.createMessage(saaj);
    }

    public static SOAPMessage read(SOAPVersion soapVersion, Message message) throws SOAPException {
        for (SAAJFactory s : ServiceFinder.find(SAAJFactory.class)) {
            SOAPMessage msg = s.readAsSOAPMessage(soapVersion, message);
            if (msg == null) continue;
            return msg;
        }
        return instance.readAsSOAPMessage(soapVersion, message);
    }

    public MessageFactory createMessageFactory(String saajFactoryString) throws SOAPException {
        return MessageFactory.newInstance((String)saajFactoryString);
    }

    public SOAPFactory createSOAPFactory(String saajFactoryString) throws SOAPException {
        return SOAPFactory.newInstance((String)saajFactoryString);
    }

    public Message createMessage(SOAPMessage saaj) {
        return new SAAJMessage(saaj);
    }

    public SOAPMessage readAsSOAPMessage(SOAPVersion soapVersion, Message message) throws SOAPException {
        SOAPMessage msg = soapVersion.getMessageFactory().createMessage();
        SAX2DOMEx s2d = new SAX2DOMEx((Node)msg.getSOAPPart());
        try {
            message.writeTo((ContentHandler)s2d, XmlUtil.DRACONIAN_ERROR_HANDLER);
        }
        catch (SAXException e) {
            throw new SOAPException((Throwable)e);
        }
        for (Attachment att : message.getAttachments()) {
            AttachmentPart part = msg.createAttachmentPart();
            part.setDataHandler(att.asDataHandler());
            part.setContentId('<' + att.getContentId() + '>');
            msg.addAttachmentPart(part);
        }
        if (msg.saveRequired()) {
            msg.saveChanges();
        }
        return msg;
    }
}

