/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.message.stream.StreamHeader11;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StreamSOAP11Codec
extends StreamSOAPCodec {
    public static final String SOAP11_MIME_TYPE = "text/xml";
    public static final String DEFAULT_SOAP11_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final List<String> EXPECTED_CONTENT_TYPES = Collections.singletonList("text/xml");

    StreamSOAP11Codec() {
        super(SOAPVersion.SOAP_11);
    }

    StreamSOAP11Codec(WSBinding binding) {
        super(binding);
    }

    @Override
    public String getMimeType() {
        return SOAP11_MIME_TYPE;
    }

    @Override
    protected final StreamHeader createHeader(XMLStreamReader reader, XMLStreamBuffer mark) {
        return new StreamHeader11(reader, mark);
    }

    @Override
    protected ContentType getContentType(Packet packet) {
        return new ContentTypeImpl(this.getContenTypeStr(packet), packet.soapAction);
    }

    @Override
    protected String getDefaultContentType() {
        return DEFAULT_SOAP11_CONTENT_TYPE;
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return EXPECTED_CONTENT_TYPES;
    }
}

